/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.html;

import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.UriEffect;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import java.util.List;
import junit.framework.TestCase;

public class HtmlSchemaTest
extends TestCase {
    MessageQueue mq;
    HtmlSchema schema;

    public void setUp() throws Exception {
        this.mq = new SimpleMessageQueue();
        this.schema = HtmlSchema.getDefault(this.mq);
        HtmlSchemaTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testSchema() {
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("script")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("style")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("xmp")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("listing")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("frame")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("frameset")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("body")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("head")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("html")));
        HtmlSchemaTest.assertFalse((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("title")));
        HtmlSchemaTest.assertTrue((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("div")));
        HtmlSchemaTest.assertTrue((boolean)this.schema.isElementAllowed(HtmlSchemaTest.el("span")));
    }

    public final void testAttributeTypes() {
        HtmlSchemaTest.assertEquals((Object)((Object)HTML.Attribute.Type.STYLE), (Object)((Object)this.lookupAttribute("div", "style").getType()));
        HtmlSchemaTest.assertEquals((Object)((Object)HTML.Attribute.Type.SCRIPT), (Object)((Object)this.lookupAttribute("a", "onclick").getType()));
        HtmlSchemaTest.assertEquals((Object)((Object)HTML.Attribute.Type.URI), (Object)((Object)this.lookupAttribute("a", "href").getType()));
        HtmlSchemaTest.assertEquals((Object)((Object)HTML.Attribute.Type.NONE), (Object)((Object)this.lookupAttribute("a", "title").getType()));
    }

    public final void testAttributeMimeTypes() {
        HtmlSchemaTest.assertEquals((Object)((Object)LoaderType.SANDBOXED), (Object)((Object)this.lookupAttribute("img", "src").getLoaderType()));
        HtmlSchemaTest.assertEquals((Object)((Object)UriEffect.SAME_DOCUMENT), (Object)((Object)this.lookupAttribute("img", "src").getUriEffect()));
        HtmlSchemaTest.assertEquals((Object)((Object)LoaderType.UNSANDBOXED), (Object)((Object)this.lookupAttribute("script", "src").getLoaderType()));
        HtmlSchemaTest.assertEquals((Object)((Object)UriEffect.SAME_DOCUMENT), (Object)((Object)this.lookupAttribute("script", "src").getUriEffect()));
        HtmlSchemaTest.assertNull((Object)((Object)this.lookupAttribute("table", "cellpadding").getLoaderType()));
        HtmlSchemaTest.assertNull((Object)((Object)this.lookupAttribute("table", "cellpadding").getUriEffect()));
    }

    public final void testAttributeCriteria() {
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("a", "target").getValueCriterion().accept("_top"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("a", "target").getValueCriterion().accept("_blank"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("table", "cellpadding").getValueCriterion().accept("six"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("table", "cellpadding").getValueCriterion().accept("6"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("table", "width").getValueCriterion().accept("10%"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("table", "width").getValueCriterion().accept("%"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("script", "type").getValueCriterion().accept("text/vbscript"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("script", "type").getValueCriterion().accept("text/javascript"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("script", "type").getValueCriterion().accept("text/javascript;charset=UTF-8"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept("text"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept("TEXT"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept("button"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept("file"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept("FILE"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept("bogus"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("input", "type").getValueCriterion().accept(""));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("input", "checked").getValueCriterion().accept("checked"));
        HtmlSchemaTest.assertTrue((boolean)this.lookupAttribute("input", "checked").getValueCriterion().accept(""));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("input", "checked").getValueCriterion().accept("turkey"));
        HtmlSchemaTest.assertFalse((boolean)this.lookupAttribute("input", "checked").getValueCriterion().accept("no"));
    }

    public final void testSafeAndDefaultValues() {
        HTML.Attribute tgt = this.lookupAttribute("a", "target");
        HtmlSchemaTest.assertEquals((String)"_blank", (String)tgt.getSafeValue());
        HtmlSchemaTest.assertEquals((String)"_self", (String)tgt.getDefaultValue());
    }

    public final void testAttributeList() {
        HTML.Element a = this.schema.lookupElement(HtmlSchemaTest.el("a"));
        HtmlSchemaTest.assertEquals((Object)this.lookupAttribute("A", "HREF"), (Object)HtmlSchemaTest.withName(a, "HREF"));
        HtmlSchemaTest.assertEquals((Object)this.lookupAttribute("A", "ID"), (Object)HtmlSchemaTest.withName(a, "ID"));
        HtmlSchemaTest.assertEquals(null, (Object)HtmlSchemaTest.withName(a, "COLSPAN"));
        HTML.Element b = this.schema.lookupElement(HtmlSchemaTest.el("b"));
        HtmlSchemaTest.assertEquals((Object)this.lookupAttribute("B", "ID"), (Object)HtmlSchemaTest.withName(b, "ID"));
    }

    private HTML.Attribute lookupAttribute(String qualifiedEl, String qualifiedAttr) {
        AttribKey attr = AttribKey.forAttribute(Namespaces.HTML_DEFAULT, HtmlSchemaTest.el(qualifiedEl), qualifiedAttr);
        return this.schema.lookupAttribute(attr);
    }

    private static HTML.Attribute withName(HTML.Element el, String qname) {
        List<HTML.Attribute> attrs = el.getAttributes();
        AttribKey key = AttribKey.forAttribute(Namespaces.HTML_DEFAULT, el.getKey(), qname);
        HTML.Attribute result = null;
        for (HTML.Attribute a : attrs) {
            if (!key.localName.equals(a.getKey().localName) || key.ns.uri != a.getKey().ns.uri) continue;
            if (result != null) {
                throw new IllegalStateException("DUPE " + key);
            }
            result = a;
        }
        return result;
    }

    private static ElKey el(String qualifiedElName) {
        return ElKey.forElement(Namespaces.HTML_DEFAULT, qualifiedElName);
    }
}

