/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public abstract class NumberLiteral
extends Literal {
    private static final MathContext TWENTY_ONE_DIGITS_ROUNDED_TO_ZERO = new MathContext(21, RoundingMode.DOWN);

    protected NumberLiteral(FilePosition pos) {
        super(pos);
    }

    public abstract Number getValue();

    public abstract double doubleValue();

    public boolean getValueInBooleanContext() {
        double n = this.doubleValue();
        return !Double.isNaN(n) && 0.0 != n;
    }

    public static String numberToString(double m) {
        if (Double.isNaN(m)) {
            return "NaN";
        }
        if (m == 0.0) {
            return "0";
        }
        if (Double.isInfinite(m)) {
            return m >= 0.0 ? "Infinity" : "-Infinity";
        }
        return NumberLiteral.numberToString(new BigDecimal(m, TWENTY_ONE_DIGITS_ROUNDED_TO_ZERO));
    }

    public static String numberToString(BigDecimal m) {
        int cmp = BigDecimal.ZERO.compareTo(m);
        if (cmp == 0) {
            return "0";
        }
        if (cmp > 0) {
            return "-" + NumberLiteral.numberToString(m.abs());
        }
        if (m.precision() > 21) {
            m = new BigDecimal(m.unscaledValue(), m.scale(), TWENTY_ONE_DIGITS_ROUNDED_TO_ZERO);
            assert (m.precision() <= 21);
        }
        m = m.stripTrailingZeros();
        BigDecimal s = new BigDecimal(m.unscaledValue(), 0);
        int k = s.precision() - s.scale();
        int n = k - m.scale();
        String intRep = s.unscaledValue().toString();
        if (k <= n && n <= 21) {
            StringBuilder sb = new StringBuilder(n);
            sb.append(intRep.substring(0, k));
            while (sb.length() < n) {
                sb.append('0');
            }
            return sb.toString();
        }
        if (0 < n && n <= 21) {
            return intRep.substring(0, n) + "." + intRep.substring(n, Math.min(intRep.length(), 21));
        }
        if (-6 < n && n <= 0) {
            StringBuilder sb = new StringBuilder(2 + -n + k);
            sb.append("0.");
            int i = -n;
            while (--i >= 0) {
                sb.append('0');
            }
            sb.append(intRep, 0, k);
            return sb.toString();
        }
        if (k == 1) {
            return intRep + (n - 1 < 0 ? "e-" : "e+") + Math.abs(n - 1);
        }
        return intRep.substring(0, 1) + "." + intRep.substring(1, k) + (n - 1 < 0 ? "e-" : "e+") + Math.abs(n - 1);
    }

    public String typeOf() {
        return "number";
    }

    public JsonML toJsonML() {
        double d;
        FilePosition pos = this.getFilePosition();
        Number value = this.getValue();
        if (value instanceof Double && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            IntegerLiteral num = new IntegerLiteral(FilePosition.startOf(pos), Double.isNaN(d) ? 0L : (d < 0.0 ? -1L : 1L));
            IntegerLiteral den = new IntegerLiteral(FilePosition.endOf(pos), 0L);
            return Operation.createInfix(Operator.DIVISION, num, den).toJsonML();
        }
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.LiteralExpr, pos).setAttribute(TagAttr.TYPE, "number").setAttribute(TagAttr.VALUE, value).build();
    }
}

