/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectConstructor
extends AbstractExpression {
    @ParseTreeNode.ReflectiveCtor
    public ObjectConstructor(FilePosition pos, Void value, List<? extends ObjProperty> properties) {
        super(pos, ObjProperty.class);
        this.createMutation().appendChildren(properties).execute();
    }

    public ObjectConstructor(FilePosition pos, List<? extends ObjProperty> properties) {
        this(pos, null, properties);
    }

    public ObjectConstructor(FilePosition pos) {
        super(pos, ObjProperty.class);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        for (ObjProperty objProperty : this.children()) {
            if (objProperty instanceof ObjProperty) continue;
            throw new ClassCastException(objProperty.getClass().getName());
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends ObjProperty> children() {
        return this.childrenAs(ObjProperty.class);
    }

    public ObjProperty propertyWithName(String key) {
        for (ObjProperty objProperty : this.children()) {
            if (!key.equals(objProperty.getPropertyName())) continue;
            return objProperty;
        }
        return null;
    }

    @Override
    public Boolean conditionResult() {
        return true;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("{");
        boolean seen = false;
        for (ObjProperty objProperty : this.children()) {
            if (seen) {
                out.consume(",");
                out.consume("\n");
            } else {
                seen = true;
            }
            objProperty.render(rc);
        }
        out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
        out.consume("}");
    }

    @Override
    public String typeOf() {
        return "object";
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.ObjectExpr, this.getFilePosition()).addChildren(this.children()).build();
    }
}

