/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.RegexpLiteral;
import com.google.caja.parser.js.Statement;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Strings;
import com.google.caja.util.TestUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTest
extends CajaTestCase {
    public final void testParser() throws Exception {
        this.runParseTest("parsertest1.js", "parsergolden1.txt", "Reserved word else used as an identifier");
        Iterator<Message> msgs = this.mq.getMessages().iterator();
        this.assertNextMessage(msgs, MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, "parsertest1.js:11+29 - 33", Keyword.ELSE);
        this.assertNextMessage(msgs, MessageType.NOT_IE, "parsertest1.js:35+7 - 8", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest1.js:96+2", new Object[0]);
        ParserTest.assertTrue((!msgs.hasNext() ? 1 : 0) != 0);
    }

    public final void testParser2() throws Exception {
        this.runParseTest("parsertest2.js", "parsergolden2.txt", new String[0]);
        Iterator<Message> msgs = this.mq.getMessages().iterator();
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest2.js:4+3", new Object[0]);
        ParserTest.assertTrue((!msgs.hasNext() ? 1 : 0) != 0);
    }

    public final void testParser3() throws Exception {
        this.runParseTest("parsertest3.js", "parsergolden3.txt", new String[0]);
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testParser5() throws Exception {
        if (!TestUtil.isJava15()) {
            this.runParseTest("parsertest5.js", "parsergolden5.txt", new String[0]);
        }
    }

    public final void testParser7() throws Exception {
        this.runParseTest("parsertest7.js", "parsergolden7.txt", new String[0]);
    }

    public final void testParser8() throws Exception {
        this.runParseTest("parsertest8.js", "parsergolden8.txt", new String[0]);
    }

    public final void testParser9() throws Exception {
        this.runParseTest("parsertest9.js", "parsergolden9.txt", new String[0]);
    }

    public final void testParser10() throws Exception {
        this.runParseTest("parsertest10.js", "parsergolden10.txt", new String[0]);
        Iterator<Message> msgs = this.mq.getMessages().iterator();
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:14+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:15+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:20+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:21+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:26+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:27+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:32+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.SEMICOLON_INSERTED, "parsertest10.js:33+15", new Object[0]);
        this.assertNextMessage(msgs, MessageType.UNRECOGNIZED_DIRECTIVE_IN_PROLOGUE, "parsertest10.js:52+3 - 15", MessagePart.Factory.valueOf("bogusburps"));
        ParserTest.assertFalse((boolean)msgs.hasNext());
    }

    public final void testParser11() throws Exception {
        this.runParseTest("parsertest11.js", "parsergolden11.txt", new String[0]);
    }

    public final void testParseTreeRendering1() throws Exception {
        this.runRenderTest("parsertest1.js", "rendergolden1.txt", false, true);
    }

    public final void testParseTreeRendering2() throws Exception {
        this.runRenderTest("parsertest2.js", "rendergolden2.txt", false, false);
    }

    public final void testParseTreeRendering3() throws Exception {
        this.runRenderTest("parsertest3.js", "rendergolden3.txt", false, false);
    }

    public final void testParseTreeRendering4() throws Exception {
        this.runRenderTest("parsertest4.js", "rendergolden4.txt", false, false);
    }

    public final void testParseTreeRendering5() throws Exception {
        if (!TestUtil.isJava15()) {
            this.runRenderTest("parsertest5.js", "rendergolden5.txt", false, true);
        }
    }

    public final void testSecureParseTreeRendering6() throws Exception {
        this.runRenderTest("parsertest6.js", "rendergolden6.txt", true, false);
        String golden = Strings.toLowerCase(TestUtil.readResource(((Object)((Object)this)).getClass(), "rendergolden6.txt"));
        ParserTest.assertFalse((boolean)golden.contains("]]>"));
        ParserTest.assertFalse((boolean)golden.contains("<!"));
        ParserTest.assertFalse((boolean)golden.contains("<script"));
        ParserTest.assertFalse((boolean)golden.contains("</script"));
    }

    public final void testParseTreeRendering7() throws Exception {
        this.runRenderTest("parsertest7.js", "rendergolden7.txt", false, false);
    }

    public final void testParseTreeRendering8() throws Exception {
        this.runRenderTest("parsertest8.js", "rendergolden8.txt", true, false);
    }

    public final void testParseTreeRendering9() throws Exception {
        this.runRenderTest("parsertest9.js", "rendergolden9.txt", false, false);
    }

    public final void testParseTreeRendering11() throws Exception {
        this.runRenderTest("parsertest11.js", "rendergolden11.txt", false, false);
    }

    public final void testThrowAsRestrictedProduction() throws Exception {
        try {
            this.js(this.fromString("throw \n new Error()"));
            ParserTest.fail((String)"throw followed by newline should fail");
        }
        catch (ParseException ex) {
            ParserTest.assertEquals((Object)MessageType.EXPECTED_TOKEN, (Object)ex.getCajaMessage().getMessageType());
        }
        this.js(this.fromString("throw \\\n new Error()"));
    }

    public final void testCommaOperatorInReturn() throws Exception {
        Block bl = this.js(this.fromString("return 1  \n  , 2;"));
        ParserTest.assertTrue((String)("" + this.mq.getMessages()), (boolean)this.mq.getMessages().isEmpty());
        ParserTest.assertEquals((String)"{\n  return 1, 2;\n}", (String)ParserTest.render(bl));
    }

    public final void testRenderKeywordsAsIdentifiers() throws Exception {
        for (Keyword k : Keyword.values()) {
            this.assertRenderKeywordAsIdentifier(k);
        }
    }

    public final void testParseKeywordsAsIdentifiers() {
        for (Keyword k : Keyword.values()) {
            this.assertParseKeywordAsIdentifier(k);
        }
    }

    public final void testDebuggerKeyword() {
        this.assertParseSucceeds("{ debugger; }");
        this.assertParseFails("(debugger);");
        this.assertMessage(MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
        this.assertParseFails("debugger();");
        this.assertMessage(MessageType.EXPECTED_TOKEN, MessageLevel.ERROR, MessagePart.Factory.valueOf(";"), MessagePart.Factory.valueOf("("));
        this.assertParseFails("var debugger;");
        this.assertMessage(MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
        this.assertParseFails("debugger: foo();");
        this.assertMessage(MessageType.EXPECTED_TOKEN, MessageLevel.ERROR, MessagePart.Factory.valueOf(";"), MessagePart.Factory.valueOf(":"));
    }

    public final void testOctalLiterals() throws Exception {
        ParserTest.assertEquals((String)"10", (String)ParserTest.render(this.jsExpr(this.fromString("012"))));
        this.assertMessage(MessageType.OCTAL_LITERAL, MessageLevel.LINT, new MessagePart[0]);
        this.mq.getMessages().clear();
        ParserTest.assertEquals((String)"12", (String)ParserTest.render(this.jsExpr(this.fromString("12"))));
        ParserTest.assertTrue((String)("" + this.mq.getMessages()), (boolean)this.mq.getMessages().isEmpty());
        this.mq.getMessages().clear();
        ParserTest.assertEquals((String)"18.0", (String)ParserTest.render(this.jsExpr(this.fromString("018"))));
        this.assertMessage(MessageType.OCTAL_LITERAL, MessageLevel.ERROR, new MessagePart[0]);
        this.mq.getMessages().clear();
        try {
            ParserTest.assertEquals((String)"018i", (String)ParserTest.render(this.jsExpr(this.fromString("018i"))));
            ParserTest.fail((String)"numeric literal with disallowed letter suffix allowed");
        }
        catch (ParseException ex) {
            this.mq.getMessages().add(ex.getCajaMessage());
        }
        this.assertMessage(MessageType.INVALID_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
        this.mq.getMessages().clear();
        ParserTest.assertEquals((String)"-10", (String)ParserTest.render(this.jsExpr(this.fromString("-012"))));
        this.assertMessage(MessageType.OCTAL_LITERAL, MessageLevel.LINT, new MessagePart[0]);
        this.mq.getMessages().clear();
        try {
            ParserTest.assertEquals((String)"12.34", (String)ParserTest.render(this.jsExpr(this.fromString("012.34"))));
            ParserTest.fail((String)"012.34 is not legal javascript.");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.mq.getMessages().clear();
        ParserTest.assertEquals((String)"(10).toString()", (String)ParserTest.render(this.jsExpr(this.fromString("012.\ntoString()"))));
        this.assertMessage(MessageType.OCTAL_LITERAL, MessageLevel.LINT, new MessagePart[0]);
    }

    public final void testIntegerPartIsOctal() {
        ParserTest.assertTrue((boolean)Parser.integerPartIsOctal("012"));
        ParserTest.assertTrue((boolean)Parser.integerPartIsOctal("0012"));
        ParserTest.assertTrue((boolean)Parser.integerPartIsOctal("012.34"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("12"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("12.34"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("0x12"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("0"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("00"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("0.01"));
        ParserTest.assertFalse((boolean)Parser.integerPartIsOctal("0.12"));
    }

    public final void testNUL() throws Exception {
        ParserTest.assertEquals((String)"'\\x00'", (String)ParserTest.render(this.jsExpr(this.fromString("'\u0000'"))));
    }

    private String expand(String template, String value) throws ParseException {
        return template.replace("@@", value);
    }

    private String unicodeMunge(String k) throws IOException {
        StringBuilder munged = new StringBuilder();
        munged.append(k, 0, k.length() - 1);
        Escaping.unicodeEscape(k.charAt(k.length() - 1), munged);
        return munged.toString();
    }

    public final void testUnicodeInKeywords() throws Exception {
        String[] templates = new String[]{"function @@ (a){}", "function foo(@@) {}", "function foo(a, @@) {}", "function foo(a, b) { @@(){}; }", "function foo(a, b) { @@: bar(){}; }"};
        for (Keyword k : Keyword.values()) {
            for (String template : templates) {
                String mungedKeyword = this.unicodeMunge(k.toString());
                String candidate = this.expand(template, mungedKeyword);
                try {
                    Block ptn = this.js(this.fromString(candidate));
                }
                catch (Exception e) {
                    ParserTest.assertTrue((boolean)(e instanceof ParseException));
                }
                this.assertMessage(true, MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
            }
        }
    }

    public final void testRenderingOfMalformedRegexSafe() {
        ParserTest.assertEquals((String)"(new (/./.constructor)('foo', 'iii'))", (String)ParserTest.render(new RegexpLiteral(FilePosition.UNKNOWN, "/foo/iii")));
        ParserTest.assertEquals((String)"(new (/./.constructor)('', ''))", (String)ParserTest.render(new RegexpLiteral(FilePosition.UNKNOWN, "//")));
        ParserTest.assertEquals((String)"(new (/./.constructor)('x', '\\''))", (String)ParserTest.render(new RegexpLiteral(FilePosition.UNKNOWN, "/x/'")));
    }

    public final void testOutOfRangeLiterals() throws Exception {
        NumberLiteral l = (NumberLiteral)this.jsExpr(this.fromString("0x7fffffffffffffff"));
        this.assertMessage(MessageType.UNREPRESENTABLE_INTEGER_LITERAL, MessageLevel.WARNING, new MessagePart[0]);
        ParserTest.assertEquals((Object)new Double(9.223372036854776E18), (Object)l.getValue());
    }

    public final void testOutOfRangeLiterals2() throws Exception {
        this.jsExpr(this.fromString("99999999999999999999999"));
        this.assertMessage(MessageType.UNREPRESENTABLE_INTEGER_LITERAL, MessageLevel.WARNING, new MessagePart[0]);
    }

    public final void testRedundantEscapeSequences() throws Exception {
        this.jsExpr(this.fromString(" new RegExp('foo\\s+bar') "));
        this.assertMessage(MessageType.REDUNDANT_ESCAPE_SEQUENCE, MessageLevel.LINT, FilePosition.instance(this.is, 1, 13, 13, 11), MessagePart.Factory.valueOf("\\s"));
        this.mq.getMessages().clear();
        this.jsExpr(this.fromString(" new RegExp('foo\\\\s+bar') "));
        this.assertMessagesLessSevereThan(MessageLevel.LINT);
        this.mq.getMessages().clear();
        this.jsExpr(this.fromString(" '<\\/script>' "));
        this.assertMessagesLessSevereThan(MessageLevel.LINT);
        this.mq.getMessages().clear();
        this.jsExpr(this.fromString(" '\\v' "));
        this.assertMessage(MessageType.AMBIGUOUS_ESCAPE_SEQUENCE, MessageLevel.WARNING, new MessagePart[0]);
        this.mq.getMessages().clear();
    }

    public final void testUnnormalizedIdentifiers() {
        try {
            this.js(this.fromString("C\u001a7();"));
            ParserTest.fail((String)"Unnormalized identifier parsed without incident");
        }
        catch (ParseException ex) {
            this.mq.getMessages().add(ex.getCajaMessage());
        }
        this.assertMessage(MessageType.INVALID_IDENTIFIER, MessageLevel.ERROR, MessagePart.Factory.valueOf("C\u001a7"));
    }

    public final void testRenderingOfRebuiltConditionals() throws ParseException {
        ParserTest.assertEquals((String)ParserTest.render(this.js(this.fromString("if (foo) { if (bar);} else baz"))), (String)ParserTest.render(ParserTest.stripBlocks(this.js(this.fromString("if (foo) { if (bar) {} } else baz")))));
        ParserTest.assertEquals((String)ParserTest.render(this.js(this.fromString("if (foo) { while (foo) if (bar) break; } else baz"))), (String)ParserTest.render(ParserTest.stripBlocks(this.js(this.fromString("if (foo) { while (foo) if (bar) break; } else baz")))));
    }

    public final void testMissingSemis() throws ParseException {
        this.js(this.fromString("foo();"));
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
        this.js(this.fromString("foo(\n  42);"));
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
        this.js(this.fromString("foo\n(42);"));
        this.assertMessage(true, MessageType.MAYBE_MISSING_SEMI, MessageLevel.WARNING, new MessagePart[0]);
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
        this.js(this.fromString("foo[42];"));
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
        this.js(this.fromString("foo[\n  42];"));
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
        this.js(this.fromString("foo\n[42];"));
        this.assertMessage(true, MessageType.MAYBE_MISSING_SEMI, MessageLevel.WARNING, new MessagePart[0]);
        ParserTest.assertTrue((boolean)this.mq.getMessages().isEmpty());
    }

    public final void testCommas() {
        try {
            this.js(this.fromString("[1 2]"));
        }
        catch (ParseException ex) {
            return;
        }
        ParserTest.fail((String)"Commas not required");
    }

    private void assertParseKeywordAsIdentifier(Keyword k) {
        this.assertAllowKeywordPropertyAccessor(k);
        this.assertAllowKeywordPropertyDeclaration(k);
        this.assertRejectKeywordAsExpr(k);
        this.assertRejectKeywordInVarDecl(k);
    }

    private void assertAllowKeywordPropertyAccessor(Keyword k) {
        this.assertParseSucceeds(ParserTest.asLvalue("foo." + k));
        this.assertParseSucceeds(ParserTest.asRvalue("foo." + k));
        this.assertParseSucceeds(ParserTest.asLvalue("foo." + k + ".bar"));
        this.assertParseSucceeds("foo." + k + ".bar;");
    }

    private void assertAllowKeywordPropertyDeclaration(Keyword k) {
        this.assertParseSucceeds("({ " + k + " : 42 });");
    }

    private void assertRejectKeywordAsExpr(Keyword k) {
        this.assertParseKeyword(ParserTest.asLvalue(k.toString()), ParserTest.isValidLvalue(k));
        this.assertParseKeyword(ParserTest.asRvalue(k.toString()), ParserTest.isValidRvalue(k));
        this.assertParseKeyword(ParserTest.asLvalue(k + ".foo"), ParserTest.isValidRvalue(k));
        this.assertParseKeyword(ParserTest.asRvalue(k + ".foo"), ParserTest.isValidRvalue(k));
    }

    private void assertRejectKeywordInVarDecl(Keyword k) {
        this.assertParseFails("var " + k + ";");
        this.assertMessage(MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
        this.assertParseFails("var foo, " + k + ", bar;");
        this.assertMessage(MessageType.RESERVED_WORD_USED_AS_IDENTIFIER, MessageLevel.ERROR, new MessagePart[0]);
    }

    private void assertParseKeyword(String code, boolean shouldSucceed) {
        if (shouldSucceed) {
            this.assertParseSucceeds(code);
        } else {
            this.assertParseFails(code);
        }
    }

    private void assertParseSucceeds(String code) {
        this.mq.getMessages().clear();
        try {
            this.js(this.fromString(code));
        }
        catch (ParseException ex) {
            AssertionFailedError afe = new AssertionFailedError(code);
            afe.initCause((Throwable)ex);
            throw afe;
        }
        try {
            this.assertNoErrors();
        }
        catch (AssertionFailedError e) {
            this.log("assertParseSucceeds", code);
            throw e;
        }
    }

    private void assertParseFails(String code) {
        this.mq.getMessages().clear();
        try {
            this.js(this.fromString(code));
        }
        catch (ParseException e) {
            e.toMessageQueue(this.mq);
        }
        for (Message msg : this.mq.getMessages()) {
            if (msg.getMessageLevel().compareTo(MessageLevel.ERROR) < 0) continue;
            return;
        }
        this.log("assertParseFails", code);
        ParserTest.fail((String)"expected failure");
    }

    private static boolean isValidLvalue(Keyword k) {
        return Keyword.THIS == k;
    }

    private static boolean isValidRvalue(Keyword k) {
        return Keyword.THIS == k || Keyword.TRUE == k || Keyword.FALSE == k || Keyword.NULL == k;
    }

    private static String asLvalue(String expr) {
        return expr + " = 42;";
    }

    private static String asRvalue(String expr) {
        return "x = " + expr + ";";
    }

    private void assertNextMessage(Iterator<Message> msgs, MessageType type, String filePositionString, Object ... otherMessageParts) throws Exception {
        ParserTest.assertTrue((boolean)msgs.hasNext());
        Message m = msgs.next();
        ParserTest.assertEquals((Object)type, (Object)m.getMessageType());
        this.assertFilePosition(filePositionString, (FilePosition)m.getMessageParts().get(0), this.mc);
        for (int i = 0; i < otherMessageParts.length; ++i) {
            ParserTest.assertEquals((Object)otherMessageParts[i], (Object)m.getMessageParts().get(i + 1));
        }
    }

    private void assertRenderKeywordAsIdentifier(Keyword k) throws Exception {
        this.assertRenderKeywordPropertyAccessor(k);
        this.assertRenderKeywordPropertyDeclaration(k);
    }

    private void assertRenderKeywordPropertyAccessor(Keyword k) throws Exception {
        this.assertRender("x." + k + " = 42;", "x[ '" + k + "' ] = 42");
        this.assertRender("y = x." + k + ";", "y = x[ '" + k + "' ]");
        this.assertRender("x." + k + ".z = 42;", "x[ '" + k + "' ].z = 42");
        this.assertRender("y = x." + k + ".z;", "y = x[ '" + k + "' ].z");
    }

    private void assertRenderKeywordPropertyDeclaration(Keyword k) throws Exception {
        this.assertRender("({" + k + ": 42});", "({ '" + k + "': 42 })");
    }

    private void assertRender(String code, String expectedRendering) throws Exception {
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        RenderContext rc = new RenderContext(tc).withAsciiOnly(true).withEmbeddable(true);
        this.js(this.fromString(code)).children().get(0).render(rc);
        tc.noMoreTokens();
        ParserTest.assertEquals((String)code, (String)expectedRendering, (String)sb.toString());
    }

    private void log(String testName, String code) {
        System.err.println();
        System.err.println("*** " + testName + ": " + code);
    }

    private void runRenderTest(String testFile, String goldenFile, boolean embeddable, boolean asciiOnly) throws Exception {
        Block parseTree = this.js(this.fromResource(testFile));
        ParserTest.checkFilePositionInvariants(parseTree);
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter tc = new JsPrettyPrinter(new Concatenator(sb));
        RenderContext rc = new RenderContext(tc).withAsciiOnly(asciiOnly).withEmbeddable(embeddable);
        parseTree.render(rc);
        tc.noMoreTokens();
        sb.append('\n');
        String golden = TestUtil.readResource(((Object)((Object)this)).getClass(), goldenFile);
        String actual = sb.toString();
        ParserTest.assertEquals((String)actual, (String)golden, (String)actual);
    }

    private void assertFilePosition(String golden, FilePosition actual, MessageContext mc) throws IOException {
        StringBuilder sb = new StringBuilder();
        actual.format(mc, sb);
        ParserTest.assertEquals((String)golden, (String)sb.toString());
    }

    private void runParseTest(String testFile, String goldenFile, String ... errors) throws Exception {
        Block parseTree = this.js(this.fromResource(testFile));
        this.assertCloneable(parseTree);
        ParserTest.checkFilePositionInvariants(parseTree);
        StringBuilder output = new StringBuilder();
        parseTree.format(this.mc, output);
        output.append('\n');
        String golden = TestUtil.readResource(((Object)((Object)this)).getClass(), goldenFile);
        ParserTest.assertEquals((String)golden, (String)output.toString());
        Statement cloneParseTree = (Statement)((Object)parseTree).clone();
        StringBuilder cloneOutput = new StringBuilder();
        cloneParseTree.format(this.mc, cloneOutput);
        cloneOutput.append('\n');
        ParserTest.assertEquals((String)golden, (String)cloneOutput.toString());
        ArrayList<String> actualErrors = new ArrayList<String>();
        for (Message m : this.mq.getMessages()) {
            if (MessageLevel.ERROR.compareTo(m.getMessageLevel()) > 0) continue;
            String error = m.toString();
            actualErrors.add(error.substring(error.indexOf(": ") + 2));
        }
        List<String> expectedErrors = Arrays.asList(errors);
        MoreAsserts.assertListsEqual(expectedErrors, actualErrors);
    }

    private static void checkFilePositionInvariants(ParseTreeNode root) {
        ParserTest.checkFilePositionInvariants(AncestorChain.instance(root));
    }

    private static void checkFilePositionInvariants(AncestorChain<?> nChain) {
        Object n = nChain.node;
        String msg = n + " : " + n.getFilePosition();
        try {
            List<? extends ParseTreeNode> children;
            ParseTreeNode prev;
            int indexInParent = nChain.parent != null ? nChain.parent.node.children().indexOf(nChain.node) : -1;
            ParseTreeNode parseTreeNode = prev = indexInParent > 0 ? nChain.parent.node.children().get(indexInParent - 1) : null;
            if (prev != null) {
                if (prev instanceof Identifier && n instanceof FunctionConstructor && nChain.parent != null && nChain.parent.node instanceof FunctionDeclaration) {
                    ParserTest.assertEquals((String)msg, (Object)prev.getFilePosition(), (Object)((FunctionDeclaration)nChain.parent.cast(FunctionDeclaration.class).node).getIdentifier().getFilePosition());
                } else {
                    ParserTest.assertTrue((String)msg, (prev.getFilePosition().endCharInFile() <= n.getFilePosition().startCharInFile() ? 1 : 0) != 0);
                }
            }
            if (!(children = n.children()).isEmpty()) {
                ParseTreeNode first = children.get(0);
                ParseTreeNode parseTreeNode2 = children.get(children.size() - 1);
                ParserTest.assertTrue((String)(msg + " > " + first + " : " + first.getFilePosition()), (first.getFilePosition().startCharInFile() >= n.getFilePosition().startCharInFile() ? 1 : 0) != 0);
                ParserTest.assertTrue((String)(msg + " < " + parseTreeNode2 + " : " + parseTreeNode2.getFilePosition()), (parseTreeNode2.getFilePosition().endCharInFile() <= n.getFilePosition().endCharInFile() ? 1 : 0) != 0);
            }
            for (ParseTreeNode parseTreeNode3 : children) {
                ParserTest.checkFilePositionInvariants(AncestorChain.instance(nChain, parseTreeNode3));
            }
        }
        catch (RuntimeException ex) {
            throw new SomethingWidgyHappenedError(msg, (Throwable)ex);
        }
    }

    private static Statement stripBlocks(Block b) {
        b.acceptPostOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> chain) {
                if (chain.node instanceof Block && chain.parent != null) {
                    Block b = (Block)chain.cast(Block.class).node;
                    List<? extends Statement> children = b.children();
                    switch (children.size()) {
                        case 0: {
                            ((MutableParseTreeNode)chain.parent.cast(MutableParseTreeNode.class).node).replaceChild(new Noop(b.getFilePosition()), b);
                            break;
                        }
                        case 1: {
                            ((MutableParseTreeNode)chain.parent.cast(MutableParseTreeNode.class).node).replaceChild(children.get(0), b);
                        }
                    }
                }
                return true;
            }
        }, null);
        return b;
    }
}

