/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reference
extends AbstractExpression {
    private Identifier identifier;

    @ParseTreeNode.ReflectiveCtor
    public Reference(FilePosition pos, Void value, List<ParseTreeNode> children) {
        super(pos, Identifier.class);
        this.appendChild(children.get(0));
    }

    public Reference(Identifier identifier) {
        super(identifier.getFilePosition(), Identifier.class);
        this.appendChild(identifier);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        this.identifier = (Identifier)children.get(0);
        if (this.identifier.getName() == null) {
            throw new NullPointerException("Cannot build Reference with null identifier");
        }
        if (children.size() > 1) {
            throw new IllegalArgumentException("Reference has extraneous children " + children.subList(1, children.size()));
        }
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierName() {
        return this.identifier.getName();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean isLeftHandSide() {
        return true;
    }

    @Override
    public void render(RenderContext rc) {
        Identifier ident = this.getIdentifier();
        if (ident.getName() == null) {
            throw new IllegalStateException("null name for declaration at " + this.getFilePosition());
        }
        ident.render(rc);
    }

    @Override
    public String typeOf() {
        return null;
    }

    @Override
    public JsonML toJsonML() {
        String name = this.getIdentifierName();
        if (Keyword.THIS.toString().equals(name)) {
            return JsonMLCompatible.JsonMLBuilder.builder(TagType.ThisExpr, this.getFilePosition()).build();
        }
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.IdExpr, this.getFilePosition()).setAttribute(TagAttr.NAME, name).build();
    }

    JsonML toJsonMLStr() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.LiteralExpr, this.getFilePosition()).setAttribute(TagAttr.TYPE, "string").setAttribute(TagAttr.VALUE, this.getIdentifierName()).build();
    }
}

