/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaModuleRewriter;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.CommonJsRewriterTestCase;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.Executor;
import com.google.caja.util.FailureIsAnOption;
import com.google.caja.util.Lists;
import com.google.caja.util.RhinoTestBed;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import junit.framework.AssertionFailedError;

public class CajitaRewriterTest
extends CommonJsRewriterTestCase {
    protected Rewriter cajitaRewriter;

    public void setUp() throws Exception {
        super.setUp();
        this.cajitaRewriter = new CajitaRewriter(TestBuildInfo.getInstance(), this.mq, false);
        this.setRewriter(this.cajitaRewriter);
    }

    private static String weldSetPub(String obj, String varName, String value, String tempObj, String tempValue) {
        return tempObj + " = " + obj + "," + tempValue + " = " + value + "," + "    " + tempObj + "." + varName + "_canSet___ === " + tempObj + " ?" + "    " + tempObj + "." + varName + " = " + tempValue + ":" + "    ___.setPub(" + tempObj + ", '" + varName + "', " + tempValue + ")";
    }

    private static String weldReadPub(String obj, String varName, String tempObj) {
        return CajitaRewriterTest.weldReadPub(obj, varName, tempObj, false);
    }

    private static String weldReadPub(String obj, String varName, String tempObj, boolean flag) {
        return "((" + tempObj + " = " + obj + ")," + "(" + tempObj + "." + varName + "_canRead___ ?" + "    " + tempObj + "." + varName + ":" + "    ___.readPub(" + tempObj + ", '" + varName + "'" + (flag ? ", true" : "") + "))" + ")";
    }

    private static String weldPreludes(String ... names) {
        Arrays.sort(names);
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append("var ").append(name).append(" = ___.readImport(IMPORTS___, ").append(StringLiteral.toQuotedValue(name)).append(");\n");
        }
        return sb.toString();
    }

    private static String weldPrelude(String name) {
        return CajitaRewriterTest.weldPreludes(name);
    }

    private static String weldPrelude(String name, String permitsUsed) {
        return "var " + name + " = ___.readImport(IMPORTS___, '" + name + "', " + permitsUsed + ");";
    }

    public final void testToString() throws Exception {
        this.assertConsistent("var z = { toString: function () { return 'blah'; } };try {  '' + z;} catch (e) {  throw new Error('PlusPlus error: ' + e);}");
        this.assertConsistent("  function foo() {  var x = 1;  return {    toString: function () {      return x;    }  };}'' + (new foo);");
        this.rewriteAndExecute("testImports.exports = {};", "exports.obj = {toString:function(){return '1';}};", "if (testImports.exports.obj.toString_canSet___) {  fail('toString fastpath gets set.');}");
        this.rewriteAndExecute("testImports.exports = {};", "exports.objMaker = function(f) { return { prop: f }; };", "assertThrows(function() {testImports.exports.objMaker(function(){return '1';});});");
        this.rewriteAndExecute("testImports.exports = {};", "function objMaker(f) {return {toString:f};}exports.objMaker = objMaker;", "assertThrows(function() {testImports.exports.objMaker(function(){return '1';});});");
    }

    public final void testInitializeMap() throws Exception {
        this.assertConsistent("var zerubabel = {bobble:2, apple:1}; zerubabel.apple;");
    }

    public final void testValueOf() throws Exception {
        this.checkFails("var a = {valueOf:1};", "The valueOf property must not be set");
        this.checkFails("var a = {x:0,valueOf:1};", "The valueOf property must not be set");
        this.checkFails("var a={}; a.valueOf=1;", "The valueOf property must not be set");
        this.checkFails("  function f(){}f.prototype.valueOf=1;", "The valueOf property must not be set");
        this.checkFails("var a={}; delete a.valueOf;", "The valueOf property must not be deleted");
        this.rewriteAndExecute("var a={}; assertThrows(function(){a['valueOf']=1;});");
        this.rewriteAndExecute("var a={}; assertThrows(function(){delete a['valueOf'];});");
        this.checkFails("var x = { valueOf: function (hint) { return 2; } };", "The valueOf property must not be set");
        this.checkFails("var x = { valueOf: function (hint) { return 2; }, x: y };", "The valueOf property must not be set");
        this.checkFails("var o = {}; o.valueOf = function (hint) { return 2; };", "The valueOf property must not be set");
    }

    public final void testFunctionDoesNotMaskVariable() throws Exception {
        this.checkSucceeds("function boo() { return x; }var x;", "var x;function boo() {\n  return x;\n}\nboo.FUNC___ = 'boo';");
    }

    public final void testAssertEqualsCajoled() throws Exception {
        try {
            this.rewriteAndExecute("assertEquals(1, 2);");
        }
        catch (AssertionFailedError e) {
            return;
        }
        CajitaRewriterTest.fail((String)"Assertions do not work in cajoled mode");
    }

    public final void testAssertThrowsCajoledNoError() throws Exception {
        this.rewriteAndExecute("  assertThrows(function() { throw 'foo'; });");
        this.rewriteAndExecute("  assertThrows(    function() { throw 'foo'; },    'foo');");
    }

    public final void testAssertThrowsCajoledErrorNoMsg() throws Exception {
        try {
            this.rewriteAndExecute("assertThrows(function() {});");
        }
        catch (AssertionFailedError e) {
            return;
        }
        CajitaRewriterTest.fail((String)"Assertions do not work in cajoled mode");
    }

    public final void testAssertThrowsCajoledErrorWithMsg() throws Exception {
        try {
            this.rewriteAndExecute("assertThrows(function() {}, 'foo');");
        }
        catch (AssertionFailedError e) {
            return;
        }
        CajitaRewriterTest.fail((String)"Assertions do not work in cajoled mode");
    }

    public final void testFreeVariables() throws Exception {
        this.checkSucceeds("var y = x;", CajitaRewriterTest.weldPrelude("x") + "var y;" + "y = x;");
        this.checkSucceeds("function() { var y = x; };", CajitaRewriterTest.weldPrelude("x") + "___.markFuncFreeze(function() {" + "var y;" + "y = x;" + "});");
    }

    public final void testConstructionWithFunction() throws Exception {
        this.assertConsistent("  function Point() {}var p = new Point();(p !== undefined);");
        this.assertConsistent("  var Point = function() {};var p = new Point();(p !== undefined);");
    }

    public final void testReflectiveMethodInvocation() throws Exception {
        this.assertConsistent("(function (first, second) { return 'a' + first + 'b' + second; }).call([], 8, 9);");
        this.assertConsistent("var a = []; [].push.call(a, 5, 6); a;");
        this.assertConsistent("(function (a, b) { return 'a' + a + 'b' + b; }).apply([], [8, 9]);");
        this.assertConsistent("var a = []; [].push.apply(a, [5, 6]); a;");
        this.assertConsistent("[].sort.apply([6, 5]);");
        this.assertConsistent("(function (first, second) { return 'a' + first + 'b' + second; }).bind([], 8)(9);");
    }

    public final void testToxicBind() throws Exception {
        this.rewriteAndExecute("var confused = false;testImports.keystone = function keystone() { confused = true; };", "assertThrows(function() {keystone.bind()();});", "assertFalse(confused);");
    }

    public final void testBadDelete() throws Exception {
        this.rewriteAndExecute("testImports.badContainer = {secret__: 3469};", "assertThrows(function() {delete badContainer['secret__'];});", "assertEquals(testImports.badContainer.secret__, 3469);");
        this.rewriteAndExecute("assertThrows(function() {delete ({})['proto___'];});");
    }

    public final void testNameFuncExprScoping() throws Exception {
        this.rewriteAndExecute("assertEquals(0, function() { \n  var propertyIsEnumerable = 0;\n  return (function f() {\n    return propertyIsEnumerable;\n  })();\n}());");
    }

    public final void testCajaPropsFrozen() throws Exception {
        this.rewriteAndExecute(";", "0;", "assertTrue(___.isFunc(___.sharedImports.cajita.manifest));");
        this.rewriteAndExecute(";", "0;", "assertTrue(___.isFrozen(___.sharedImports.cajita.manifest));");
    }

    public final void testStringIndexing() throws Exception {
        this.rewriteAndExecute("assertEquals('b', 'abc'[1]);");
    }

    @FailureIsAnOption
    public final void testStringIndexing2() throws Exception {
        this.rewriteAndExecute("assertEquals('b', 'abc'['1']);");
    }

    public final void testAttachedReflection() throws Exception {
        this.rewriteAndExecute("function f() {}\nf.apply;");
    }

    public final void testInVeil() throws Exception {
        this.rewriteAndExecute("assertFalse('FROZEN___' in Object);");
    }

    public final void testSyntheticIsUntouched() throws Exception {
        Block input = this.js(this.fromString("function foo() { this; arguments; }"));
        this.syntheticTree(input);
        this.checkSucceeds(input, input);
    }

    public final void testSyntheticMemberAccess() throws Exception {
        Block input = this.js(this.fromString("({}).foo"));
        this.syntheticTree(input);
        this.checkSucceeds(input, this.js(this.fromString("___.iM([]).foo;")));
    }

    public final void testSyntheticNestedIsExpanded() throws Exception {
        Block innerInput = this.js(this.fromString("function foo() {}"));
        Block input = new Block(FilePosition.UNKNOWN, Arrays.asList(innerInput));
        this.makeSynthetic(input);
        Block expectedResult = this.js(this.fromString("var foo; { foo = (function () {\n             function foo$_self() {\n             }\n             foo$_self.FUNC___ = 'foo';\n             return foo$_self;           })(); }"));
        this.checkSucceeds(input, expectedResult);
    }

    public final void testSyntheticNestedFunctionIsExpanded() throws Exception {
        Block innerBlock = this.js(this.fromString("foo().x = bar();"));
        Block input = new Block(FilePosition.UNKNOWN, Arrays.asList(new FunctionDeclaration(SyntheticNodes.s(new FunctionConstructor(FilePosition.UNKNOWN, new Identifier(FilePosition.UNKNOWN, "f"), Collections.<FormalParam>emptyList(), innerBlock)))));
        Block expectedResult = this.js(this.fromString(CajitaRewriterTest.weldPrelude("bar") + CajitaRewriterTest.weldPrelude("foo") + "var x0___, x1___;" + "function f() {" + "  " + CajitaRewriterTest.weldSetPub("foo.CALL___()", "x", "bar.CALL___()", "x0___", "x1___") + ";}"));
        this.checkSucceeds(input, expectedResult);
    }

    public final void testSyntheticFormals() throws Exception {
        FilePosition unk = FilePosition.UNKNOWN;
        FunctionConstructor fc = new FunctionConstructor(unk, new Identifier(unk, "f"), Arrays.asList(new FormalParam(new Identifier(unk, "x")), new FormalParam(SyntheticNodes.s(new Identifier(unk, "y___")))), new Block(unk, Arrays.asList(new ReturnStmt(unk, Operation.createInfix(Operator.MULTIPLICATION, Operation.createInfix(Operator.ADDITION, new Reference(new Identifier(unk, "x")), new Reference(SyntheticNodes.s(new Identifier(unk, "y___")))), new Reference(new Identifier(unk, "z")))))));
        this.checkSucceeds(new Block(unk, Arrays.asList(new FunctionDeclaration((FunctionConstructor)fc.clone()))), this.js(this.fromString("var z = ___.readImport(IMPORTS___, 'z');function f(x, y___) {  return (x + y___) * z;}f.FUNC___ = 'f';")));
        SyntheticNodes.s(fc);
        this.checkSucceeds(new Block(unk, Arrays.asList(new FunctionDeclaration((FunctionConstructor)fc.clone()))), this.js(this.fromString("var z = ___.readImport(IMPORTS___, 'z');function f(x, y___) {  return (x + y___) * z;}")));
    }

    public final void testNestedBlockWithFunction() throws Exception {
        this.checkSucceeds("{ function foo() {} }", "var foo;{ foo = (function () {\n             function foo$_self() {\n             }\n             foo$_self.FUNC___ = 'foo';\n             return foo$_self;\n           })(); }");
    }

    public final void testNestedBlockWithVariable() throws Exception {
        this.checkSucceeds("{ var x = g().y; }", CajitaRewriterTest.weldPrelude("g") + "var x, x0___;" + "{" + "  x = " + CajitaRewriterTest.weldReadPub("g.CALL___()", "y", "x0___") + ";" + "}");
    }

    public final void testWith() throws Exception {
        this.checkFails("with (dreams || ambiguousScoping) anything.isPossible();", "\"with\" blocks are not allowed");
        this.checkFails("with (dreams || ambiguousScoping) { anything.isPossible(); }", "\"with\" blocks are not allowed");
    }

    public final void testTryCatch() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("try {  throw 2;} catch (e) {  var e;}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("var e;try {  throw 2;} catch (e) {}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("try {} catch (x__) { }")), RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
        this.checkSucceeds("var x;try {  g[x + 0];  e;  g[x + 1];} catch (e) {  g[x + 2];  e;  g[x + 3];}", CajitaRewriterTest.weldPreludes("e", "g") + "var x;" + "try {" + "  ___.readPub(g, x + 0);" + "  e;" + "  ___.readPub(g, x + 1);" + "} catch (ex___) {" + "  try {" + "    throw ___.tameException(ex___);" + "  } catch (e) {" + "    ___.readPub(g, x + 2);" + "    e;" + "    ___.readPub(g, x + 3);" + "  }" + "}");
        this.rewriteAndExecute("var handled = false;try {  throw null;} catch (ex) {  assertEquals(null, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw undefined;} catch (ex) {  assertEquals(undefined, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw true;} catch (ex) {  assertEquals(true, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw 37639105;} catch (ex) {  assertEquals(37639105, ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw 'panic';} catch (ex) {  assertEquals('panic', ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw new Error('hello');} catch (ex) {  assertEquals('hello', ex.message);  assertEquals('Error', ex.name);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw function foo() { throw 'should not be called'; };} catch (ex) {  assertEquals('In lieu of thrown function: foo', ex());  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw { toString: function () { return 'hiya'; }, y: 4 };} catch (ex) {  assertEquals('string', typeof ex);  assertEquals('hiya', ex);  handled = true;}assertTrue(handled);");
        this.rewriteAndExecute("var handled = false;try {  throw { toString: function () { throw new Error(); } };} catch (ex) {  assertEquals('Exception during exception handling.', ex);  handled = true;}assertTrue(handled);");
    }

    public final void testTryCatchFinally() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("try {} catch (e) {  var e;} finally {}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("var e;try {} catch (e) {} finally {}")), MessageType.MASKING_SYMBOL, MessageLevel.ERROR);
        this.checkAddsMessage(this.js(this.fromString("try {} catch (x__) { } finally { }")), RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
        this.checkSucceeds("var x;try {  g[x + 0];  e;  g[x + 1];} catch (e) {  g[x + 2];  e;  g[x + 3];} finally {  g[x + 4];  e;  g[x + 5];}", CajitaRewriterTest.weldPreludes("e", "g") + "var x;" + "try {" + "  ___.readPub(g, x + 0);" + "  e;" + "  ___.readPub(g, x + 1);" + "} catch (ex___) {" + "  try {" + "    throw ___.tameException(ex___);" + "  } catch (e) {" + "    ___.readPub(g, x + 2);" + "    e;" + "    ___.readPub(g, x + 3);" + "  }" + "} finally {" + "    ___.readPub(g, x + 4);" + "    e;" + "    ___.readPub(g, x + 5);" + "}");
    }

    public final void testTryFinally() throws Exception {
        this.assertConsistent("var out = 0;try {  try {    throw 2;  } finally {    out = 1;  }  out = 2;} catch (e) {}out;");
        this.checkSucceeds("var x;try {  g[x + 0];  e;  g[x + 1];} finally {  g[x + 2];  e;  g[x + 3];}", CajitaRewriterTest.weldPreludes("e", "g") + "var x;" + "try {" + "  ___.readPub(g, x + 0);" + "  e;" + "  ___.readPub(g, x + 1);" + "} finally {" + "  ___.readPub(g, x + 2);" + "  e;" + "  ___.readPub(g, x + 3);" + "}");
    }

    public final void testVarArgs() throws Exception {
        this.checkSucceeds("var p;var foo = function() {  p = arguments;};", "var p, foo;foo = (function () {\n         function foo$_var() {\n           var a___ = ___.args(arguments);\n           p = a___;\n         }\n         return ___.markFuncFreeze(foo$_var, 'foo$_var');\n       })();");
    }

    public final void testVarThisBad() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("var x = this;")), RewriterMessageType.THIS_NOT_IN_CAJITA, MessageLevel.FATAL_ERROR);
        this.checkAddsMessage(this.js(this.fromString("this = 42;")), RewriterMessageType.THIS_NOT_IN_CAJITA, MessageLevel.FATAL_ERROR);
        this.checkAddsMessage(this.js(this.fromString("function foo() { var x = this; }")), RewriterMessageType.THIS_NOT_IN_CAJITA, MessageLevel.FATAL_ERROR);
        this.checkAddsMessage(this.js(this.fromString("function foo() { this = 42; }")), RewriterMessageType.THIS_NOT_IN_CAJITA, MessageLevel.FATAL_ERROR);
    }

    public final void testVarBadSuffix() throws Exception {
        this.checkFails("function() { foo__; };", "Variables cannot end in \"__\"");
        this.checkSucceeds("function() { var foo_ = 3; };", "___.markFuncFreeze(function() { var foo_; foo_ = 3; });");
    }

    public final void testVarBadSuffixDeclaration() throws Exception {
        this.checkFails("function foo__() { }", "Variables cannot end in \"__\"");
        this.checkFails("var foo__ = 3;", "Variables cannot end in \"__\"");
        this.checkFails("var foo__;", "Variables cannot end in \"__\"");
        this.checkFails("function() { function foo__() { } };", "Variables cannot end in \"__\"");
        this.checkFails("function() { var foo__ = 3; };", "Variables cannot end in \"__\"");
        this.checkFails("function() { var foo__; };", "Variables cannot end in \"__\"");
    }

    public final void testVarFuncFreeze() throws Exception {
        this.rewriteAndExecute("function foo() {}foo();");
        this.rewriteAndExecute("var foo = {};foo.x = 3;assertEquals(foo.x, 3);");
        this.assertAddsMessage("function foo() {}foo = 3;", RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME, MessageLevel.FATAL_ERROR);
        this.rewriteAndExecute("assertThrows(function() {  function foo() {}  var bar = foo;  bar.x = 3;});");
    }

    public final void testVarGlobal() throws Exception {
        this.checkSucceeds("foo;", CajitaRewriterTest.weldPrelude("foo") + "foo;");
        this.checkSucceeds("function() {  foo;};", CajitaRewriterTest.weldPrelude("foo") + "___.markFuncFreeze(function() {" + "  foo;" + "});");
        this.checkSucceeds("function() {  var foo;  foo;};", "___.markFuncFreeze(function() {  var foo;  foo;});");
    }

    public final void testVarDefault() throws Exception {
        String unchanged = "var x, y;x = 3;if (x) {}x + 3;y = undefined;";
        this.checkSucceeds("function() {  " + unchanged + "};", "var undefined = ___.readImport(IMPORTS___, 'undefined', {});___.markFuncFreeze(function() {  " + unchanged + "});");
    }

    public final void testReadBadSuffix() throws Exception {
        this.checkFails("x.y__;", "Properties cannot end in \"__\"");
    }

    public final void testReadBadPrototype() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("function foo() {} foo.prototype;")), RewriterMessageType.PROTOTYPICAL_INHERITANCE_NOT_IN_CAJITA);
        this.checkAddsMessage(this.js(this.fromString("var q = function foo() { foo.prototype; };")), RewriterMessageType.PROTOTYPICAL_INHERITANCE_NOT_IN_CAJITA);
    }

    public final void testReadPublicLength() throws Exception {
        this.checkSucceeds("var arr = [1, 2, 3];arr.length;", "var arr;arr = [1, 2, 3];arr.length;");
        this.checkSucceeds("var arr = [1, 2, 3];arr.length = 4;", "var arr;arr = [1, 2, 3];arr.length_canSet___ === arr ? (arr.length = 4) :                                ___.setPub(arr, 'length', 4)");
        this.checkSucceeds("var arr = [1, 2, 3];--arr.length;", "var arr, x0___;arr = [1, 2, 3];x0___ = arr.length - 1,arr.length_canSet___ === arr    ? (arr.length = x0___)    : ___.setPub(arr, 'length', x0___);");
    }

    public final void testReadPublic() throws Exception {
        this.checkSucceeds("var p;p = foo().p;", CajitaRewriterTest.weldPrelude("foo") + "var p, x0___;" + "p = " + CajitaRewriterTest.weldReadPub("foo.CALL___()", "p", "x0___") + ";");
    }

    public final void testReadNumPublic() throws Exception {
        this.checkSucceeds("var p, q, x;p = q[x&(-1>>>1)];", "var p, q, x;p = q[x&(-1>>>1)];");
        this.checkSucceeds("var p, q, x;q[x&(-1>>>1)] = p;", "var p, q, x;___.setPub(q, x&(-1>>>1), p);");
        this.checkSucceeds("var p, q;p[q&(-1>>>1)] += 2;", "var p, q, x0___, x1___;x0___ = p,x1___ = q&(-1>>>1),___.setPub(x0___, x1___&(-1>>>1), x0___[x1___&(-1>>>1)] + 2);");
        this.checkSucceeds("var p, q;p[q&(-1>>>1)]--;", "var p, q, x0___, x1___, x2___;x0___ = p,x1___ = q&(-1>>>1),x2___ = +x0___[x1___&(-1>>>1)],___.setPub(x0___, x1___&(-1>>>1), x2___ - 1), x2___;");
        this.checkSucceeds("var p, q;--p[q&(-1>>>1)];", "var p, q, x0___, x1___;x0___ = p,x1___ = q&(-1>>>1),___.setPub(x0___, x1___&(-1>>>1), x0___[x1___&(-1>>>1)] - 1);");
    }

    public final void testNumWithConstantIndex() throws Exception {
        this.checkSucceeds("var p, q;p = q[3];", "var p, q;p = q[3];");
        this.checkSucceeds("var p, q;q[3] = p;", "var p, q;___.setPub(q, 3, p);");
        this.checkSucceeds("var p;p[3] -= 2", "var p;___.setPub(p, 3, p[3] - 2);");
        this.checkSucceeds("var p;--p[3]", "var p;___.setPub(p, 3, p[3] - 1);");
    }

    public final void testReadIndexPublic() throws Exception {
        this.checkSucceeds("var p, q, x;p = q[x];", "var p, q, x;p = ___.readPub(q, x);");
    }

    public final void testSetBadAssignToFunctionName() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("  function foo() {}foo = 3;")), RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME);
        this.checkAddsMessage(this.js(this.fromString("  function foo() {}foo += 3;")), RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME);
        this.checkAddsMessage(this.js(this.fromString("  function foo() {}foo++;")), RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME);
        this.checkAddsMessage(this.js(this.fromString("  var x = function foo() {  foo = 3;};")), RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME);
        this.checkAddsMessage(this.js(this.fromString("  var x = function foo() {  foo += 3;};")), RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME);
        this.checkAddsMessage(this.js(this.fromString("  var x = function foo() {  foo++;};")), RewriterMessageType.CANNOT_ASSIGN_TO_FUNCTION_NAME);
    }

    public final void testSetBadThis() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("function f() { this = 3; }")), RewriterMessageType.THIS_NOT_IN_CAJITA);
    }

    public final void testSetBadFreeVariable() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("Array = function () { return [] };")), RewriterMessageType.CANNOT_MASK_IDENTIFIER);
        this.checkAddsMessage(this.js(this.fromString("x = 1;")), RewriterMessageType.CANNOT_ASSIGN_TO_FREE_VARIABLE);
    }

    public final void testSetBadSuffix() throws Exception {
        this.checkFails("x.y__ = z;", "Properties cannot end in \"__\"");
    }

    public final void testSetBadPrototype() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("function foo() {} foo.prototype = 3;")), RewriterMessageType.PROTOTYPICAL_INHERITANCE_NOT_IN_CAJITA);
        this.checkAddsMessage(this.js(this.fromString("var q = function foo() { foo.prototype = 3; };")), RewriterMessageType.PROTOTYPICAL_INHERITANCE_NOT_IN_CAJITA);
    }

    public final void testSetPublic() throws Exception {
        this.checkSucceeds("x().p = g[h];", CajitaRewriterTest.weldPreludes("g", "h", "x") + "var x0___, x1___;" + CajitaRewriterTest.weldSetPub("x.CALL___()", "p", "___.readPub(g, h)", "x0___", "x1___") + ";");
    }

    public final void testSetIndexPublic() throws Exception {
        this.checkSucceeds("g[0][g[1]] = g[2];", CajitaRewriterTest.weldPrelude("g") + "___.setPub(g[0], g[1], g[2]);");
        this.checkSucceeds("g[a][g[b]] = g[c];", CajitaRewriterTest.weldPreludes("a", "b", "c", "g") + "___.setPub(___.readPub(g, a), ___.readPub(g, b), ___.readPub(g, c));");
    }

    public final void testSetBadInitialize() throws Exception {
        this.checkFails("var x__ = 3;", "Variables cannot end in \"__\"");
    }

    public final void testSetInitialize() throws Exception {
        this.checkSucceeds("var v = g[h];", CajitaRewriterTest.weldPreludes("g", "h") + "var v;" + "v = ___.readPub(g, h);");
    }

    public final void testSetBadDeclare() throws Exception {
        this.checkFails("var x__;", "Variables cannot end in \"__\"");
    }

    public final void testSetDeclare() throws Exception {
        this.checkSucceeds("var v;", "var v;");
        this.checkSucceeds("try { } catch (e) { var v; }", "var v;try {} catch (ex___) {  try {    throw ___.tameException(ex___);  } catch (e) {  }}");
    }

    public final void testSetVar() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("try {} catch (x__) { x__ = 3; }")), RewriterMessageType.VARIABLES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
        this.checkSucceeds("var x, y;x = g[y];", CajitaRewriterTest.weldPrelude("g") + "var x, y;" + "x = ___.readPub(g, y);");
    }

    public final void testSetReadModifyWriteLocalVar() throws Exception {
        this.checkFails("x__ *= 2;", "");
        this.checkFails("x *= y__;", "");
        this.checkSucceeds("var x, y; x += g[y];", CajitaRewriterTest.weldPrelude("g") + "var x, y; x = x + ___.readPub(g, y);");
        this.checkSucceeds("myArray().key += 1;", CajitaRewriterTest.weldPrelude("myArray") + "var x0___, x1___;" + "x0___ = myArray.CALL___()," + "x1___ = (x0___.key_canRead___" + "         ? x0___.key : ___.readPub(x0___, 'key')) + 1," + "x0___.key_canSet___ === x0___" + "     ? (x0___.key = x1___) : ___.setPub(x0___, 'key', x1___);");
        this.checkSucceeds("myArray()[myKey()] += 1;", CajitaRewriterTest.weldPrelude("myArray") + CajitaRewriterTest.weldPrelude("myKey") + "var x0___, x1___;" + "x0___ = myArray.CALL___()," + "x1___ = myKey.CALL___()," + "___.setPub(x0___, x1___," + "           ___.readPub(x0___, x1___) + 1);");
        this.checkSucceeds("(function (myKey) { myArray()[myKey] += 1; });", CajitaRewriterTest.weldPrelude("myArray") + "___.markFuncFreeze(function (myKey) {" + "  var x0___;" + "  x0___ = myArray.CALL___()," + "  ___.setPub(x0___, myKey," + "             ___.readPub(x0___, myKey) + 1);" + "});");
        this.assertConsistent("var x = 3; x *= 2;");
        this.assertConsistent("var x = 1; x += 7;");
        this.assertConsistent("var x = 1; x /= '2';");
        this.assertConsistent("var o = { x: 'a' }; o.x += 'b'; o;");
        EnumSet<Operator[]> ops = EnumSet.of(Operator.ASSIGN_MUL, new Operator[]{Operator.ASSIGN_DIV, Operator.ASSIGN_MOD, Operator.ASSIGN_SUM, Operator.ASSIGN_SUB, Operator.ASSIGN_LSH, Operator.ASSIGN_RSH, Operator.ASSIGN_USH, Operator.ASSIGN_AND, Operator.ASSIGN_XOR, Operator.ASSIGN_OR});
        for (Operator operator : ops) {
            this.checkSucceeds("var x, y; x " + operator.getSymbol() + " g[y];", CajitaRewriterTest.weldPrelude("g") + "var x, y;" + "x = x " + operator.getAssignmentDelegate().getSymbol() + "___.readPub(g, y);");
        }
    }

    public final void testSetIncrDecr() throws Exception {
        this.checkFails("x__--;", "");
        this.checkSucceeds("g[i]++;", CajitaRewriterTest.weldPreludes("g", "i") + "var x0___, x1___, x2___;" + "x0___ = g," + "x1___ = i," + "x2___ = +___.readPub(x0___, x1___)," + "___.setPub(x0___, x1___, x2___ + 1)," + "x2___;");
        this.checkSucceeds("g[i]--;", CajitaRewriterTest.weldPreludes("g", "i") + "var x0___, x1___, x2___;" + "x0___ = g," + "x1___ = i," + "x2___ = +___.readPub(x0___, x1___)," + "___.setPub(x0___, x1___, x2___ - 1)," + "x2___;");
        this.checkSucceeds("++g[i];", CajitaRewriterTest.weldPreludes("g", "i") + "var x0___, x1___;" + "x0___ = g," + "x1___ = i," + "___.setPub(x0___, x1___, ___.readPub(x0___, x1___) - -1);");
        this.assertConsistent("var x = 2;var arr = [--x, x, x--, x, ++x, x, x++, x];assertEquals('1,1,1,0,1,1,1,2', arr.join(','));arr;");
        this.assertConsistent("var x = '2';var arr = [--x, x, x--, x, ++x, x, x++, x];assertEquals('1,1,1,0,1,1,1,2', arr.join(','));arr;");
    }

    public final void testSetIncrDecrOnLocals() throws Exception {
        this.checkFails("++x__;", "");
        this.checkSucceeds("(function (x, y) { return [x--, --x, y++, ++y]; });", "___.markFuncFreeze(  function (x, y) { return [x--, --x, y++, ++y]; });");
        this.assertConsistent("(function () {  var x = 2;  var arr = [--x, x, x--, x, ++x, x, x++, x];  assertEquals('1,1,1,0,1,1,1,2', arr.join(','));  return arr;})();");
    }

    public final void testSetIncrDecrOfComplexLValues() throws Exception {
        this.checkFails("arr[x__]--;", "Variables cannot end in \"__\"");
        this.checkFails("arr__[x]--;", "Variables cannot end in \"__\"");
        this.checkSucceeds("o.x++;", CajitaRewriterTest.weldPrelude("o") + "var x0___, x1___, x2___;" + "x0___ = o," + "x1___ = +(x0___.x_canRead___ ? x0___.x : ___.readPub(x0___, 'x'))," + "(x2___ = x1___ + 1," + " x0___.x_canSet___ === x0___" + "     ? (x0___.x = x2___)" + "     : ___.setPub(x0___, 'x', x2___))," + "x1___;");
        this.assertConsistent("(function () {  var o = { x: 2 };  var arr = [--o.x, o.x, o.x--, o.x, ++o.x, o.x, o.x++, o.x];  assertEquals('1,1,1,0,1,1,1,2', arr.join(','));  return arr;})();");
    }

    public final void testSetIncrDecrOrderOfAssignment() throws Exception {
        this.assertConsistent("(function () {  var arrs = [1, 2];  var j = 0;  arrs[++j] *= ++j;  assertEquals(2, j);  assertEquals(1, arrs[0]);  assertEquals(4, arrs[1]);  return arrs;})();");
        this.assertConsistent("(function () {  var foo = (function () {               var k = 0;               return function () {                 switch (k++) {                   case 0: return [10, 20, 30];                   case 1: return 1;                   case 2: return 2;                   default: throw new Error(k);                 }               };             })();  return foo()[foo()] -= foo();})();");
    }

    public final void testNewCallledCtor() throws Exception {
        this.checkSucceeds("new Date();", CajitaRewriterTest.weldPrelude("Date", "{}") + "___.construct(Date, []);");
    }

    public final void testNewCalllessCtor() throws Exception {
        this.checkSucceeds("(new Date);", CajitaRewriterTest.weldPrelude("Date", "{}") + "___.construct(Date, []);");
    }

    public final void testDeletePub() throws Exception {
        this.checkFails("delete x.foo___;", "Properties cannot end in \"__\"");
        this.checkSucceeds("delete foo()[bar()];", CajitaRewriterTest.weldPreludes("bar", "foo") + "___.deletePub(foo.CALL___()," + "              bar.CALL___());");
        this.checkSucceeds("delete foo().bar;", CajitaRewriterTest.weldPrelude("foo") + "___.deletePub(foo.CALL___(), 'bar');");
        this.assertConsistent("(function() {  var o = { x: 3, y: 4 };  function ptStr(o) { return '(' + o.x + ',' + o.y + ')'; }  var history = [ptStr(o)];  delete o.y;  delete o.z;  history.push(ptStr(o));  return history.toString();})();");
        this.assertConsistent("var alert = 'a';var o = { a: 1 };delete o[alert];assertEquals(undefined, o.a);o;");
    }

    public final void testDeleteFails() throws Exception {
        this.assertConsistent("var status;try {  if (delete [].length) {    status = 'FAILED';  } else {    status = 'PASSED';  }} catch (e) {  status = 'PASSED';}status;");
    }

    public final void testDeleteNonLvalue() throws Exception {
        this.checkFails("delete 4;", "Invalid operand to delete");
    }

    public final void testCallPublic() throws Exception {
        this.checkSucceeds("g[i + 0].m(g[i + 1], g[i + 2]);", CajitaRewriterTest.weldPreludes("g", "i") + "var x0___, x1___, x2___;" + "x0___ = ___.readPub(g, i + 0)," + "x1___ = ___.readPub(g, i + 1)," + "x2___ = ___.readPub(g, i + 2)," + "x0___.m_canCall___" + "    ? x0___.m(x1___, x2___)" + "    : ___.callPub(x0___, 'm', [x1___, x2___]);");
    }

    public final void testCallIndexPublic() throws Exception {
        this.checkSucceeds("g[i + 0][g[i + 1]](g[i + 2], g[i + 3]);", CajitaRewriterTest.weldPreludes("g", "i") + "___.callPub(" + "    ___.readPub(g, i + 0)," + "    ___.readPub(g, i + 1)," + "    [___.readPub(g, i + 2), ___.readPub(g, i + 3)]);");
    }

    public final void testCallFunc() throws Exception {
        this.checkSucceeds("g(g[i + 1], g[i + 2]);", CajitaRewriterTest.weldPreludes("g", "i") + "g.CALL___" + "     (___.readPub(g, i + 1), ___.readPub(g, i + 2));");
    }

    public final void testPermittedCall() throws Exception {
        String fixture = "  var x = 0;var callPubCalled = false;var origCallPub = ___.callPub;___.callPub = function(obj, name, args) {  if (name === 'dis') { callPubCalled = true; }  origCallPub.call(___, obj, name, args);};testImports.$v = ___.primFreeze({  dis: ___.markFuncFreeze(function(n) { x = n; })});";
        this.rewriteAndExecute(fixture, "  $v.dis(42);", "  assertFalse(callPubCalled);assertEquals(42, x);");
        this.rewriteAndExecute(fixture, "  (function() {  var $v = { dis: function(x) {} };  $v.dis(42);})();", "  assertTrue(callPubCalled);assertEquals(0, x);");
    }

    public final void testFuncAnonSimple() throws Exception {
        this.checkSucceeds("function(x, y, i) { x = arguments; y = g[i]; };", CajitaRewriterTest.weldPrelude("g") + "___.markFuncFreeze(function(x, y, i) {" + "  var a___ = ___.args(arguments);" + "  x = a___;" + "  y = ___.readPub(g, i);" + "});");
        this.rewriteAndExecute("(function () {  var foo = function () {};  foo();  try {    foo.x = 3;  } catch (e) { return; }  fail('mutate frozen function');})();");
        this.assertConsistent("var foo = (function () {             function foo() {}             foo.x = 3;             return foo;           })();foo();foo.x;");
    }

    public final void testFuncNamedSimpleDecl() throws Exception {
        this.rewriteAndExecute("  assertThrows(function() {  (function foo() { foo.x = 3; })();});");
        this.rewriteAndExecute("  assertThrows(function() {  function foo() { foo.x = 3; }  foo();});");
        this.rewriteAndExecute("  assertThrows(function() {  var foo = function() {};  foo.x = 3;});");
        this.rewriteAndExecute("  function foo() {}foo.x = 3;");
        this.checkSucceeds("function() {  function foo(x, y, i) {    x = arguments;    y = g[i];    return foo(x - 1, y - 1);  }}", CajitaRewriterTest.weldPrelude("g") + "___.markFuncFreeze(function() {" + "  function foo(x, y, i) {\n" + "    var a___ = ___.args(arguments);\n" + "    x = a___;\n" + "    y = ___.readPub(g, i);\n" + "    return foo.CALL___(x - 1, y - 1);\n" + "  }\n" + "  foo.FUNC___ = 'foo';" + "});");
        this.checkSucceeds("function foo(x, y ) {  return foo(x - 1, y - 1);}", "  function foo(x, y) {\n    return foo.CALL___(x - 1, y - 1);\n  }\n  foo.FUNC___ = 'foo';");
        this.rewriteAndExecute("(function () {  function foo() {}  foo();  try {    foo.x = 3;  } catch (e) { return; }  fail('mutated frozen function');})();");
        this.assertConsistent("function foo() {}foo.x = 3;foo();foo.x;");
        this.rewriteAndExecute("  function f_() { return 31415; }var x = f_();assertEquals(x, 31415);");
    }

    public final void testFuncNamedSimpleValue() throws Exception {
        this.checkSucceeds("var f = function foo(x, y) {  x = arguments;  y = z;  return foo(x - 1, y - 1);};", CajitaRewriterTest.weldPrelude("z") + "var f;" + "f = function() {" + "  function foo(x, y) {" + "    var a___ = ___.args(arguments);" + "    x = a___;" + "    y = z;" + "    return foo.CALL___(x - 1, y - 1);" + "  }" + "  return ___.markFuncFreeze(foo, 'foo');" + "}();");
        this.checkSucceeds("var bar = function foo_(x, y ) {  return foo_(x - 1, y - 1);};", "var bar;bar = function() {  function foo_(x, y) {    return foo_.CALL___(x - 1, y - 1);  }  return ___.markFuncFreeze(foo_, 'foo_');}();");
    }

    public final void testMaskingFunction() throws Exception {
        this.assertAddsMessage("function Goo() { function Goo() {} }", MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR);
        this.assertAddsMessage("function Goo() { var Goo = 1; }", MessageType.MASKING_SYMBOL, MessageLevel.LINT);
        this.assertMessageNotPresent("function Goo() { this.x = 1; }", MessageType.MASKING_SYMBOL);
    }

    public final void testMapEmpty() throws Exception {
        this.checkSucceeds("var f = {};", "var f; f = ___.iM([]);");
    }

    public final void testMapBadKeySuffix() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("var o = { x__: 3 };")), RewriterMessageType.PROPERTIES_CANNOT_END_IN_DOUBLE_UNDERSCORE);
    }

    public final void testMapNonEmpty() throws Exception {
        this.checkSucceeds("var o = { k0: g().x, k1: g().y };", CajitaRewriterTest.weldPrelude("g") + "var o, x0___, x1___;" + "o = ___.iM(" + "    [ 'k0', " + CajitaRewriterTest.weldReadPub("g.CALL___()", "x", "x0___") + ", " + "      'k1', " + CajitaRewriterTest.weldReadPub("g.CALL___()", "y", "x1___") + " ]);");
        this.rewriteAndExecute("testImports.f = function() {};", "assertThrows(function() { f(); });", ";");
        this.rewriteAndExecute("  var f = function() {};var m = { f : f };m.f();");
        this.rewriteAndExecute("testImports.f = function() {};", "assertThrows(function(){({ isPrototypeOf : f });});", ";");
    }

    public final void testMapSingle() throws Exception {
        this.checkSucceeds("var o = { k0: p.x };", CajitaRewriterTest.weldPrelude("p") + "var o;" + "o = ___.iM(['k0', p.x_canRead___ ? p.x : ___.readPub(p, 'x')]);");
        this.checkFails("var o = { valueOf: p.x, k1: p.y };", "The valueOf property must not be set");
        this.checkFails("var o = { x___: p.x, k1: p.y };", "Properties cannot end in \"__\"");
    }

    public final void testMapPlural() throws Exception {
        this.checkSucceeds("var o = { k0: p.x, k1: p.y };", CajitaRewriterTest.weldPrelude("p") + "var o;" + "o = ___.iM(['k0', p.x_canRead___ ? p.x : ___.readPub(p, 'x')," + "                'k1', p.y_canRead___ ? p.y : ___.readPub(p, 'y')]);");
        this.checkFails("var o = { valueOf: p.x, k1: p.y };", "The valueOf property must not be set");
        this.checkFails("var o = { x___: p.x, k1: p.y };", "Properties cannot end in \"__\"");
        this.checkFails("var o = { k0: p.x, valueOf: p.y };", "The valueOf property must not be set");
        this.checkFails("var o = { k0: p.x, x___: p.y };", "Properties cannot end in \"__\"");
    }

    public final void testOtherInstanceof() throws Exception {
        this.checkSucceeds("function foo() {}g[void 0] instanceof foo;", CajitaRewriterTest.weldPrelude("g") + "function foo() {\n" + "}\n" + "foo.FUNC___ = 'foo';" + "___.readPub(g, void 0) instanceof ___.primFreeze(foo);");
        this.checkSucceeds("g[i] instanceof Object;", CajitaRewriterTest.weldPreludes("Object", "g", "i") + "___.readPub(g, i) instanceof Object;");
        this.assertConsistent("[ (({}) instanceof Object),  ((new Date) instanceof Date),  (({}) instanceof Date)];");
        this.assertConsistent("function foo() {}  (new foo) instanceof foo;");
        this.assertConsistent("function foo() {}  !(({}) instanceof foo);");
    }

    public final void testOtherTypeof() throws Exception {
        this.checkSucceeds("typeof g[i];", CajitaRewriterTest.weldPreludes("g", "i") + "___.typeOf(___.readPub(g, i));");
        this.checkFails("typeof ___;", "Variables cannot end in \"__\"");
        this.rewriteAndExecute("assertEquals(typeof new RegExp('.*'), 'object');");
    }

    public final void testLabeledStatement() throws Exception {
        this.checkFails("IMPORTS___: 1;", "Labels cannot end in \"__\"");
        this.checkFails("IMPORTS___: while (1);", "Labels cannot end in \"__\"");
        this.checkSucceeds("foo: 1;", "foo: 1;");
        this.checkFails("while (1) { break x__; }", "Labels cannot end in \"__\"");
        this.checkSucceeds("break foo;", "break foo;");
        this.checkFails("while (1) { continue x__; }", "Labels cannot end in \"__\"");
        this.checkSucceeds("continue foo;", "continue foo;");
        this.assertConsistent("var k = 0;a: for (var i = 0; i < 10; ++i) {  b: for (var j = 0; j < 10; ++j) {    if (++k > 5) break a;  }}k;");
        this.assertConsistent("var k = 0;a: for (var i = 0; i < 10; ++i) {  b: for (var j = 0; j < 10; ++j) {    if (++k > 5) break b;  }}k;");
    }

    public final void testRegexLiteral() throws Exception {
        this.checkAddsMessage(this.js(this.fromString("/x/;")), RewriterMessageType.REGEX_LITERALS_NOT_IN_CAJITA);
        this.checkAddsMessage(this.js(this.fromString("var y = /x/;")), RewriterMessageType.REGEX_LITERALS_NOT_IN_CAJITA);
    }

    public final void testOtherSpecialOp() throws Exception {
        this.checkSucceeds("void 0;", "void 0;");
        this.checkSucceeds("void g();", CajitaRewriterTest.weldPrelude("g") + "void g.CALL___();");
        this.checkSucceeds("g[i], g[1];", CajitaRewriterTest.weldPreludes("g", "i") + "___.readPub(g, i), g[1];");
    }

    public final void testMultiDeclaration2() throws Exception {
        this.checkSucceeds("var x, y;", "var x, y;");
        this.checkSucceeds("var x = g[0], y = g[x];", CajitaRewriterTest.weldPrelude("g") + "var x, y; x = g[0], y = ___.readPub(g, x);");
        this.checkSucceeds("var x, y = g[0];", CajitaRewriterTest.weldPrelude("g") + "var x, y; y = g[0];");
        this.checkSucceeds("for (var x, y; ; ) {}", "var x, y; for (; ; ) {}");
        this.checkSucceeds("for (var x = g[i], y = g[x]; ; ) {}", CajitaRewriterTest.weldPreludes("g", "i") + "var x, y;" + "for (x = ___.readPub(g, i), y = ___.readPub(g, x); ; ) {}");
        this.checkSucceeds("for (var x, y = g[i]; ; ) {}", CajitaRewriterTest.weldPreludes("g", "i") + "var x, y;" + "for (y = ___.readPub(g, i); ; ) {}");
        this.checkSucceeds("function() {  var x, y;};", "___.markFuncFreeze(function() {  var x, y;});");
        this.checkSucceeds("function (i) {  var x = g[i], y = g[i + 1];};", CajitaRewriterTest.weldPrelude("g") + "___.markFuncFreeze(function (i) {" + "  var x, y;" + "  x = ___.readPub(g, i), y = ___.readPub(g, i + 1);" + "});");
        this.checkSucceeds("function (i) {  var x, y = g[i];}", CajitaRewriterTest.weldPrelude("g") + "___.markFuncFreeze(function (i) {" + "  var x, y;" + "  y = ___.readPub(g, i);" + "});");
        this.checkSucceeds("function() {  for (var x, y; ; ) {}}", "___.markFuncFreeze(function() {  var x, y;  for (; ; ) {}});");
        this.checkSucceeds("function (a, b) {  for (var x = g[a], y = g[b]; ; ) {}}", CajitaRewriterTest.weldPrelude("g") + "___.markFuncFreeze(function (a, b) {" + "  var x, y;" + "  for (x = ___.readPub(g, a), y = ___.readPub(g, b); ; ) {}" + "});");
        this.checkSucceeds("function (i) {  for (var x, y = g[i]; ; ) {}}", CajitaRewriterTest.weldPrelude("g") + "___.markFuncFreeze(function (i) {" + "  var x, y;" + "  for (y = ___.readPub(g, i); ; ) {}" + "});");
        this.assertConsistent("var arr = [1, 2, 3], k = -1;(function () {  var a = arr[++k], b = arr[++k], c = arr[++k];  return [a, b, c];})();");
        this.assertConsistent("(function () {  var a = [];  for (var i = 0, j = 10; i < j; ++i) { a.push(i); }  return a;})();");
        this.assertConsistent("var a = [];for (var i = 0, j = 10; i < j; ++i) { a.push(i); }a;");
    }

    public final void testRecurseParseTreeNodeContainer() {
    }

    public final void testRecurseArrayConstructor() throws Exception {
        this.checkSucceeds("var foo = [ g[a], g[b] ];", CajitaRewriterTest.weldPreludes("a", "b", "g") + "var foo;" + "foo = [___.readPub(g, a), ___.readPub(g, b)];");
    }

    public final void testRecurseBlock() {
    }

    public final void testRecurseBreakStmt() throws Exception {
        this.checkSucceeds("while (true) { break; }", "while (true) { break; }");
    }

    public final void testRecurseCaseStmt() throws Exception {
        this.checkSucceeds("switch (g[i]) { case 1: break; }", CajitaRewriterTest.weldPreludes("g", "i") + "switch (___.readPub(g, i)) { case 1: break; }");
    }

    public final void testRecurseConditional() throws Exception {
        this.checkSucceeds("if (g[i] === g[i + 1]) {  g[i + 2];} else if (g[i + 3] === g[i + 4]) {  g[i + 5];} else {  g[i + 6];}", CajitaRewriterTest.weldPreludes("g", "i") + "if (___.readPub(g, i) === ___.readPub(g, i + 1)) {" + "  ___.readPub(g, i + 2);" + "} else if (___.readPub(g, i + 3) === ___.readPub(g, i + 4)) {" + "  ___.readPub(g, i + 5);" + "} else {" + "  ___.readPub(g, i + 6);" + "}");
    }

    public final void testRecurseContinueStmt() throws Exception {
        this.checkSucceeds("while (true) { continue; }", "while (true) { continue; }");
    }

    public final void testRecurseDebuggerStmt() throws Exception {
        this.checkSucceeds("debugger;", "debugger;");
    }

    public final void testRecurseDefaultCaseStmt() throws Exception {
        this.checkSucceeds("switch (g[i]) { default: break; }", CajitaRewriterTest.weldPreludes("g", "i") + "switch(___.readPub(g, i)) { default: break; }");
    }

    public final void testRecurseExpressionStmt() {
    }

    public final void testRecurseIdentifier() {
    }

    public final void testRecurseLiteral() throws Exception {
        this.checkSucceeds("3;", "3;");
    }

    public final void testRecurseLoop() throws Exception {
        this.checkSucceeds("for (var i, k = 0; k < g[i]; k++) {  g[i + 1];}", CajitaRewriterTest.weldPrelude("g") + "var i, k;" + "for (k = 0; k < ___.readPub(g, i); k++) {" + "  ___.readPub(g, i + 1);" + "}");
        this.checkSucceeds("while (g[i]) { g[i + 1]; }", CajitaRewriterTest.weldPreludes("g", "i") + "while (___.readPub(g, i)) { ___.readPub(g, i + 1); }");
    }

    public final void testRecurseNoop() throws Exception {
        this.checkSucceeds(this.js(this.fromString(";")), new Block(FilePosition.UNKNOWN));
    }

    public final void testRecurseOperation() throws Exception {
        this.checkSucceeds("g[i] + g[j];", CajitaRewriterTest.weldPreludes("g", "i", "j") + "___.readPub(g, i) + ___.readPub(g, j);");
        this.checkSucceeds("1 + 2 * 3 / 4 - -5;", "1 + 2 * 3 / 4 - -5;");
        this.checkSucceeds("var x, y, z;x  = y = g[z];", CajitaRewriterTest.weldPrelude("g") + "var x, y, z;" + "x = y = ___.readPub(g, z);");
    }

    public final void testRecurseReturnStmt() throws Exception {
        this.checkSucceeds("return g[i];", CajitaRewriterTest.weldPreludes("g", "i") + "return ___.readPub(g, i);");
    }

    public final void testRecurseSwitchStmt() throws Exception {
        this.checkSucceeds("switch (g[i]) { }", CajitaRewriterTest.weldPreludes("g", "i") + "switch (___.readPub(g, i)) { }");
    }

    public final void testRecurseThrowStmt() throws Exception {
        this.checkSucceeds("throw g[i];", CajitaRewriterTest.weldPreludes("g", "i") + "throw ___.readPub(g, i);");
        this.checkSucceeds("function() {  var x;  throw x;};", "___.markFuncFreeze(function() {  var x;  throw x;});");
    }

    public final void testCantReadProto() throws Exception {
        this.rewriteAndExecute("function foo(){}assertEquals(foo.prototype, undefined);");
    }

    public final void testSpecimenClickme() throws Exception {
        this.checkSucceeds(this.fromResource("clickme.js"));
    }

    public final void testSpecimenListfriends() throws Exception {
        this.checkSucceeds(this.fromResource("listfriends.js"));
    }

    public final void testRecursionOnIE() throws Exception {
        Block input = this.js(this.fromString("var x = 1;\nvar f = function x(b) { return b ? 1 : x(true); };\nassertEquals(2, x + f());"));
        ParseTreeNode cajoled = this.cajitaRewriter.expand(input);
        this.assertNoErrors();
        ParseTreeNode emulated = this.emulateIE6FunctionConstructors(cajoled);
        this.executePlain("___.getNewModuleHandler().getImports().assertEquals\n    = ___.markFuncFreeze(assertEquals);\n___.loadModule({\n  instantiate: function (___, IMPORTS___) {\n    " + CajitaRewriterTest.render(emulated) + "\n" + "  }\n" + " });").toString();
    }

    public final void testAssertConsistent() throws Exception {
        this.assertConsistent("({})");
        try {
            this.assertConsistent("typeof (new RegExp('foo'))");
        }
        catch (AssertionFailedError e) {
            return;
        }
        CajitaRewriterTest.fail((String)"assertConsistent not working");
    }

    public final void testIE_Emulation() throws Exception {
        Block input = this.js(this.fromString("void (function x() {});\nassertEquals('function', typeof x);\n"));
        this.assertNoErrors();
        ParseTreeNode emulated = this.emulateIE6FunctionConstructors(input);
        this.executePlain("  ___.loadModule({  instantiate: function (___, IMPORTS___) {    " + CajitaRewriterTest.render(emulated) + "  }" + "});");
    }

    @FailureIsAnOption
    public final void testWrapperAccess() throws Exception {
        this.rewriteAndExecute("", "x='test';", "if (___.getNewModuleHandler().getImports().x != 'test') {fail('Cannot see inside the wrapper');}");
    }

    public final void testFrozenArray() throws Exception {
        this.rewriteAndExecute("var success = false;try {Array.prototype[4] = 'four';} catch (e){success = true;}if (!success) { fail('Array.prototype not frozen.'); }");
    }

    public final void testFrozenObject() throws Exception {
        this.rewriteAndExecute("var success = false;try {Object.prototype.x = 'X';} catch (e){success = true;}if (!success) { fail('Object.prototype not frozen.'); }");
    }

    public final void testStamp() throws Exception {
        this.rewriteAndExecute("function Foo(){}var foo = new Foo();var TestMark = cajita.Trademark('Test');var passed = false;try {   cajita.stamp([TestMark.stamp], foo);} catch (e) {  if (e.message !== 'Can only stamp records: [object Object]') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to stamp constructed objects.'); }");
        this.rewriteAndExecute("___.getNewModuleHandler().getImports().stampAnyway =  ___.markFuncFreeze(function(stamp, obj) {    stamp.mark___(obj);  });", "function Foo(){}var foo = new Foo();var TestMark = cajita.Trademark('Test');try {   stampAnyway(TestMark.stamp, foo);} catch (e) {  fail(e.message);}cajita.guard(TestMark.guard, foo);", "");
        this.rewriteAndExecute("var foo = {};var TestMark = cajita.Trademark('Test');cajita.stamp([TestMark.stamp], foo);cajita.guard(TestMark.guard, foo);");
        this.rewriteAndExecute("var foo = {};var TestMark = cajita.Trademark('Test');cajita.stamp([TestMark.stamp], foo);TestMark.guard.coerce(foo);");
        this.rewriteAndExecute("var foo = {};var TestMark = cajita.Trademark('Test');var passed = false;try {   cajita.guard(TestMark.guard, foo);} catch (e) {  if (e.message !== 'Specimen does not have the \"Test\" trademark') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to forge trademarks.'); }");
        this.rewriteAndExecute("var foo = {};var T1Mark = cajita.Trademark('T1');var T2Mark = cajita.Trademark('T2');var passed = false;try {   cajita.stamp([T1Mark.stamp], foo);  cajita.guard(T2Mark.guard, foo);} catch (e) {  if (e.message !== 'Specimen does not have the \"T2\" trademark') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to forge trademarks.'); }");
        this.rewriteAndExecute("var foo = cajita.freeze({});var TestMark = cajita.Trademark('Test');var passed = false;try {  cajita.stamp([TestMark.stamp], foo);} catch (e) {  if (e.message !== 'Can\\'t stamp frozen objects: [object Object]') {    fail(e.message);  }  passed = true;}if (!passed) { fail ('Able to stamp frozen objects.'); }");
        this.rewriteAndExecute("var foo = {};var bar = cajita.beget(foo);var baz = cajita.beget(bar);var TestMark = cajita.Trademark('Test');cajita.stamp([TestMark.stamp], bar);assertFalse(cajita.passesGuard(TestMark.guard, foo));assertTrue(cajita.passesGuard(TestMark.guard, bar));assertFalse(cajita.passesGuard(TestMark.guard, baz));");
    }

    public final void testForwardReference() throws Exception {
        this.rewriteAndExecute("var g = Bar;if (true) { var f = Foo; }function Foo(){}do { var h = Bar; function Bar(){} } while (0);assertEquals(typeof f, 'function');assertEquals(typeof g, 'undefined');assertEquals(typeof h, 'function');");
        this.rewriteAndExecute("(function(){var g = Bar;if (true) { var f = Foo; }function Foo(){}do { var h = Bar; function Bar(){} } while (0);assertEquals(typeof f, 'function');assertEquals(typeof g, 'undefined');assertEquals(typeof h, 'function');})();");
    }

    public final void testReformedGenerics() throws Exception {
        this.rewriteAndExecute("var x = [33];x.foo = [].push;assertThrows(function(){x.foo(44);});");
        this.rewriteAndExecute("var x = {blue:'green'};x.foo = [].push;assertThrows(function(){x.foo(44);});");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo.call(x, 44);cajita.getOwnPropertyNames(x).sort();");
    }

    public final void testIndexOf() throws Exception {
        this.assertConsistent("''.indexOf('1');");
    }

    public final void testCallback() throws Exception {
        this.assertConsistent("(function(){}).apply.call(function(a, b) {return a + b;}, {}, [3, 4]);");
        this.assertConsistent("(function(){}).call.call(function(a, b) {return a + b;}, {}, 3, 4);");
        this.rewriteAndExecute("", "var a = [];\ncajita.forOwnKeys({x:3}, function(k, v) {a.push(k, v);});assertEquals(a.toString(), 'x,3');", "var a = [];\ncajita.forOwnKeys({x:3}, ___.markFuncFreeze(function(k, v) {a.push(k, v);}));assertEquals(a.toString(), 'x,3');");
        this.rewriteAndExecute("", "var a = [];\ncajita.forAllKeys({x:3}, function(k, v) {a.push(k, v);});assertEquals(a.toString(), 'x,3');", "var a = [];\ncajita.forAllKeys({x:3}, ___.markFuncFreeze(function(k, v) {a.push(k, v);}));assertEquals(a.toString(), 'x,3');");
    }

    public final void testTable() throws Exception {
        this.rewriteAndExecute("var t = cajita.newTable();var k1 = {};var k2 = {};var k3 = {};t.set(k1, 'v1');t.set(k2, 'v2');assertEquals(t.get(k1), 'v1');assertEquals(t.get(k2), 'v2');assertTrue(t.get(k3) === void 0);");
        this.rewriteAndExecute("var t = cajita.newTable(true);var k1 = {};var k2 = {};var k3 = {};t.set(k1, 'v1');t.set(k2, 'v2');assertEquals(t.get(k1), 'v1');assertEquals(t.get(k2), 'v2');assertTrue(t.get(k3) === void 0);");
        this.rewriteAndExecute("var t = cajita.newTable();t.set('foo', 'v1');t.set(null, 'v2');assertEquals(t.get('foo'), 'v1');assertEquals(t.get(null), 'v2');assertTrue(t.get({toString: function(){return 'foo';}}) === void 0);");
        this.rewriteAndExecute("var t = cajita.newTable(true);assertThrows(function(){t.set('foo', 'v1');});");
        this.rewriteAndExecute("var t = cajita.newTable(true);var k1 = {};var k2 = cajita.beget(k1);var k3 = cajita.beget(k2);var k4 = cajita.beget(k3);t.set(k2, 'foo');t.set(k3, 'bar');assertEquals(t.get(k2), 'foo');\nassertEquals(t.get(k3), 'bar');\nassertTrue(t.get(k1) === void 0);\nassertTrue(t.get(k4) === void 0);");
        this.rewriteAndExecute("var t = cajita.newTable();var k1 = {};var k2 = cajita.beget(k1);var k3 = cajita.beget(k2);var k4 = cajita.beget(k3);t.set(k2, 'foo');t.set(k3, 'bar');assertEquals(t.get(k2), 'foo');\nassertEquals(t.get(k3), 'bar');\nassertTrue(t.get(k1) === void 0);\nassertTrue(t.get(k4) === void 0);");
        this.rewriteAndExecute("var t1 = cajita.newTable(true);var t2 = cajita.newTable(true);var k = {};t1.set(k, 'foo');t2.set(k, 'bar');assertEquals(t1.get(k), 'foo');assertEquals(t2.get(k), 'bar');t1.set(k, void 0);assertTrue(t1.get(k) === void 0);assertEquals(t2.get(k), 'bar');");
        this.rewriteAndExecute("var t1 = cajita.newTable();var t2 = cajita.newTable();var k = {};t1.set(k, 'foo');t2.set(k, 'bar');assertEquals(t1.get(k), 'foo');assertEquals(t2.get(k), 'bar');t1.set(k, void 0);assertTrue(t1.get(k) === void 0);assertEquals(t2.get(k), 'bar');");
    }

    public final void testFuncNaming() throws Exception {
        this.checkSucceeds("function foo(){debugger;}var x = {bar: function() {foo();}};x.baz = function(){x.bar();};var zip = function(){x.baz();};var zap;zap = function(){zip();};zap();", "var x, x0___, zip, zap;function foo() { debugger; }foo.FUNC___ = 'foo';x = ___.iM(['bar', (function () {  function bar$_lit() { foo.CALL___(); }  return ___.markFuncFreeze(bar$_lit, 'bar$_lit');})()]);x0___ = (function () {  function baz$_meth() {    x.bar_canCall___? x.bar(): ___.callPub(x, 'bar', []);  }  return ___.markFuncFreeze(baz$_meth, 'baz$_meth');})(), x.baz_canSet___ === x? (x.baz = x0___) :                              ___.setPub(x, 'baz', x0___);zip = (function () {  function zip$_var() {    x.baz_canCall___ ? x.baz() : ___.callPub(x, 'baz', []);  }  return ___.markFuncFreeze(zip$_var, 'zip$_var');})();zap = (function () {  function zap$_var() { zip.CALL___(); }  return ___.markFuncFreeze(zap$_var, 'zap$_var');})();zap.CALL___();");
    }

    @FailureIsAnOption
    public final void testRecordInheritance() throws Exception {
        this.rewriteAndExecute("var x = {a: 8};var y = cajita.beget(x);testImports.y = y;", "assertTrue(cajita.canReadPub(y, 'a'));", "");
    }

    public final void testNoPrototypicalImports() throws Exception {
        this.rewriteAndExecute("var x;try { x = toString; } catch (e) {}if (x) { cajita.fail('Inherited global properties are readable'); }");
    }

    public final void testModule() throws Exception {
        final CajitaModuleRewriter moduleRewriter = new CajitaModuleRewriter(new PluginMeta(), TestBuildInfo.getInstance(), new TestUriFetcher(), false, this.mq);
        this.setRewriter(new Rewriter(this.mq, true, false){
            {
                super(x0, x1, x2);
                this.addRule(new Rule("UncajoledModule", this){

                    @RuleDescription(name="cajoledModule", synopsis="a cajoled module envelope", reason="", matches="<UncajoledModule>", substitutes="<CajoledModule>")
                    public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                        CajitaRewriter cr = new CajitaRewriter(CajitaRewriterTest.this.is.getUri(), moduleRewriter.getModuleManager(), false);
                        return moduleRewriter.rewrite(Collections.singletonList((CajoledModule)cr.expand(node, scope)));
                    }
                });
            }
        });
        this.rewriteAndExecute("var r = load('foo/testPrimordials')({}); assertEquals(r, 9);");
        this.rewriteAndExecute("var m = load('foo/testPrimordials'); assertEquals('com.google.caja', m.cajolerName);assertEquals('testBuildVersion', m.cajolerVersion);assertEquals(0, m.cajoledDate);assertEquals(void 0, m.includedModules);assertThrows(function() { m.cajolerName = 'bar'; });assertThrows(function() { m.includedModules = 'bar'; });assertThrows(function() { m.includedModules.foo = 'bar'; });assertThrows(function() { m.foo = 'bar'; });");
        this.rewriteAndExecute("var r = load('foo/b')({x: 6, y: 3}); assertEquals(r, 11);");
        this.rewriteAndExecute("var r1 = load('foo/b')({x: 6, y: 3}); var r2 = load('foo/b')({x: 1, y: 2}); var r3 = load('c')({x: 2, y: 6}); var r = r1 + r2 + r3; assertEquals(r, 24);");
        this.rewriteAndExecute("var m = load('foo/b');var s = m.cajolerName;assertEquals('com.google.caja', s);");
        this.checkAddsMessage(new UncajoledModule(this.js(this.fromString("var m = load('foo/c');"))), RewriterMessageType.MODULE_NOT_FOUND, MessageLevel.FATAL_ERROR);
        this.checkAddsMessage(new UncajoledModule(this.js(this.fromString("var s = 'c'; var m = load(s);"))), RewriterMessageType.CANNOT_LOAD_A_DYNAMIC_CAJITA_MODULE, MessageLevel.FATAL_ERROR);
    }

    public final void testErrorFreeze() throws Exception {
        this.rewriteAndExecute("try {  throw new Error('foo');} catch (ex) {  assertTrue(cajita.isFrozen(ex));}");
    }

    public final void testUnderscore() throws Exception {
        this.checkFails("var o = { p__: 1 };", "Properties cannot end in \"__\"");
    }

    public final void testObjectFreeze() throws Exception {
        this.rewriteAndExecute("var r = Object.freeze({});assertThrows(function(){r.foo = 8;});");
        this.rewriteAndExecute("var f = function(){};assertThrows(function(){f.foo = 8;});");
        this.rewriteAndExecute("var f = Object.freeze(function(){});assertThrows(function(){f.foo = 8;});");
        this.rewriteAndExecute("function Point(x,y) {  this.x = x;  this.y = y;}___.markCtor(Point, Object, 'Point');testImports.pt = new Point(3,5);___.grantSet(testImports.pt, 'x');", "pt.x = 8;assertThrows(function(){Object.freeze(pt);});", "");
    }

    public final void testNoPrivilegeEscalation() throws Exception {
        this.rewriteAndExecute("", "assertTrue([].valueOf.call(null) === cajita.USELESS);", "assertTrue([].valueOf.call(null) === this);");
        this.rewriteAndExecute("", "assertTrue([].valueOf.apply(null, []) === cajita.USELESS);", "assertTrue([].valueOf.apply(null, []) === this);");
        this.rewriteAndExecute("", "assertTrue([].valueOf.bind(null)() === cajita.USELESS);", "assertTrue([].valueOf.bind(null)() === this);");
    }

    public final void testTamedXo4aOkOnNull() throws Exception {
        this.rewriteAndExecute("this.foo = 8;", "var x = cajita.beget(cajita.USELESS);assertFalse(({foo: 7}).hasOwnProperty.call(null, 'foo'));assertTrue(cajita.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.call(null, x));", "assertTrue(({}).hasOwnProperty.call(null, 'foo'));assertFalse(({bar: 7}).hasOwnProperty.call(null, 'bar'));");
        this.rewriteAndExecute("this.foo = 8;", "var x = cajita.beget(cajita.USELESS);assertFalse(({foo: 7}).hasOwnProperty.apply(null, ['foo']));assertTrue(cajita.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.apply(null, [x]));", "assertTrue(({}).hasOwnProperty.apply(null, ['foo']));assertFalse(({bar: 7}).hasOwnProperty.apply(null, ['bar']));");
        this.rewriteAndExecute("this.foo = 8;", "var x = cajita.beget(cajita.USELESS);assertFalse(({foo: 7}).hasOwnProperty.bind(null)('foo'));assertTrue(cajita.USELESS.isPrototypeOf(x));assertTrue(({foo: 7}).isPrototypeOf.bind(null)(x));", "assertTrue(({}).hasOwnProperty.bind(null)('foo'));assertFalse(({bar: 7}).hasOwnProperty.bind(null)('bar'));");
    }

    public final void testJSONClass() throws Exception {
        this.rewriteAndExecute("assertTrue(''+JSON === '[object Object]');");
    }

    public final void testNoCanSetInheritance() throws Exception {
        this.rewriteAndExecute("(function() {  var a = {};  var b = cajita.freeze(cajita.beget(a));  a.x = 8;  assertThrows(function(){b.x = 9;});  assertEquals(b.x, 8);})();");
    }

    public final void testFeralTameBoundary() throws Exception {
        this.rewriteAndExecute("function forbidden() { return arguments; }function xo4ic(f) {  return ___.callPub(f, 'call', [___.USELESS, this]);}___.markXo4a(xo4ic);function innocent(f) { return f(this); }___.markInnocent(innocent);function simple(f) {  return ___.callPub(f, 'call', [___.USELESS, simple]); }___.markFuncFreeze(simple);function Point(x,y) {  this.x = x;  this.y = y;}Point.prototype.getX = function() { return this.x; };Point.prototype.getY = function() { return this.y; };Point.prototype.badness = function(str) { return eval(str); };Point.prototype.welcome = function(visitor) {  return visitor(this.x, this.y); };___.markCtor(Point, Object, 'Point');___.grantGenericMethod(Point.prototype, 'getX');___.grantTypedMethod(Point.prototype, 'getY');___.grantInnocentMethod(Point.prototype, 'welcome');var pt = new Point(3,5);function eight() { return 8; }function nine() { return 9; }___.markFuncFreeze(nine);___.tamesTo(eight, nine);var funcs = [[simple, Point, pt], forbidden,              xo4ic, innocent, eight];___.freeze(funcs[0]);funcs[5] = funcs;var f = {   forbidden: forbidden,  xo4ic: xo4ic,  innocent: innocent,  simple: simple,  Point: Point,  pt: pt,  eight: eight,  funcs: funcs};f.f = f;funcs[6] = f;testImports.f = f;testImports.t = ___.tame(f);", "assertFalse(f === t);assertFalse('forbidden' in t);assertFalse(f.xo4ic === t.xo4ic);assertFalse(f.innocent === t.innocent);assertTrue(f.simple === t.simple);assertTrue(f.Point === t.Point);assertTrue(f.pt === t.pt);assertFalse('x' in t.pt);assertFalse('y' in t.pt);assertTrue('getX' in t.pt);assertTrue('getY' in t.pt);assertFalse('badness' in t.pt);assertTrue('welcome' in t.pt);assertFalse(f.eight === t.eight);assertFalse(f.funcs === t.funcs);assertTrue(f.funcs[0][0] === t.funcs[0][0]);assertTrue(f.funcs[0] === t.funcs[0]);assertTrue('1' in t.funcs);assertTrue(t.funcs[1] === void 0);assertTrue(t.funcs === t.funcs[5]);assertTrue(t === t.funcs[6]);assertTrue(t === t.f);var lastArg = void 0;function capture(arg) { return lastArg = arg; }var lastResult = t.xo4ic.call(void 0, capture);assertTrue(lastArg === cajita.USELESS);assertTrue(lastResult === cajita.USELESS);lastResult = t.innocent.call(void 0, capture);assertTrue(lastArg === cajita.USELESS);assertTrue(lastResult === cajita.USELESS);lastResult = t.innocent.apply(void 0, [capture]);assertTrue(lastArg === cajita.USELESS);assertTrue(lastResult === cajita.USELESS);lastResult = t.simple(capture);assertTrue(lastArg === t.simple);assertTrue(lastResult === t.simple);assertTrue(t.pt.getX() === 3);assertTrue(t.pt.getY() === 5);var getX = t.pt.getX;var getY = t.pt.getY;assertTrue(cajita.isPseudoFunc(getX));assertTrue(cajita.isPseudoFunc(getY));assertTrue(getX.call(t.pt) === 3);assertTrue(getY.call(t.pt) === 5);var nonpt = {x: 33, y: 55};assertTrue(getX.call(nonpt) === 33);assertThrows(function() { getY.call(nonpt); });function visitor(x, y) {  assertTrue(x === 3);  assertTrue(y === 5);}t.pt.welcome(visitor);assertTrue(t.eight() === 9);lastResult = t.innocent.call(void 0, t.eight);assertTrue(lastResult === 8);lastResult = t.innocent.apply(void 0, [t.eight]);assertTrue(lastResult === 8);", "");
    }

    protected Object executePlain(String caja) throws IOException {
        this.mq.getMessages().clear();
        return RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(caja, this.getName() + "-uncajoled"));
    }

    protected Object rewriteAndExecute(String pre, String caja, String post) throws IOException, ParseException {
        this.mq.getMessages().clear();
        List<Block> children = Lists.newArrayList();
        children.add(this.js(this.fromString(caja, this.is)));
        String cajoledJs = CajitaRewriterTest.render(this.rewriteTopLevelNode(new UncajoledModule(new Block(FilePosition.UNKNOWN, children))));
        this.assertNoErrors();
        String[] assertFunctions = new String[]{"fail", "assertEquals", "assertTrue", "assertFalse", "assertLessThan", "assertNull", "assertThrows"};
        StringBuilder importsSetup = new StringBuilder();
        importsSetup.append("var testImports = ___.copy(___.sharedImports);");
        for (String f : assertFunctions) {
            importsSetup.append("testImports." + f + " = ___.markFuncFreeze(" + f + ");").append("___.grantRead(testImports, '" + f + "');");
        }
        importsSetup.append("___.getNewModuleHandler().setImports(testImports);");
        Object result = RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/plugin/console-stubs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/log-to-console.js"), new Executor.Input(importsSetup.toString(), this.getName() + "-test-fixture"), new Executor.Input(pre, this.getName()), new Executor.Input(cajoledJs, this.getName() + "-cajoled"), new Executor.Input(post, this.getName()), new Executor.Input("___.getNewModuleHandler().getLastValue();", this.getName()));
        this.assertNoErrors();
        return result;
    }

    protected class TestUriFetcher
    implements UriFetcher {
        protected TestUriFetcher() {
        }

        public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
            URI uri = ref.getUri();
            if ("test".equals(uri.getScheme())) {
                try {
                    InputSource is = new InputSource(uri);
                    return CajitaRewriterTest.this.dataFromResource(uri.getPath().substring(1), is);
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
            }
            throw new UriFetcher.UriFetchException(ref, mimeType);
        }
    }
}

