/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.parser.quasiliteral.ES53Rewriter;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleManager {
    private final PluginMeta meta;
    private final BuildInfo buildInfo;
    private final UriFetcher uriFetcher;
    private final boolean isValija;
    private final MessageQueue mq;
    private final Map<URI, Integer> moduleNameMap = Maps.newHashMap();
    private final List<CajoledModule> modules = Lists.newArrayList();

    public ModuleManager(PluginMeta meta, BuildInfo buildInfo, UriFetcher uriFetcher, boolean isValija, MessageQueue mq) {
        assert (uriFetcher != null);
        this.meta = meta;
        this.buildInfo = buildInfo;
        this.uriFetcher = uriFetcher;
        this.isValija = isValija;
        this.mq = mq;
    }

    public List<CajoledModule> getModuleMap() {
        return Collections.unmodifiableList(this.modules);
    }

    public PluginMeta getPluginMeta() {
        return this.meta;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public UriFetcher getUriFetcher() {
        return this.uriFetcher;
    }

    public boolean isValija() {
        return this.isValija;
    }

    public MessageQueue getMessageQueue() {
        return this.mq;
    }

    public int appendCajoledModule(URI uri, CajoledModule cajoledModule) {
        if (!uri.isAbsolute() || this.moduleNameMap.containsKey(uri)) {
            throw new IllegalArgumentException(uri.toString());
        }
        int index = this.modules.size();
        this.moduleNameMap.put(uri, index);
        this.modules.add(cajoledModule);
        return index;
    }

    public int getModule(URI baseUri, StringLiteral src) {
        CharProducer cp;
        String uriStr;
        try {
            uriStr = UriUtil.normalizeUri(src.getUnquotedValue());
        }
        catch (URISyntaxException ex) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.INVALID_MODULE_URI, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
        URI relUri = URI.create(uriStr);
        String path = relUri.getRawPath();
        if (path != null && path.indexOf(46, path.lastIndexOf(47) + 1) < 0) {
            int queryStart;
            int n = uriStr.length();
            int fragmentStart = uriStr.lastIndexOf(35);
            if (fragmentStart < 0) {
                fragmentStart = n;
            }
            if ((queryStart = uriStr.lastIndexOf(63, fragmentStart)) < 0) {
                queryStart = fragmentStart;
            }
            relUri = URI.create(uriStr.substring(0, queryStart) + ".js" + uriStr.substring(queryStart));
        }
        URI absoluteUri = null;
        if (baseUri != null) {
            try {
                absoluteUri = UriUtil.resolve(baseUri, relUri.toString());
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
        if (absoluteUri == null) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.INVALID_MODULE_URI, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
        if (this.moduleNameMap.containsKey(absoluteUri)) {
            return this.moduleNameMap.get(absoluteUri);
        }
        ExternalReference er = new ExternalReference(absoluteUri, src.getFilePosition());
        try {
            cp = this.uriFetcher.fetch(er, ContentType.JS.mimeType).getTextualContent();
        }
        catch (UriFetcher.UriFetchException ex) {
            ex.toMessageQueue(this.mq);
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.MODULE_NOT_FOUND, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
        catch (UnsupportedEncodingException ex) {
            this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.toString()));
            return -1;
        }
        try {
            InputSource is = cp.getCurrentPosition().source();
            JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), is);
            Block input = new Parser(tq, this.mq).parse();
            tq.expectEmpty();
            CajoledModule cajoledModule = null;
            if (this.meta.getEnableES53()) {
                ES53Rewriter rewriter = new ES53Rewriter(absoluteUri, this, false);
                cajoledModule = (CajoledModule)rewriter.expand(new UncajoledModule(input));
            } else {
                Block intermediate = this.isValija ? (Block)new DefaultValijaRewriter(this.mq).expand(input) : input;
                CajitaRewriter cr = new CajitaRewriter(absoluteUri, this, false);
                UncajoledModule uncajoledModule = new UncajoledModule(intermediate);
                cajoledModule = (CajoledModule)cr.expand(uncajoledModule);
            }
            FilePosition unk = FilePosition.UNKNOWN;
            cajoledModule.getModuleBody().appendChild(new ValueProperty(StringLiteral.valueOf(unk, "src"), StringLiteral.valueOf(unk, "" + absoluteUri)));
            return this.appendCajoledModule(absoluteUri, cajoledModule);
        }
        catch (ParseException e) {
            e.toMessageQueue(this.mq);
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.PARSING_MODULE_FAILED, src.getFilePosition(), MessagePart.Factory.valueOf(src.getUnquotedValue()));
            return -1;
        }
    }
}

