/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral.opt;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.js.scope.AbstractScope;
import com.google.caja.parser.js.scope.ScopeListener;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.parser.js.scope.WorstCaseScopeAnalyzer;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScopeTree
implements AbstractScope {
    private final AncestorChain<?> root;
    private final ScopeTree parent;
    private final List<ScopeTree> children = Lists.newArrayList();
    private final ScopeType scopeType;
    private final Map<String, Set<AncestorChain<Identifier>>> uses = Maps.newLinkedHashMap();

    public static ScopeTree create(AncestorChain<?> scopeRoot) {
        AncestorChain<Block> bl = scopeRoot.node instanceof UncajoledModule ? scopeRoot.child(((UncajoledModule)scopeRoot.cast(UncajoledModule.class).node).getModuleBody()) : scopeRoot.cast(Block.class);
        ScopeListener<ScopeTree> listener = new ScopeListener<ScopeTree>(){

            @Override
            public void declaration(AncestorChain<Identifier> id, ScopeTree scope) {
                Set<AncestorChain<Identifier>> uses = Sets.newLinkedHashSet();
                uses.add(id);
                scope.uses.put(((Identifier)id.node).getName(), uses);
            }

            @Override
            public void inScope(AncestorChain<?> ac, ScopeTree scope) {
            }

            @Override
            public void masked(AncestorChain<Identifier> id, ScopeTree inner, ScopeTree outer) {
            }

            @Override
            public void splitInitialization(AncestorChain<Identifier> declared, ScopeTree declScope, AncestorChain<Identifier> initialized, ScopeTree maskingScope) {
            }

            @Override
            public void duplicate(AncestorChain<Identifier> id, ScopeTree scope) {
            }

            @Override
            public void read(AncestorChain<Identifier> id, ScopeTree useSite, ScopeTree definingSite) {
                Set uses;
                if (definingSite != null && (uses = (Set)definingSite.uses.get(((Identifier)id.node).getName())) != null) {
                    uses.add(id);
                }
            }

            @Override
            public void assigned(AncestorChain<Identifier> id, ScopeTree useSite, ScopeTree definingSite) {
                if (definingSite != null) {
                    ((Set)definingSite.uses.get(((Identifier)id.node).getName())).add(id);
                }
            }

            @Override
            public ScopeTree createScope(ScopeType t, AncestorChain<?> root, ScopeTree parent) {
                ScopeTree child = new ScopeTree(parent, root, t);
                if (parent != null) {
                    parent.children.add(child);
                }
                return child;
            }

            @Override
            public void enterScope(ScopeTree scope) {
            }

            @Override
            public void exitScope(ScopeTree scope) {
            }
        };
        return (ScopeTree)new WorstCaseScopeAnalyzer<ScopeTree>(listener).apply(bl);
    }

    private ScopeTree(ScopeTree parent, AncestorChain<?> scopeRoot, ScopeType t) {
        this.parent = parent;
        this.root = scopeRoot;
        this.scopeType = t;
    }

    public AncestorChain<?> getRoot() {
        return this.root;
    }

    @Override
    public boolean isSymbolDeclared(String name) {
        ScopeTree t = this;
        while (t != null) {
            if (t.uses.containsKey(name)) {
                return true;
            }
            t = t.parent;
        }
        return false;
    }

    @Override
    public ScopeTree getContainingScope() {
        return this.parent;
    }

    @Override
    public ScopeType getType() {
        return this.scopeType;
    }

    public Iterable<AncestorChain<Identifier>> usesOf(String identifier) {
        ScopeTree t = this;
        while (t != null) {
            Set<AncestorChain<Identifier>> usesForId = t.uses.get(identifier);
            if (usesForId != null) {
                return Collections.unmodifiableSet(usesForId);
            }
            t = t.parent;
        }
        return Collections.emptySet();
    }

    public ScopeTree scopeForChild(ParseTreeNode n) {
        if (ScopeType.forNode(n) != null) {
            for (ScopeTree t : this.children) {
                if (t.root.node != n) continue;
                return t;
            }
            throw new RuntimeException("No scope attached to " + n + " @ " + n.getFilePosition());
        }
        return this;
    }

    public List<ScopeTree> children() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(0, sb);
        return sb.toString();
    }

    private void toStringBuilder(int depth, StringBuilder sb) {
        int d = depth;
        while (--d >= 0) {
            sb.append("  ");
        }
        sb.append("(ScopeTree ");
        if (this.root.node instanceof FunctionConstructor) {
            sb.append("function");
            String name = ((FunctionConstructor)this.root.cast(FunctionConstructor.class).node).getIdentifierName();
            if (name != null) {
                sb.append(' ').append(name);
            }
        } else {
            String typeName = this.root.node.getClass().getSimpleName();
            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
            sb.append(typeName);
        }
        for (ScopeTree child : this.children) {
            sb.append('\n');
            child.toStringBuilder(depth + 1, sb);
        }
        sb.append(')');
    }
}

