/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.service.CajolingService;
import com.google.caja.service.CajolingServlet;
import com.google.caja.util.CajaTestCase;
import java.util.List;
import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrowserTestCase
extends CajaTestCase {
    protected Server server;
    private static final String START_AND_WAIT_FLAG = "caja.BrowserTestCase.startAndWait";
    private static final long START_AND_WAIT_MILLIS = 86400000L;

    protected void startLocalServer() {
        this.server = new Server(this.portNumber());
        ResourceHandler resource_handler = new ResourceHandler();
        resource_handler.setResourceBase(".");
        String subdir = "/caja";
        ContextHandler caja = new ContextHandler("/caja");
        String service = "/cajole";
        ResourceHandler caja_static = new ResourceHandler();
        caja_static.setResourceBase("./ant-war/");
        Context servlets = new Context((HandlerContainer)this.server, "/", 0);
        servlets.addServlet(new ServletHolder((Servlet)new CajolingServlet(new CajolingService(BuildInfo.getInstance(), "http://localhost:" + this.portNumber() + "/caja" + "/cajole"))), "/cajole");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{caja_static, servlets, new DefaultHandler()});
        caja.setHandler((Handler)handlers);
        HandlerList handlers2 = new HandlerList();
        handlers2.setHandlers(new Handler[]{resource_handler, caja, new DefaultHandler()});
        this.server.setHandler((Handler)handlers2);
        try {
            this.server.start();
        }
        catch (Exception e) {
            BrowserTestCase.fail((String)"Starting the local web server failed!");
        }
    }

    protected void stopLocalServer() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int portNumber() {
        return 8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runBrowserTest(String pageName) {
        if (this.checkHeadless()) {
            return;
        }
        this.startLocalServer();
        if (System.getProperty(START_AND_WAIT_FLAG) != null) {
            try {
                Thread.sleep(86400000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            FirefoxDriver driver = new FirefoxDriver();
            driver.get("http://localhost:8000/ant-lib/com/google/caja/plugin/" + pageName);
            this.driveBrowser((WebDriver)driver, pageName);
            driver.quit();
        }
        finally {
            this.stopLocalServer();
        }
    }

    protected void runTestDriver(String testDriver) {
        this.runBrowserTest("browser-test-case.html?test-driver=" + testDriver);
    }

    protected void runTestCase(String testCase) {
        this.runBrowserTest("browser-test-case.html?test-case=" + testCase);
    }

    protected void driveBrowser(final WebDriver driver, String pageName) {
        BrowserTestCase.poll(20000, 200, new Check(){

            public String toString() {
                return "startup";
            }

            public boolean run() {
                List readyElements = driver.findElements(By.xpath((String)"//*[@class='readytotest']"));
                return readyElements.size() != 0;
            }
        });
        BrowserTestCase.poll(10000, 1000, new Check(){
            private List<WebElement> clickingList = null;

            public String toString() {
                return "clicking done (Remaining elements = " + BrowserTestCase.renderElements(this.clickingList) + ")";
            }

            public boolean run() {
                this.clickingList = driver.findElements(By.xpath((String)"//*[contains(@class,'clickme')]/*"));
                for (WebElement e : this.clickingList) {
                    e.click();
                }
                return this.clickingList.isEmpty();
            }
        });
        BrowserTestCase.poll(20000, 1000, new Check(){
            private List<WebElement> waitingList = null;

            public String toString() {
                return "completion (Remaining elements = " + BrowserTestCase.renderElements(this.waitingList) + ")";
            }

            public boolean run() {
                this.waitingList = driver.findElements(By.xpath((String)"//*[contains(@class,'waiting')]"));
                return this.waitingList.isEmpty();
            }
        });
        String title = driver.getTitle();
        BrowserTestCase.assertTrue((String)("The title shows " + title), (boolean)title.contains("all tests passed"));
    }

    protected static void poll(int timeoutMillis, int intervalMillis, Check c) {
        int rounds;
        int limit = timeoutMillis / intervalMillis;
        for (rounds = 0; rounds < limit && !c.run(); ++rounds) {
            try {
                Thread.sleep(intervalMillis);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        BrowserTestCase.assertTrue((String)(timeoutMillis + " ms passed while waiting for: " + c + "."), (rounds < limit ? 1 : 0) != 0);
    }

    protected static String renderElements(List<WebElement> elements) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int n = elements.size();
        for (int i = 0; i < n; ++i) {
            String className;
            if (i != 0) {
                sb.append(", ");
            }
            WebElement el = elements.get(i);
            sb.append('<').append(el.getTagName());
            String id = el.getAttribute("id");
            if (id != null) {
                sb.append(" id=\"");
                Escaping.escapeXml((CharSequence)id, false, sb);
                sb.append('\"');
            }
            if ((className = el.getAttribute("class")) != null) {
                sb.append(" class=\"");
                Escaping.escapeXml((CharSequence)className, false, sb);
                sb.append('\"');
            }
            sb.append('>');
        }
        sb.append(']');
        return sb.toString();
    }

    public static interface Check {
        public boolean run();
    }
}

