/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.ancillary.opt.JsOptimizer;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Minify;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Statement;
import com.google.caja.plugin.LoaderType;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginCompilerMain;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriEffect;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.BufferingRenderer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.Innocent;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.reporting.SnippetProducer;
import com.google.caja.tools.BuildService;
import com.google.caja.util.Charsets;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildServiceImplementation
implements BuildService {
    private final Map<InputSource, String> originalSources = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cajole(PrintWriter logger, List<File> dependees, List<File> inputs, File output, Map<String, Object> options) {
        Node outputHtml;
        JsonMLCompatible outputJs;
        final Set<File> canonFiles = Sets.newHashSet();
        try {
            for (File f : dependees) {
                canonFiles.add(f.getCanonicalFile());
            }
            for (File f : inputs) {
                canonFiles.add(f.getCanonicalFile());
            }
        }
        catch (IOException ex) {
            logger.println(ex.toString());
            return false;
        }
        SimpleMessageQueue mq = new SimpleMessageQueue();
        UriFetcher fetcher = new UriFetcher(){

            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                URI uri = ref.getUri();
                uri = ref.getReferencePosition().source().getUri().resolve(uri);
                InputSource is = new InputSource(uri);
                try {
                    if (!canonFiles.contains(new File(uri).getCanonicalFile())) {
                        throw new UriFetcher.UriFetchException(ref, mimeType);
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
                try {
                    String content = BuildServiceImplementation.this.getSourceContent(is);
                    if (content == null) {
                        throw new UriFetcher.UriFetchException(ref, mimeType);
                    }
                    return FetchedData.fromCharProducer(CharProducer.Factory.fromString((CharSequence)content, is), mimeType, Charsets.UTF_8.name());
                }
                catch (IOException ex) {
                    throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                }
            }
        };
        final UriPolicy prePolicy = new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference u, UriEffect effect, LoaderType loader, Map<String, ?> hints) {
                return URI.create("http://example.com/?effect=" + (Object)((Object)effect) + "&loader=" + (Object)((Object)loader) + "&uri=" + UriUtil.encode("" + u.getUri())).toString();
            }
        };
        final Set lUrls = (Set)options.get("canLink");
        UriPolicy policy = !lUrls.isEmpty() ? new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference u, UriEffect effect, LoaderType loader, Map<String, ?> hints) {
                String uri = u.getUri().toString();
                if (lUrls.contains(uri)) {
                    return uri;
                }
                return prePolicy.rewriteUri(u, effect, loader, hints);
            }
        } : prePolicy;
        MessageContext mc = new MessageContext();
        String language = (String)options.get("language");
        boolean passed = true;
        if ("caja".equals(language) || "valija".equals(language)) {
            PluginMeta meta = new PluginMeta(fetcher, policy);
            meta.setEnableES53("caja".equals(language));
            PluginCompiler compiler = new PluginCompiler(BuildInfo.getInstance(), meta, mq);
            compiler.setMessageContext(mc);
            if (Boolean.TRUE.equals(options.get("debug"))) {
                compiler.setGoals(compiler.getGoals().without(PipelineMaker.ONE_CAJOLED_MODULE).with(PipelineMaker.ONE_CAJOLED_MODULE_DEBUG));
            }
            if (Boolean.TRUE.equals(options.get("onlyJsEmitted"))) {
                compiler.setGoals(compiler.getGoals().without(PipelineMaker.HTML_SAFE_STATIC));
            }
            for (File f : inputs) {
                try {
                    URI fileUri = f.getCanonicalFile().toURI();
                    ParseTreeNode parsedInput = this.parseInput(new InputSource(fileUri), mq);
                    if (parsedInput == null) {
                        passed = false;
                        continue;
                    }
                    compiler.addInput(parsedInput, fileUri);
                }
                catch (IOException ex) {
                    logger.println("Failed to read " + f);
                    passed = false;
                }
            }
            passed = passed && compiler.run();
            outputJs = passed ? compiler.getJavascript() : null;
            outputHtml = passed ? compiler.getStaticHtml() : null;
        } else if ("javascript".equals(language)) {
            passed = true;
            JsOptimizer optimizer = new JsOptimizer(mq);
            for (File f : inputs) {
                try {
                    if (f.getName().endsWith(".env.json")) {
                        BuildServiceImplementation.loadEnvJsonFile(f, optimizer, mq);
                        continue;
                    }
                    ParseTreeNode parsedInput = this.parseInput(new InputSource(f.getCanonicalFile().toURI()), mq);
                    if (parsedInput == null) continue;
                    optimizer.addInput((Statement)parsedInput);
                }
                catch (IOException ex) {
                    logger.println("Failed to read " + f);
                    passed = false;
                }
            }
            outputJs = optimizer.optimize();
            outputHtml = null;
        } else {
            throw new RuntimeException("Unrecognized language: " + language);
        }
        passed = passed && !BuildServiceImplementation.hasErrors(mq);
        Set toIgnore = (Set)options.get("toIgnore");
        if (toIgnore == null) {
            toIgnore = Collections.emptySet();
        }
        SnippetProducer snippetProducer = new SnippetProducer(this.originalSources, mc);
        for (Message msg : mq.getMessages()) {
            if (passed && MessageLevel.LOG.compareTo(msg.getMessageLevel()) >= 0) continue;
            String snippet = snippetProducer.getSnippet(msg);
            if (!"".equals(snippet)) {
                snippet = "\n" + snippet;
            }
            if (passed && toIgnore.contains(msg.getMessageType().name())) continue;
            logger.println((Object)((Object)msg.getMessageLevel()) + " : " + msg.format(mc) + snippet);
        }
        if (passed) {
            String translatedCode;
            BufferingRenderer renderer;
            boolean asXml = output.getName().endsWith(".xhtml");
            boolean emitMarkup = asXml || output.getName().endsWith(".html");
            StringBuilder jsOut = new StringBuilder();
            String rendererType = (String)options.get("renderer");
            if ("pretty".equals(rendererType)) {
                renderer = new JsPrettyPrinter(new Concatenator(jsOut));
            } else if ("minify".equals(rendererType)) {
                renderer = new JsMinimalPrinter(new Concatenator(jsOut));
            } else {
                throw new RuntimeException("Unrecognized renderer " + rendererType);
            }
            RenderContext rc = new RenderContext(renderer).withEmbeddable(emitMarkup);
            outputJs.render(rc);
            rc.getOut().noMoreTokens();
            String htmlOut = "";
            if (outputHtml != null) {
                htmlOut = Nodes.render(outputHtml, asXml ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
            }
            if (emitMarkup) {
                Document doc = DomParser.makeDocument(null, null);
                String ns = "http://www.w3.org/1999/xhtml";
                Element script = doc.createElementNS(ns, "script");
                script.setAttributeNS(ns, "type", "text/javascript");
                script.appendChild(doc.createCDATASection(jsOut.toString()));
                translatedCode = htmlOut + Nodes.render((Node)script, asXml ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
            } else {
                if (!"".equals(htmlOut)) {
                    throw new RuntimeException("Can't emit HTML to " + output);
                }
                translatedCode = jsOut.toString();
            }
            try {
                OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(output));
                try {
                    w.write(translatedCode);
                }
                finally {
                    ((Writer)w).close();
                }
            }
            catch (IOException ex) {
                logger.println("Failed to write " + output);
                return false;
            }
        }
        return passed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourceContent(InputSource is) throws IOException {
        String content = this.originalSources.get(is);
        if (content == null) {
            File f = new File(is.getUri());
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(f), Charsets.UTF_8);
            try {
                int n;
                char[] buf = new char[4096];
                StringBuilder sb = new StringBuilder();
                while ((n = ((Reader)in).read(buf, 0, buf.length)) > 0) {
                    sb.append(buf, 0, n);
                }
                content = sb.toString();
            }
            finally {
                ((Reader)in).close();
            }
            this.originalSources.put(is, content);
        }
        return content;
    }

    private ParseTreeNode parseInput(InputSource is, MessageQueue mq) throws IOException {
        CharProducer cp = CharProducer.Factory.fromString((CharSequence)this.getSourceContent(is), is);
        try {
            return PluginCompilerMain.parseInput(is, cp, mq);
        }
        catch (ParseException ex) {
            ex.toMessageQueue(mq);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean minify(PrintWriter logger, List<File> dependees, List<File> inputs, File output, Map<String, Object> options) {
        boolean bl;
        List<Pair<InputSource, File>> inputSources = Lists.newArrayList();
        for (File f : inputs) {
            inputSources.add(Pair.pair(new InputSource(f.getAbsoluteFile().toURI()), f));
        }
        OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8);
        try {
            bl = Minify.minify(inputSources, outputWriter, logger);
        }
        catch (Throwable throwable) {
            try {
                ((Writer)outputWriter).close();
                throw throwable;
            }
            catch (IOException ex) {
                logger.println("Minifying failed: " + ex);
                return false;
            }
        }
        ((Writer)outputWriter).close();
        return bl;
    }

    @Override
    public boolean transfInnocent(PrintWriter logger, List<File> dependees, List<File> inputs, File output, Map<String, Object> options) {
        try {
            OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8);
            for (File f : inputs) {
                Pair<InputSource, File> inputSource = Pair.pair(new InputSource(f.getAbsoluteFile().toURI()), f);
                boolean ret = Innocent.transfInnocent(inputSource, outputWriter, logger);
                if (ret) continue;
                ((Writer)outputWriter).close();
                return false;
            }
            ((Writer)outputWriter).close();
            return true;
        }
        catch (IOException ex) {
            logger.println("Innocent transform failed: " + ex);
            return false;
        }
    }

    private static void loadEnvJsonFile(File f, JsOptimizer op, MessageQueue mq) {
        ObjectConstructor envJson;
        CharProducer cp;
        try {
            cp = BuildServiceImplementation.read(f);
        }
        catch (IOException ex) {
            mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.toString()));
            return;
        }
        try {
            Parser p = BuildServiceImplementation.parser(cp, mq);
            Expression e = p.parseExpression(true);
            p.getTokenQueue().expectEmpty();
            if (!(e instanceof ObjectConstructor)) {
                mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf("Invalid JSON in " + f));
                return;
            }
            envJson = (ObjectConstructor)e;
        }
        catch (ParseException ex) {
            ex.toMessageQueue(mq);
            return;
        }
        op.setEnvJson(envJson);
    }

    private static CharProducer read(File f) throws IOException {
        InputSource is = new InputSource(f.toURI());
        return CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream(f), Charsets.UTF_8), is);
    }

    private static Parser parser(CharProducer cp, MessageQueue errs) {
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, cp.getCurrentPosition().source());
        return new Parser(tq, errs);
    }

    private static boolean hasErrors(MessageQueue mq) {
        for (Message msg : mq.getMessages()) {
            if (MessageLevel.ERROR.compareTo(msg.getMessageLevel()) > 0) continue;
            return true;
        }
        return false;
    }
}

