/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.plugin.ExpressionSanitizerCaja;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.CajaTestCase;

public class ExpressionSanitizerTest
extends CajaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testBasicRewriting() throws Exception {
        this.assertSanitize("  'use strict';'use cajita';g[i];", "  var g = ___.readImport(IMPORTS___, 'g');var i = ___.readImport(IMPORTS___, 'i');___.readPub(g, i);");
    }

    public final void testNoSpuriousRewriteErrorFound() {
        this.newPassThruSanitizer().sanitize(new Identifier(FilePosition.UNKNOWN, "x"));
        ExpressionSanitizerTest.assertFalse((boolean)this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR));
    }

    public final void testRewriteErrorIsDetected() {
        this.newPassThruSanitizer().sanitize(new Identifier(FilePosition.UNKNOWN, "x__"));
        ExpressionSanitizerTest.assertTrue((boolean)this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR));
    }

    public final void testNonAsciiIsDetected() {
        this.newPassThruSanitizer().sanitize(new Identifier(FilePosition.UNKNOWN, "\u00e6"));
        ExpressionSanitizerTest.assertTrue((boolean)this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR));
    }

    private ExpressionSanitizerCaja newPassThruSanitizer() {
        ModuleManager mgr = new ModuleManager(new PluginMeta(), TestBuildInfo.getInstance(), UriFetcher.NULL_NETWORK, false, this.mq);
        return new ExpressionSanitizerCaja(mgr, null){

            protected Rewriter newCajitaRewriter(ModuleManager mgr) {
                return new Rewriter(ExpressionSanitizerTest.this.mq, true, true){
                    {
                        this.addRule(new Rule(){

                            @RuleDescription(name="passthru", synopsis="Pass through input vacuously 'expanded'", reason="Dummy rule for testing")
                            public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
                                return this.expandAll(node.clone(), scope);
                            }
                        });
                    }
                };
            }
        };
    }

    private void assertSanitize(String input, String golden) throws Exception {
        Block inputNode = this.js(this.fromString(input));
        ModuleManager mgr = new ModuleManager(new PluginMeta(), TestBuildInfo.getInstance(), UriFetcher.NULL_NETWORK, false, this.mq);
        ParseTreeNode sanitized = new ExpressionSanitizerCaja(mgr, null).sanitize(inputNode);
        String inputCmp = ExpressionSanitizerTest.render(sanitized);
        String goldenCmp = ExpressionSanitizerTest.render(this.js(this.fromString(golden)));
        ExpressionSanitizerTest.assertEquals((String)goldenCmp, (String)inputCmp);
        ExpressionSanitizerTest.assertFalse((boolean)this.mq.hasMessageAtLevel(MessageLevel.WARNING));
    }
}

