/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.templates.IhtmlRoot;
import com.google.caja.plugin.templates.SafeHtmlChunk;
import com.google.caja.plugin.templates.SafeJsChunk;
import com.google.caja.plugin.templates.ScriptPlaceholder;
import com.google.caja.plugin.templates.TemplateCompiler;
import com.google.caja.plugin.templates.TemplateSanitizer;
import com.google.caja.plugin.templates.ValidatedStylesheet;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Pipeline;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompileHtmlStage
implements Pipeline.Stage<Jobs> {
    private final CssSchema cssSchema;
    private final HtmlSchema htmlSchema;

    public CompileHtmlStage(CssSchema cssSchema, HtmlSchema htmlSchema) {
        if (null == cssSchema) {
            throw new NullPointerException();
        }
        if (null == htmlSchema) {
            throw new NullPointerException();
        }
        this.cssSchema = cssSchema;
        this.htmlSchema = htmlSchema;
    }

    @Override
    public boolean apply(Jobs jobs) {
        List<IhtmlRoot> html = Lists.newArrayList();
        List<ValidatedStylesheet> css = Lists.newArrayList();
        List<ScriptPlaceholder> js = Lists.newArrayList();
        Iterator<JobEnvelope> it = jobs.getJobs().iterator();
        while (it.hasNext()) {
            JobEnvelope env = it.next();
            Job job = env.job;
            switch (env.sourceType) {
                case CSS: {
                    if (env.fromCache) break;
                    css.add(new ValidatedStylesheet(env, (CssTree.StyleSheet)job.getRoot(), job.getBaseUri()));
                    it.remove();
                    break;
                }
                case HTML: {
                    html.add(new IhtmlRoot(env, ((Dom)job.getRoot()).getValue(), job.getBaseUri()));
                    it.remove();
                    break;
                }
                case JS: {
                    if (env.placeholderId == null) break;
                    js.add(new ScriptPlaceholder(env, env.job.getRoot()));
                    it.remove();
                    break;
                }
            }
        }
        MessageQueue mq = jobs.getMessageQueue();
        TemplateSanitizer ts = new TemplateSanitizer(this.htmlSchema, mq);
        for (IhtmlRoot ihtmlRoot : html) {
            ts.sanitize(ihtmlRoot.root);
        }
        TemplateCompiler tc = new TemplateCompiler(html, css, js, this.cssSchema, this.htmlSchema, jobs.getPluginMeta(), jobs.getMessageContext(), mq);
        Pair<List<SafeHtmlChunk>, List<SafeJsChunk>> htmlAndJs = tc.getSafeHtml(DomParser.makeDocument(null, null));
        for (SafeHtmlChunk outputHtml : (List)htmlAndJs.a) {
            Job outJob = this.makeJobFromHtml(outputHtml.root, outputHtml.baseUri);
            if (outJob == null) continue;
            jobs.getJobs().add(outputHtml.source.withJob(outJob));
        }
        for (SafeJsChunk outputJs : (List)htmlAndJs.b) {
            if (outputJs.body instanceof Block) {
                assert (!outputJs.source.fromCache);
                jobs.getJobs().add(outputJs.source.withJob(Job.jsJob((Block)outputJs.body, null)));
                continue;
            }
            assert (outputJs.source.fromCache);
            jobs.getJobs().add(outputJs.source.withJob(Job.cajoledJob((CajoledModule)outputJs.body)));
        }
        return jobs.hasNoFatalErrors();
    }

    abstract Job makeJobFromHtml(Node var1, URI var2);
}

