/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.config.WhiteList;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.Placeholder;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.plugin.stages.HtmlEmbeddedContentFinder;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.plugin.templates.HtmlAttributeRewriter;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Name;
import com.google.caja.util.Sets;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class HtmlExtractor {
    final HtmlSchema htmlSchema;
    final JobCache jobCache;
    final Jobs jobs;
    final JobEnvelope htmlEnv;
    private static final ElKey HTML = ElKey.forHtmlElement("html");
    private static final ElKey BODY = ElKey.forHtmlElement("body");
    private static final ElKey LINK = ElKey.forHtmlElement("link");
    private static final ElKey SCRIPT = ElKey.forHtmlElement("script");
    private static final ElKey STYLE = ElKey.forHtmlElement("style");
    private static final AttribKey BODY_ONLOAD = AttribKey.forHtmlAttrib(BODY, "onload");
    private static final AttribKey BODY_CLASS = AttribKey.forHtmlAttrib(BODY, "class");

    HtmlExtractor(HtmlSchema htmlSchema, JobCache jobCache, Jobs jobs, JobEnvelope htmlEnv) {
        this.htmlSchema = htmlSchema;
        this.jobCache = jobCache;
        this.jobs = jobs;
        this.htmlEnv = htmlEnv;
    }

    boolean extract() {
        boolean hasPlaceholders = false;
        Node root = ((Dom)this.htmlEnv.job.getRoot()).getValue();
        this.extractBodyInfo(root, this.htmlEnv);
        HtmlEmbeddedContentFinder finder = new HtmlEmbeddedContentFinder(this.htmlSchema, this.htmlEnv.job.getBaseUri(), this.jobs.getMessageQueue(), this.jobs.getMessageContext());
        for (EmbeddedContent content : finder.findEmbeddedContent(root)) {
            Node src = content.getSource();
            if (content.getSource() instanceof Element) {
                Element el = (Element)content.getSource();
                if (SCRIPT.is(el)) {
                    hasPlaceholders |= this.rewriteScriptEl(root, content);
                    continue;
                }
                if (STYLE.is(el)) {
                    this.rewriteStyleEl(content);
                    continue;
                }
                if (LINK.is(el)) {
                    this.rewriteLinkEl(content);
                    continue;
                }
                throw new SomethingWidgyHappenedError(src.getNodeName());
            }
            if (!BODY_ONLOAD.is((Attr)src)) continue;
            this.moveOnLoadHandlerToEndOfBody(content);
        }
        return hasPlaceholders;
    }

    private boolean rewriteScriptEl(Node root, EmbeddedContent c) {
        Block parsedScriptBody;
        Element scriptEl = (Element)c.getSource();
        Node parent = scriptEl.getParentNode();
        try {
            parsedScriptBody = (Block)c.parse(this.jobs.getPluginMeta().getUriFetcher(), this.jobs.getMessageQueue());
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.jobs.getMessageQueue());
            parent.removeChild(scriptEl);
            return false;
        }
        if (parsedScriptBody == null || parsedScriptBody.children().isEmpty()) {
            parent.removeChild(scriptEl);
            return false;
        }
        Element placeholder = this.placeholderFor(scriptEl, parsedScriptBody);
        if (c.isDeferred()) {
            parent.removeChild(scriptEl);
            root.appendChild(placeholder);
        } else {
            parent.replaceChild(placeholder, scriptEl);
        }
        return true;
    }

    private Element placeholderFor(Node n, Block parsedScriptBody) {
        Element placeholder = n.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "span");
        Nodes.setFilePositionFor(placeholder, Nodes.getFilePositionFor(n));
        URI baseUri = this.htmlEnv.job.getBaseUri();
        String id = "$" + this.jobs.getPluginMeta().generateGuid();
        placeholder.setAttributeNS(Placeholder.ID_ATTR.ns.uri, Placeholder.ID_ATTR.localName, id);
        this.jobs.getJobs().add(new JobEnvelope(id, this.jobCache.forJob(ContentType.JS, parsedScriptBody).asSingleton(), ContentType.JS, false, Job.jsJob(parsedScriptBody, baseUri)));
        return placeholder;
    }

    private void rewriteStyleEl(EmbeddedContent c) {
        Element styleEl = (Element)c.getSource();
        styleEl.getParentNode().removeChild(styleEl);
        this.extractStyles(styleEl, c, null);
    }

    private void rewriteLinkEl(EmbeddedContent c) {
        Element linkEl = (Element)c.getSource();
        linkEl.getParentNode().removeChild(linkEl);
        Attr media = linkEl.getAttributeNodeNS("http://www.w3.org/1999/xhtml", "media");
        this.extractStyles(linkEl, c, media);
    }

    /*
     * WARNING - void declaration
     */
    private void extractStyles(Element el, EmbeddedContent c, Attr media) {
        String[] mediaTypeArr;
        MessageQueue mq = this.jobs.getMessageQueue();
        CssTree.StyleSheet stylesheet = null;
        try {
            stylesheet = (CssTree.StyleSheet)c.parse(this.jobs.getPluginMeta().getUriFetcher(), mq);
        }
        catch (ParseException ex) {
            ex.toMessageQueue(mq);
        }
        if (stylesheet == null || stylesheet.children().isEmpty()) {
            return;
        }
        Set<Object> mediaTypes = Collections.emptySet();
        if (!(media == null || (mediaTypeArr = media.getNodeValue().trim().split("\\s*,\\s*")).length == 1 && "".equals(mediaTypeArr[0]))) {
            void var10_13;
            mediaTypes = Sets.newLinkedHashSet();
            String[] arr$ = mediaTypeArr;
            int len$ = arr$.length;
            boolean bl = false;
            while (var10_13 < len$) {
                String mediaType = arr$[var10_13];
                if (!CssSchema.isMediaType(mediaType)) {
                    this.jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.UNRECOGNIZED_MEDIA_TYPE, Nodes.getFilePositionFor(media), MessagePart.Factory.valueOf(mediaType));
                } else {
                    mediaTypes.add(Name.css(mediaType));
                }
                ++var10_13;
            }
        }
        if (!mediaTypes.isEmpty() && !mediaTypes.contains(Name.css("all"))) {
            final List rules = Lists.newArrayList();
            stylesheet.acceptPreOrder(new Visitor(){

                @Override
                public boolean visit(AncestorChain<?> ancestors) {
                    CssTree node = (CssTree)ancestors.node;
                    if (node instanceof CssTree.StyleSheet) {
                        return true;
                    }
                    if (node instanceof CssTree.RuleSet) {
                        rules.add((CssTree.RuleSet)node);
                        ((MutableParseTreeNode)ancestors.parent.node).removeChild(node);
                    }
                    return false;
                }
            }, null);
            if (!rules.isEmpty()) {
                List<CssTree.Medium> mediaChildren = Lists.newArrayList();
                for (Name name : mediaTypes) {
                    mediaChildren.add(new CssTree.Medium(Nodes.getFilePositionFor(media), name));
                }
                mediaChildren.addAll(rules);
                CssTree.Media mediaBlock = new CssTree.Media(Nodes.getFilePositionFor(el), mediaChildren);
                stylesheet.appendChild(mediaBlock);
            }
        }
        URI baseUri = c.getBaseUri();
        this.jobs.getJobs().add(this.jobs.getJobs().indexOf(this.htmlEnv), new JobEnvelope(null, this.jobCache.forJob(ContentType.CSS, stylesheet).asSingleton(), ContentType.CSS, false, Job.cssJob(stylesheet, baseUri)));
    }

    private void moveOnLoadHandlerToEndOfBody(EmbeddedContent c) {
        Block handler;
        Attr onload = (Attr)c.getSource();
        Element body = onload.getOwnerElement();
        body.removeAttributeNode(onload);
        MessageQueue mq = this.jobs.getMessageQueue();
        try {
            handler = (Block)c.parse(this.jobs.getPluginMeta().getUriFetcher(), mq);
        }
        catch (ParseException ex) {
            ex.toMessageQueue(mq);
            return;
        }
        if (handler != null && !handler.children().isEmpty()) {
            Element placeholder = this.placeholderFor(onload, handler);
            body.appendChild(placeholder);
        }
    }

    private void extractBodyInfo(Node node, JobEnvelope source) {
        switch (node.getNodeType()) {
            case 11: {
                for (Node node2 : Nodes.childrenOf(node)) {
                    this.extractBodyInfo(node2, source);
                }
                break;
            }
            case 1: {
                Attr classAttr;
                Element el = (Element)node;
                ElKey elKey = ElKey.forElement(el);
                if (HTML.equals(elKey)) {
                    for (Node node3 : Nodes.childrenOf(node)) {
                        this.extractBodyInfo(node3, source);
                    }
                    break;
                }
                if (!BODY.equals(elKey) || (classAttr = el.getAttributeNodeNS("http://www.w3.org/1999/xhtml", HtmlExtractor.BODY_CLASS.localName)) == null) break;
                el.removeAttributeNode(classAttr);
                String string = classAttr.getValue().trim();
                if ("".equals(string)) break;
                WhiteList wl = WhiteList.Factory.empty();
                HtmlAttributeRewriter rw = new HtmlAttributeRewriter(this.jobs.getPluginMeta(), new CssSchema(wl, wl), this.htmlSchema, Maps.<Attr, EmbeddedContent>newHashMap(), this.jobs.getMessageQueue());
                HtmlAttributeRewriter.SanitizedAttr sanitized = rw.sanitizeStringValue(HtmlAttributeRewriter.fromAttr(classAttr, this.htmlSchema.lookupAttribute(BODY_CLASS), source));
                if (!sanitized.isSafe) break;
                FilePosition pos = Nodes.getFilePositionForValue(classAttr);
                Expression e = sanitized.result;
                if (e == null) {
                    e = StringLiteral.valueOf(pos, string);
                }
                ExpressionStmt s = new ExpressionStmt((Expression)QuasiBuilder.substV("IMPORTS___.htmlEmitter___    ./*@synthetic*/addBodyClasses(@idents);", "idents", e));
                this.jobs.getJobs().add(new JobEnvelope(null, this.htmlEnv.cacheKeys, ContentType.JS, false, Job.jsJob(s, this.htmlEnv.job.getBaseUri())));
            }
        }
    }
}

