/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.plugin.ExpressionSanitizerCaja;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import com.google.caja.util.Maps;
import com.google.caja.util.Pipeline;
import java.net.URI;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidateJavascriptStage
implements Pipeline.Stage<Jobs> {
    private final ModuleManager mgr;

    public ValidateJavascriptStage(ModuleManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public boolean apply(Jobs jobs) {
        Map<String, JobCache.Keys> keys = Maps.newHashMap();
        ListIterator<JobEnvelope> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            ArrayConstructor deps;
            Statement s;
            Job job;
            JobEnvelope env = it.next();
            if (env.fromCache || (job = env.job).getType() != ContentType.JS) continue;
            URI baseUri = job.getBaseUri();
            ParseTreeNode result = new ExpressionSanitizerCaja(this.mgr, baseUri).sanitize(ValidateJavascriptStage.uncajoledModule(s = (Statement)job.getRoot()), jobs.getPluginMeta().getEnableES53());
            if (!(result instanceof CajoledModule)) {
                it.remove();
                continue;
            }
            CajoledModule validated = (CajoledModule)result;
            it.set(env.withJob(Job.cajoledJob(validated)));
            if (!env.cacheKeys.iterator().hasNext() || (deps = validated.getInlinedModules()) == null) continue;
            for (Expression expression : deps.children()) {
                String moduleUri = ((StringLiteral)expression).getUnquotedValue();
                JobCache.Keys forUri = (JobCache.Keys)keys.get(moduleUri);
                forUri = forUri == null ? env.cacheKeys : forUri.union(env.cacheKeys);
                keys.put(moduleUri, env.cacheKeys);
            }
        }
        for (CajoledModule module : this.mgr.getModuleMap()) {
            String src = module.getSrc();
            JobCache.Keys keysForModule = (JobCache.Keys)keys.get(src);
            if (keysForModule == null) {
                keysForModule = JobCache.none();
            }
            jobs.getJobs().add(new JobEnvelope(null, keysForModule, ContentType.JS, false, Job.cajoledJob(module)));
        }
        return jobs.hasNoFatalErrors();
    }

    private static UncajoledModule uncajoledModule(ParseTreeNode node) {
        Block body;
        if (node instanceof Block) {
            body = (Block)node;
        } else {
            if (node instanceof Expression) {
                node = new ExpressionStmt((Expression)node);
            }
            body = new Block(node.getFilePosition(), Collections.singletonList((Statement)node));
        }
        return new UncajoledModule(body);
    }
}

