/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.templates.IhtmlL10NContext;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.IhtmlSanityChecker;
import com.google.caja.plugin.templates.LocalizedHtml;
import com.google.caja.plugin.templates.Localizer;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.util.CajaTestCase;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocalizerTest
extends CajaTestCase {
    private Element ihtmlRoot;
    private IhtmlL10NContext messageBundle;

    public void setUp() throws Exception {
        super.setUp();
        this.ihtmlRoot = this.xml(this.fromString("<ihtml:template name='testTemplate' formals='x'>\n  Hello, World!\n\n  <ihtml:message name='m1'>\n  We come in\n  <ihtml:ph name='declaration'/>\n    <ihtml:dynamic expr='peaceOrWar()'    /><ihtml:eph/>.\n  </ihtml:message>\n\n  <ihtml:message name='m2'>\n  Take me to your <ihtml:ph name='potentate'/>LEADER<ihtml:eph/>.\n  </ihtml:message>\n\n  <ihtml:message name='m3'>\n  Do you have any more of those Earth-style\n  <ihtml:ph name='flavor'/>cheesy<ihtml:eph/>\n  <ihtml:ph name='snackFood'/>poofs<ihtml:eph/>?\n  </ihtml:message>\n\n  <ihtml:message name='m4'>\n  <ihtml:ph name='start1'/><a href='foo'><ihtml:eph/>\n  Link 1\n  <ihtml:ph name='end1'/></a><ihtml:eph/>,\n  <ihtml:ph name='start2'/><a href='bar'><ihtml:eph/>\n  Link 2\n  <ihtml:ph name='end2'/></a><ihtml:eph/>\n  </ihtml:message>\n</ihtml:template>"));
        LinkedHashMap<String, LocalizedHtml> messages = new LinkedHashMap<String, LocalizedHtml>();
        messages.put("m2", new LocalizedHtml("m2", "akeTay emay otay ouryay <ihtml:ph name='potentate'/>."));
        messages.put("m3", new LocalizedHtml("m3", "ore-May <ihtml:ph name='snackFood'/> and-ay ake-may em-thay <ihtml:ph name='flavor'/>, ease-play!"));
        messages.put("m4", new LocalizedHtml("m4", "<ihtml:ph name='start2'/>inkLay2<ihtml:ph name='end2'/> ommakay <ihtml:ph name='start1'/>inkLay1<ihtml:ph name='end1'/>"));
        this.messageBundle = new IhtmlL10NContext(new Locale("la", "PI"), messages);
    }

    public final void testLocalize() {
        new IhtmlSanityChecker(this.mq).check(this.ihtmlRoot);
        this.assertNoErrors();
        Localizer localizer = new Localizer(this.mq);
        localizer.localize(this.ihtmlRoot, this.messageBundle);
        LocalizerTest.assertEquals((String)"<ihtml:template formals=\"x\" name=\"testTemplate\">\n  Hello, World!\n  We come in\n    <ihtml:dynamic expr=\"peaceOrWar()\" />.\n  akeTay emay otay ouryay LEADER.\n  ore-May poofs and-ay ake-may em-thay cheesy, ease-play!\n  <a href=\"bar\">inkLay2</a> ommakay <a href=\"foo\">inkLay1</a>\n</ihtml:template>", (String)Nodes.render((Node)this.ihtmlRoot, MarkupRenderMode.XML).replaceAll("\n[ \n]*\n", "\n"));
        this.assertMessage(true, IhtmlMessageType.UNTRANSLATED_MESSAGE, MessageLevel.WARNING, FilePosition.fromLinePositions(this.is, 4, 3, 8, 19), MessagePart.Factory.valueOf("m1"), MessagePart.Factory.valueOf("la_PI"));
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
    }

    public final void testExtractMessages() {
        Localizer localizer = new Localizer(this.mq);
        IhtmlL10NContext context = localizer.extractMessages(this.ihtmlRoot);
        LocalizerTest.assertEquals((Object)Locale.ENGLISH, (Object)context.getLocale());
        LocalizerTest.assertEquals((String)"\n  We come in\n  <ihtml:ph name=\"declaration\" />.\n  ", (String)context.getMessageByName("m1").getSerializedForm());
        LocalizerTest.assertEquals((String)"\n  Take me to your <ihtml:ph name=\"potentate\" />.\n  ", (String)context.getMessageByName("m2").getSerializedForm());
        LocalizerTest.assertEquals((String)"\n  Do you have any more of those Earth-style\n  <ihtml:ph name=\"flavor\" />\n  <ihtml:ph name=\"snackFood\" />?\n  ", (String)context.getMessageByName("m3").getSerializedForm());
        this.assertNoErrors();
    }

    public final void testExtractMessageErrors() throws Exception {
        Localizer localizer = new Localizer(this.mq);
        IhtmlL10NContext context = localizer.extractMessages(this.xml(this.fromString("<ihtml:template name='howdy' formals='x' xml:lang='es'>\n  <ihtml:message name='foo'>Foo</ihtml:message>\n  <ihtml:message name='bar'>Bar</ihtml:message>\n  <ihtml:message name='baz'>Baz</ihtml:message>\n  <ihtml:message name='baz'>BAZ</ihtml:message>\n</ihtml:template>")));
        LocalizerTest.assertEquals((Object)new Locale("es"), (Object)context.getLocale());
        LocalizerTest.assertEquals((String)"Foo", (String)context.getMessageByName("foo").getSerializedForm());
        LocalizerTest.assertEquals((String)"Bar", (String)context.getMessageByName("bar").getSerializedForm());
        LocalizerTest.assertEquals((String)"Baz", (String)context.getMessageByName("baz").getSerializedForm());
        this.assertMessage(true, IhtmlMessageType.DUPLICATE_MESSAGE, MessageLevel.ERROR, FilePosition.instance(this.is, 5, 203, 3, 45), MessagePart.Factory.valueOf("baz"), FilePosition.instance(this.is, 4, 155, 3, 45));
        this.assertNoErrors();
    }

    public final void testNonSiblingPlaceholders() throws Exception {
        Localizer localizer = new Localizer(this.mq);
        IhtmlL10NContext context = localizer.extractMessages(this.xml(this.fromString("<ihtml:messages><ihtml:message name='notSiblings'><ihtml:ph name='startLink'/><a><ihtml:attribute name=href><ihtml:dynamic expr='href'/></ihtml:attribute><ihtml:eph/>Click<ihtml:ph name='endLink'/></a><ihtml:eph/></ihtml:message></ihtml:messages>")));
        LocalizedHtml msg = context.getMessageByName("notSiblings");
        LocalizerTest.assertEquals((String)Nodes.render((Node)this.xmlFragment(this.fromString("<ihtml:ph name=startLink />Click<ihtml:ph name=endLink />")), MarkupRenderMode.XML), (String)msg.getSerializedForm());
        LocalizerTest.assertEquals((String)Nodes.render((Node)this.xmlFragment(this.fromString("<button onclick='theyClickedMe()' name='click_me' title='click me'>Click</button><br clear='all'/>")), MarkupRenderMode.XML), (String)Nodes.render((Node)msg.substitute(DomParser.makeDocument(null, null), new LocalizedHtml.PlaceholderHandler(){

            @Override
            public Iterator<Token<HtmlTokenType>> substitutePlaceholder(String placeholderName, FilePosition placeholderLoc) {
                String subst;
                if (placeholderName.equals("startLink")) {
                    subst = "<button name=click_me  title='click me'  onclick=theyClickedMe()>";
                } else if (placeholderName.equals("endLink")) {
                    subst = "</button><br clear=\"all\" />";
                } else {
                    throw new IllegalArgumentException();
                }
                final HtmlLexer tokens = new HtmlLexer(CharProducer.Factory.fromString((CharSequence)subst, LocalizerTest.this.is));
                return new Iterator<Token<HtmlTokenType>>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return tokens.hasNext();
                        }
                        catch (ParseException ex) {
                            throw new SomethingWidgyHappenedError(ex);
                        }
                    }

                    @Override
                    public Token<HtmlTokenType> next() {
                        try {
                            return tokens.next();
                        }
                        catch (ParseException ex) {
                            throw new SomethingWidgyHappenedError(ex);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }), MarkupRenderMode.XML));
        this.assertNoErrors();
    }
}

