/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.quasiliteral.InnocentCodeRewriter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.service.AbstractCajolingHandler;
import com.google.caja.service.CajaArguments;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnocentHandler
extends AbstractCajolingHandler {
    public InnocentHandler(BuildInfo buildInfo) {
        super(buildInfo, null, null);
    }

    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, ContentTypeCheck checker) {
        return CajolingService.Transform.INNOCENT.equals((Object)transform) && checker.check("text/javascript", inputContentType);
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, ContentHandlerArgs args, String inputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        Pair<ContentType, String> contentParams = InnocentHandler.getReturnedContentParams(args);
        boolean pretty = "pretty".equals(CajaArguments.RENDERER.get(args));
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8.name());
            this.innocentJs(uri, input.getTextualContent(), writer, (String)contentParams.b, pretty, mq);
            writer.flush();
        }
        catch (IOException e) {
            throw new UnsupportedContentTypeException();
        }
        return Pair.pair(((ContentType)((Object)contentParams.a)).mimeType, Charsets.UTF_8.name());
    }

    private void innocentJs(URI inputUri, CharProducer cp, Appendable output, String jsonpCallback, boolean pretty, MessageQueue mq) throws IOException {
        ParseTreeNode result = null;
        InputSource is = new InputSource(inputUri);
        try {
            JsTokenQueue tq = new JsTokenQueue(new JsLexer(cp), is);
            Block input = new Parser(tq, mq).parse();
            tq.expectEmpty();
            InnocentCodeRewriter rw = new InnocentCodeRewriter(mq, false);
            result = rw.expand(input);
        }
        catch (ParseException e) {
            e.toMessageQueue(mq);
        }
        InnocentHandler.renderAsJSON(null, result, jsonpCallback, mq, output, pretty);
    }
}

