/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.service.CajolingService;
import com.google.caja.service.CajolingServlet;
import com.google.caja.service.TestHttpServletRequest;
import com.google.caja.service.TestHttpServletResponse;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Charsets;
import com.google.caja.util.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class ServiceTestCase
extends CajaTestCase {
    private CajolingServlet servlet;
    private Map<URI, FetchedData> uriContent;

    protected void setUp() throws Exception {
        super.setUp();
        this.servlet = new CajolingServlet(new CajolingService(TestBuildInfo.getInstance(), null, new UriFetcher(){

            public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                FetchedData data = (FetchedData)ServiceTestCase.this.uriContent.get(ref.getUri());
                if (data == null) {
                    throw new UriFetcher.UriFetchException(ref, mimeType);
                }
                return data;
            }
        }));
        this.uriContent = Maps.newHashMap();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected static Object json(String json) {
        return JSONValue.parse((String)json);
    }

    protected void assertMessagesLessSevereThan(JSONArray messages, MessageLevel severity) {
        for (Object m : messages.toArray()) {
            Object level = ((JSONObject)m).get((Object)"level");
            ServiceTestCase.assertTrue(((Long)level < (long)severity.ordinal() ? 1 : 0) != 0);
        }
    }

    protected void registerUri(String uri, String content, String contentType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, Charsets.UTF_8);
            w.write(content);
            ((Writer)w).flush();
        }
        catch (UnsupportedEncodingException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
        this.registerUri(uri, out.toByteArray(), contentType, "UTF-8");
    }

    protected void registerUri(String uri, byte[] content, String contentType, String charset) {
        this.uriContent.put(URI.create(uri), FetchedData.fromBytes(content, contentType, charset, new InputSource(URI.create(uri))));
    }

    protected Object requestGet(String queryString) throws Exception {
        TestHttpServletRequest req = new TestHttpServletRequest(queryString);
        TestHttpServletResponse resp = new TestHttpServletResponse();
        this.servlet.doGet(req, resp);
        return resp.getOutputObject();
    }

    protected Object requestPost(String queryString, byte[] content, String contentType, String contentEncoding) throws Exception {
        TestHttpServletRequest req = new TestHttpServletRequest(queryString, content, contentType, contentEncoding);
        TestHttpServletResponse resp = new TestHttpServletResponse();
        this.servlet.doPost(req, resp);
        return resp.getOutputObject();
    }

    protected static String valijaModule(String ... lines) {
        return ServiceTestCase.moduleInternal(true, "___.loadModule(", ")", lines);
    }

    protected static String cajitaModule(String ... lines) {
        return ServiceTestCase.moduleInternal(false, "___.loadModule(", ")", lines);
    }

    protected static String valijaModuleWithCallback(String callback, String ... lines) {
        return ServiceTestCase.moduleInternal(true, callback + "(___.prepareModule(", "))", lines);
    }

    protected void assertEqualsIgnoreSpace(String expected, String actual) {
        ServiceTestCase.assertEquals((String)expected.replaceAll("\\s", ""), (String)actual.replaceAll("\\s", ""));
    }

    private static String moduleInternal(boolean valija, String modulePrefix, String moduleSuffix, String ... lines) {
        int i;
        String prefix = "{\n  " + modulePrefix + "{\n" + "      'instantiate': function (___, IMPORTS___) {\n";
        String valijaPrefix = "var $v = ___.readImport(IMPORTS___, '$v', {'getOuters': { '()': {} },'initOuter': { '()': {} },'cf': { '()': {} },'ro': { '()': {} }});var moduleResult___,$dis;moduleResult___=___.NO_RESULT;$dis = $v.getOuters();$v.initOuter('onerror');";
        String cajitaPrefix = "        var moduleResult___;\n        moduleResult___ = ___.NO_RESULT;\n";
        String suffix = "return moduleResult___},'cajolerName': 'com.google.caja','cajolerVersion': 'testBuildVersion','cajoledDate': 0}" + moduleSuffix + "}";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        int n = lines.length;
        for (i = 0; i < n && lines[i].contains("___.readImport"); ++i) {
            sb.append("        ").append(lines[i]).append('\n');
        }
        sb.append(valija ? valijaPrefix : cajitaPrefix);
        while (i < n) {
            sb.append("        ").append(lines[i]).append('\n');
            ++i;
        }
        sb.append(suffix);
        return sb.toString();
    }

    private static String normStringSpaces(String s) {
        return s.replaceAll("[ \r\n\t]+", " ").replaceAll("^ | $|(?<=\\W) | (?=\\W)", "");
    }

    protected static void assertContainsIgnoreSpace(String full, String substring) {
        ServiceTestCase.assertTrue((String)("Substring <" + substring + "> not part of <" + full + ">"), (boolean)ServiceTestCase.normStringSpaces(full).contains(ServiceTestCase.normStringSpaces(substring)));
    }

    protected static void assertSubstringsInJson(String emitted, String jsonProperty, String ... expectedSubstrings) throws Exception {
        ServiceTestCase.assertNotNull((Object)emitted);
        JSONObject json = (JSONObject)ServiceTestCase.json(emitted);
        ServiceTestCase.assertNotNull((Object)json);
        ServiceTestCase.assertTrue((boolean)json.containsKey((Object)jsonProperty));
        String value = (String)json.get((Object)jsonProperty);
        for (String s : expectedSubstrings) {
            ServiceTestCase.assertContainsIgnoreSpace(value, s);
        }
    }

    protected static void assertSubstringsInJsonp(String emitted, String jsonProperty, String ... expectedSubstrings) throws Exception {
        Pattern p = Pattern.compile("^[a-zA-Z_]+\\((\\{.*\\})\\)$");
        Matcher m = p.matcher(emitted);
        ServiceTestCase.assertTrue((boolean)m.matches());
        ServiceTestCase.assertSubstringsInJson(m.group(1), jsonProperty, expectedSubstrings);
    }

    protected static void assertCallbackInJsonp(String emitted, String jsonpCallback) throws Exception {
        Pattern p = Pattern.compile("^" + jsonpCallback + "\\((\\{.*\\})\\)$");
        Matcher m = p.matcher(emitted);
        ServiceTestCase.assertTrue((boolean)m.matches());
    }
}

