/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.note;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.note.EditorImageActions;

@Name(value="editorImageActions")
@Scope(value=ScopeType.CONVERSATION)
public class EditorImageActionsBean
extends InputController
implements EditorImageActions,
Serializable {
    private static final String SEARCH_QUERY = "SELECT * FROM Document WHERE %s";
    private static final String FILES_SCHEMA = "files";
    private static final List<Map<String, String>> SIZES = new ArrayList<Map<String, String>>();
    private static final long serialVersionUID = 8716548847393060676L;
    private static final Log log;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @RequestParameter
    private String selectedTab;
    private String oldSelectedTab;
    private InputStream uploadedImage;
    private String uploadedImageName;
    private String imageUrl;
    private boolean isImageUploaded = false;
    private List<DocumentModel> resultDocuments;
    private boolean hasSearchResults = false;
    private String searchKeywords;
    private String selectedSize = "Original";

    @Override
    public String getSelectedTab() {
        if (this.selectedTab != null) {
            this.oldSelectedTab = this.selectedTab;
        }
        return this.oldSelectedTab;
    }

    @Override
    public String getUrlForImage() {
        this.isImageUploaded = false;
        return this.imageUrl;
    }

    @Override
    public boolean getIsImageUploaded() {
        return this.isImageUploaded;
    }

    @Override
    public void setUploadedImage(InputStream uploadedImage) {
        this.uploadedImage = uploadedImage;
    }

    @Override
    public InputStream getUploadedImage() {
        return this.uploadedImage;
    }

    @Override
    public String getUploadedImageName() {
        return this.uploadedImageName;
    }

    @Override
    public void setUploadedImageName(String uploadedImageName) {
        this.uploadedImageName = uploadedImageName;
    }

    @Override
    public String uploadImage() throws ClientException {
        if (this.uploadedImage == null || this.uploadedImageName == null) {
            return "";
        }
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        List filesList = (List)doc.getProperty(FILES_SCHEMA, FILES_SCHEMA);
        int fileIndex = filesList == null ? 0 : filesList.size();
        HashMap<String, String> props = new HashMap<String, String>();
        this.uploadedImageName = FileUtils.getCleanFileName((String)this.uploadedImageName);
        props.put("filename", this.uploadedImageName);
        props.put("file", (String)FileUtils.createSerializableBlob((InputStream)this.uploadedImage, (String)this.uploadedImageName, null));
        ListDiff listDiff = new ListDiff();
        listDiff.add(props);
        doc.setProperty(FILES_SCHEMA, FILES_SCHEMA, (Object)listDiff);
        this.documentManager.saveDocument(doc);
        this.documentManager.save();
        this.imageUrl = DocumentModelFunctions.complexFileUrl((String)"downloadFile", (DocumentModel)doc, (int)fileIndex, (String)this.uploadedImageName);
        this.isImageUploaded = true;
        return "editor_image_upload";
    }

    @Override
    public boolean getInCreationMode() {
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        if (doc.getId() == null) {
            return true;
        }
        return !doc.hasSchema(FILES_SCHEMA);
    }

    @Override
    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    @Override
    public List<DocumentModel> getSearchImageResults() {
        return this.resultDocuments;
    }

    @Override
    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    @Override
    public String searchImages() throws ClientException {
        log.debug((Object)("Entering searchDocuments with keywords: " + this.searchKeywords));
        this.resultDocuments = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (this.searchKeywords != null) {
            this.searchKeywords = this.searchKeywords.trim();
            if (this.searchKeywords.length() > 0 && !this.searchKeywords.equals("*")) {
                constraints.add(String.format("ecm:fulltext LIKE '%s'", this.searchKeywords));
            }
        }
        constraints.add("ecm:primaryType = 'Picture'");
        String query = String.format(SEARCH_QUERY, StringUtils.join(constraints, (String)" AND "));
        this.resultDocuments = this.documentManager.query(query, 100);
        this.hasSearchResults = !this.resultDocuments.isEmpty();
        log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        return "editor_image_upload";
    }

    @Override
    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    @Override
    public List<Map<String, String>> getSizes() {
        return SIZES;
    }

    @Override
    public String getSelectedSize() {
        return this.selectedSize;
    }

    @Override
    public void setSelectedSize(String selectedSize) {
        this.selectedSize = selectedSize;
    }

    @Override
    public String getImageProperty() {
        return this.selectedSize + ":content";
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("label", "label.imageUpload.originalSize");
        m.put("value", "Original");
        SIZES.add(m);
        m = new HashMap();
        m.put("label", "label.imageUpload.mediumSize");
        m.put("value", "Medium");
        SIZES.add(m);
        m = new HashMap();
        m.put("label", "label.imageUpload.thumbnailSize");
        m.put("value", "Thumbnail");
        SIZES.add(m);
        log = LogFactory.getLog(EditorImageActionsBean.class);
    }
}

