/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.consumers;

import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class NuxeoOAuthConsumer
extends OAuthConsumer {
    private static final long serialVersionUID = 1L;
    public static final String ALLOW_SIGNEDFETCH = "allowSignedFetch";
    public static final String SIGNEDFETCH_NONE = "none";
    public static final String SIGNEDFETCH_OPENSOCIAL_VIEWER = "opensocial:viewer";
    public static final String SIGNEDFETCH_OPENSOCIAL_OWNER = "opensocial:owner";
    public static final String SIGNEDFETCH_DEDICATED_USER = "nuxeo:user";
    protected String publicKey = null;
    protected String description = null;
    protected String signedFetchSupport = "none";
    protected String dedicatedLogin = null;
    protected boolean enabled = true;
    protected boolean allowBypassVerifier = false;
    public static final String SCHEMA = "oauthConsumer";
    protected static final Log log = LogFactory.getLog(NuxeoOAuthConsumer.class);

    public static NuxeoOAuthConsumer createFromDirectoryEntry(DocumentModel entry, String keyType) throws ClientException {
        Long allowBypassVerifierFlag;
        String callbackURL = (String)entry.getProperty(SCHEMA, "callbackURL");
        String consumerKey = (String)entry.getProperty(SCHEMA, "consumerKey");
        String consumerSecret = (String)entry.getProperty(SCHEMA, "consumerSecret");
        String rsaKey = (String)entry.getProperty(SCHEMA, "publicKey");
        NuxeoOAuthConsumer consumer = new NuxeoOAuthConsumer(callbackURL, consumerKey, consumerSecret, null);
        if ("RSA-SHA1".equals(keyType) && rsaKey != null) {
            if (rsaKey.contains("-----BEGIN PUBLIC KEY-----")) {
                consumer.setProperty("RSA-SHA1.PublicKey", rsaKey);
            } else {
                consumer.setProperty("RSA-SHA1.X509Certificate", rsaKey);
            }
        }
        consumer.publicKey = rsaKey;
        consumer.description = (String)entry.getProperty(SCHEMA, "description");
        consumer.signedFetchSupport = (String)entry.getProperty(SCHEMA, "signedFetchSupport");
        consumer.dedicatedLogin = (String)entry.getProperty(SCHEMA, "dedicatedLogin");
        Long enabledFlag = (Long)entry.getProperty(SCHEMA, "enabled");
        if (enabledFlag == 0L) {
            consumer.enabled = false;
        }
        if ((allowBypassVerifierFlag = (Long)entry.getProperty(SCHEMA, "allowBypassVerifier")) == 1L) {
            consumer.allowBypassVerifier = true;
        }
        return consumer;
    }

    public NuxeoOAuthConsumer(String callbackURL, String consumerKey, String consumerSecret, OAuthServiceProvider serviceProvider) {
        super(callbackURL, consumerKey, consumerSecret, serviceProvider);
    }

    protected DocumentModel asDocumentModel(DocumentModel entry) throws ClientException {
        entry.setProperty(SCHEMA, "callbackURL", (Object)this.callbackURL);
        entry.setProperty(SCHEMA, "consumerKey", (Object)this.consumerKey);
        entry.setProperty(SCHEMA, "consumerSecret", (Object)this.consumerSecret);
        entry.setProperty(SCHEMA, "publicKey", (Object)this.publicKey);
        entry.setProperty(SCHEMA, "description", (Object)this.description);
        entry.setProperty(SCHEMA, "signedFetchSupport", (Object)this.signedFetchSupport);
        entry.setProperty(SCHEMA, "dedicatedLogin", (Object)this.dedicatedLogin);
        if (this.enabled) {
            entry.setProperty(SCHEMA, "enabled", (Object)1);
        } else {
            entry.setProperty(SCHEMA, "enabled", (Object)0);
        }
        if (this.allowBypassVerifier) {
            entry.setProperty(SCHEMA, "allowBypassVerifier", (Object)1);
        } else {
            entry.setProperty(SCHEMA, "allowBypassVerifier", (Object)0);
        }
        return entry;
    }

    public String getCallbackURL() {
        return this.callbackURL;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean allowSignedFetch() {
        if (this.signedFetchSupport == null || SIGNEDFETCH_NONE.equals(this.signedFetchSupport)) {
            return false;
        }
        return !SIGNEDFETCH_DEDICATED_USER.equals(this.signedFetchSupport) || this.dedicatedLogin != null;
    }

    public String getSignedFetchUser() {
        if (!this.allowSignedFetch()) {
            return null;
        }
        if (this.signedFetchSupport.startsWith(SIGNEDFETCH_DEDICATED_USER)) {
            return this.dedicatedLogin;
        }
        return this.signedFetchSupport;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSecret(String type) {
        if (type == null || "HMAC-SHA1".equals(type)) {
            return this.consumerSecret;
        }
        if ("RSA-SHA1".equals(type)) {
            return "";
        }
        log.error((Object)("Unknonw type of key :" + type));
        return null;
    }

    public boolean allowBypassVerifier() {
        return this.allowBypassVerifier;
    }
}

