/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.providers;

import net.oauth.OAuthServiceProvider;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class NuxeoOAuthServiceProvider
extends OAuthServiceProvider {
    private static final long serialVersionUID = 441784782690901079L;
    public static final String SCHEMA = "oauthServiceProvider";
    protected String gadgetUrl;
    protected String serviceName;
    protected String keyType;
    protected String consumerKey;
    protected String consumerSecret;
    protected String publicKey;
    protected String description;
    protected boolean enabled = true;
    protected boolean readOnly = false;
    protected Long id;

    public NuxeoOAuthServiceProvider(String requestTokenURL, String userAuthorizationURL, String accessTokenURL) {
        super(requestTokenURL, userAuthorizationURL, accessTokenURL);
    }

    public NuxeoOAuthServiceProvider(Long id, String gadgetUrl, String serviceName, String consumerKey, String consumerSecret, String publicKey) {
        super(null, null, null);
        this.id = id;
        this.gadgetUrl = gadgetUrl;
        this.serviceName = serviceName;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.publicKey = publicKey;
        this.readOnly = true;
    }

    public static NuxeoOAuthServiceProvider createFromDirectoryEntry(DocumentModel entry) throws ClientException {
        String requestTokenURL = (String)entry.getProperty(SCHEMA, "requestTokenURL");
        String userAuthorizationURL = (String)entry.getProperty(SCHEMA, "userAuthorizationURL");
        String accessTokenURL = (String)entry.getProperty(SCHEMA, "accessTokenURL");
        NuxeoOAuthServiceProvider provider = new NuxeoOAuthServiceProvider(requestTokenURL, userAuthorizationURL, accessTokenURL);
        provider.consumerKey = (String)entry.getProperty(SCHEMA, "consumerKey");
        provider.consumerSecret = (String)entry.getProperty(SCHEMA, "consumerSecret");
        provider.gadgetUrl = (String)entry.getProperty(SCHEMA, "gadgetUrl");
        provider.id = (Long)entry.getProperty(SCHEMA, "id");
        provider.keyType = (String)entry.getProperty(SCHEMA, "keyType");
        provider.publicKey = (String)entry.getProperty(SCHEMA, "publicKey");
        provider.serviceName = (String)entry.getProperty(SCHEMA, "serviceName");
        Long enabledFlag = (Long)entry.getProperty(SCHEMA, "enabled");
        if (enabledFlag == 0L) {
            provider.enabled = false;
        }
        return provider;
    }

    protected DocumentModel asDocumentModel(DocumentModel entry) throws ClientException {
        entry.setProperty(SCHEMA, "gadgetUrl", (Object)this.gadgetUrl);
        entry.setProperty(SCHEMA, "serviceName", (Object)this.serviceName);
        entry.setProperty(SCHEMA, "keyType", (Object)this.keyType);
        entry.setProperty(SCHEMA, "consumerKey", (Object)this.consumerKey);
        entry.setProperty(SCHEMA, "consumerSecret", (Object)this.consumerSecret);
        entry.setProperty(SCHEMA, "publicKey", (Object)this.publicKey);
        entry.setProperty(SCHEMA, "requestTokenURL", (Object)this.requestTokenURL);
        entry.setProperty(SCHEMA, "accessTokenURL", (Object)this.accessTokenURL);
        entry.setProperty(SCHEMA, "userAuthorizationURL", (Object)this.userAuthorizationURL);
        if (this.enabled) {
            entry.setProperty(SCHEMA, "enabled", (Object)1);
        } else {
            entry.setProperty(SCHEMA, "enabled", (Object)0);
        }
        return entry;
    }

    public String getGadgetUrl() {
        return this.gadgetUrl;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public Long getId() {
        return this.id;
    }

    public String getRequestTokenUR() {
        return this.requestTokenURL;
    }

    public String getUserAuthorizationURL() {
        return this.userAuthorizationURL;
    }

    public String getAccessTokenURL() {
        return this.accessTokenURL;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

