/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.oauth;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.Principal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthValidator;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.oauth.consumers.NuxeoOAuthConsumer;
import org.nuxeo.ecm.platform.oauth.consumers.OAuthConsumerRegistry;
import org.nuxeo.ecm.platform.oauth.keys.OAuthServerKeyManager;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthTokenStore;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoSecuredRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthPreFilter;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class NuxeoOAuthFilter
implements NuxeoAuthPreFilter {
    protected static Log log = LogFactory.getLog(NuxeoOAuthFilter.class);
    protected static OAuthValidator validator;
    protected static OAuthConsumerRegistry consumerRegistry;

    protected OAuthValidator getValidator() {
        if (validator == null) {
            validator = new SimpleOAuthValidator();
        }
        return validator;
    }

    protected OAuthConsumerRegistry getOAuthConsumerRegistry() {
        if (consumerRegistry == null) {
            consumerRegistry = (OAuthConsumerRegistry)Framework.getLocalService(OAuthConsumerRegistry.class);
        }
        return consumerRegistry;
    }

    protected OAuthTokenStore getOAuthTokenStore() {
        return (OAuthTokenStore)Framework.getLocalService(OAuthTokenStore.class);
    }

    protected boolean isOAuthSignedRequest(HttpServletRequest httpRequest) {
        String authHeader = httpRequest.getHeader("Authorization");
        if (authHeader != null && authHeader.contains("OAuth")) {
            return true;
        }
        if ("GET".equals(httpRequest.getMethod()) && httpRequest.getParameter("oauth_signature") != null) {
            return true;
        }
        return "POST".equals(httpRequest.getMethod()) && "application/x-www-form-urlencoded".equals(httpRequest.getContentType()) && httpRequest.getParameter("oauth_signature") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String uri = httpRequest.getRequestURI();
            if (uri.contains("/oauth/")) {
                String call = uri.split("/oauth/")[1];
                if (call.equals("authorize")) {
                    this.processAuthorize(httpRequest, httpResponse);
                } else if (call.equals("request-token")) {
                    this.processRequestToken(httpRequest, httpResponse);
                } else if (call.equals("access-token")) {
                    this.processAccessToken(httpRequest, httpResponse);
                } else {
                    httpResponse.sendError(405, "OAuth call not supported");
                }
                return;
            }
            if (this.isOAuthSignedRequest(httpRequest)) {
                LoginContext loginContext = this.processSignedRequest(httpRequest, httpResponse);
                if (loginContext != null) {
                    Principal principal = (Principal)loginContext.getSubject().getPrincipals().toArray()[0];
                    try {
                        chain.doFilter((ServletRequest)new NuxeoSecuredRequestWrapper(httpRequest, principal), response);
                    }
                    finally {
                        try {
                            loginContext.logout();
                        }
                        catch (LoginException e) {
                            log.warn((Object)"Error when loging out", (Throwable)e);
                        }
                    }
                }
                if (!httpResponse.isCommitted()) {
                    httpResponse.sendError(403);
                }
                return;
            }
            chain.doFilter(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void processAuthorize(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String token = httpRequest.getParameter("oauth_token");
        if (httpRequest.getMethod().equals("GET")) {
            log.info((Object)"OAuth authorize : from end user ");
            String loginUrl = VirtualHostHelper.getBaseURL((ServletRequest)httpRequest);
            httpRequest.getSession(true).setAttribute("OAUTH-INFO", (Object)this.getOAuthTokenStore().getRequestToken(token));
            String redirectUrl = "oauthGrant.jsp?oauth_token=" + token;
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
            loginUrl = loginUrl + "login.jsp?requestedUrl=" + redirectUrl;
            httpResponse.sendRedirect(loginUrl);
        } else {
            log.info((Object)"OAuth authorize validate ");
            String nuxeo_login = httpRequest.getParameter("nuxeo_login");
            String duration = httpRequest.getParameter("duration");
            OAuthToken rToken = this.getOAuthTokenStore().addVerifierToRequestToken(token, Long.parseLong(duration));
            rToken.setNuxeoLogin(nuxeo_login);
            String cbUrl = rToken.getCallbackUrl();
            if (cbUrl == null) {
                String consumerKey = rToken.getConsumerKey();
                NuxeoOAuthConsumer consumer = this.getOAuthConsumerRegistry().getConsumer(consumerKey);
                if (consumer != null) {
                    cbUrl = consumer.getCallbackURL();
                }
                if (cbUrl == null) {
                    cbUrl = "http://oauth.gmodules.com/gadgets/oauthcallback";
                }
            }
            StringBuffer sb = new StringBuffer(cbUrl);
            sb.append("?");
            sb.append("oauth_token");
            sb.append("=");
            sb.append(rToken.getToken());
            sb.append("&");
            sb.append("oauth_verifier");
            sb.append("=");
            sb.append(rToken.getVerifier());
            String targetUrl = sb.toString();
            log.info((Object)("redirecting user after successful grant " + sb.toString()));
            httpResponse.sendRedirect(targetUrl);
        }
    }

    protected void processRequestToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        String consumerKey = message.getConsumerKey();
        NuxeoOAuthConsumer consumer = this.getOAuthConsumerRegistry().getConsumer(consumerKey, message.getSignatureMethod());
        if (consumer == null) {
            log.error((Object)("Consumer " + consumerKey + " is not registred"));
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("consumer_key_unknown");
            httpResponse.sendError(errCode, "Unknown consumer key");
            return;
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        OAuthValidator validator = this.getValidator();
        try {
            validator.validateMessage(message, accessor);
        }
        catch (Exception e) {
            log.error((Object)"Error while validating OAuth signature", (Throwable)e);
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("signature_invalid");
            httpResponse.sendError(errCode, "Can not validate signature");
            return;
        }
        log.info((Object)"OAuth request-token : generate a tmp token");
        String callBack = message.getParameter("oauth_callback");
        OAuthToken rToken = this.getOAuthTokenStore().createRequestToken(consumerKey, callBack);
        httpResponse.setContentType("application/x-www-form-urlencoded");
        httpResponse.setStatus(200);
        StringBuffer sb = new StringBuffer();
        sb.append("oauth_token");
        sb.append("=");
        sb.append(rToken.getToken());
        sb.append("&");
        sb.append("oauth_token_secret");
        sb.append("=");
        sb.append(rToken.getTokenSecret());
        sb.append("&oauth_callback_confirmed=true");
        log.info((Object)("returning : " + sb.toString()));
        httpResponse.getWriter().write(sb.toString());
    }

    protected void processAccessToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        String consumerKey = message.getConsumerKey();
        String token = message.getToken();
        NuxeoOAuthConsumer consumer = this.getOAuthConsumerRegistry().getConsumer(consumerKey, message.getSignatureMethod());
        if (consumer == null) {
            log.error((Object)("Consumer " + consumerKey + " is not registred"));
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("consumer_key_unknown");
            httpResponse.sendError(errCode, "Unknown consumer key");
            return;
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        OAuthToken rToken = this.getOAuthTokenStore().getRequestToken(token);
        accessor.requestToken = rToken.getToken();
        accessor.tokenSecret = rToken.getTokenSecret();
        OAuthValidator validator = this.getValidator();
        try {
            validator.validateMessage(message, accessor);
        }
        catch (Exception e) {
            log.error((Object)"Error while validating OAuth signature", (Throwable)e);
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("signature_invalid");
            httpResponse.sendError(errCode, "Can not validate signature");
            return;
        }
        log.info((Object)"OAuth access-token : generate a real token");
        String verif = message.getParameter("oauth_verifier");
        token = message.getParameter("oauth_token");
        log.info((Object)("OAuth verifier = " + verif));
        boolean allowByPassVerifier = false;
        if (verif == null) {
            allowByPassVerifier = consumer.allowBypassVerifier();
        }
        if (!rToken.getVerifier().equals(verif) && !allowByPassVerifier) {
            log.error((Object)"Verifier does not match : can not continue");
            httpResponse.sendError(403, "Verifier is not correct");
            return;
        }
        OAuthToken aToken = this.getOAuthTokenStore().createAccessTokenFromRequestToken(rToken);
        httpResponse.setContentType("application/x-www-form-urlencoded");
        httpResponse.setStatus(200);
        StringBuffer sb = new StringBuffer();
        sb.append("oauth_token");
        sb.append("=");
        sb.append(aToken.getToken());
        sb.append("&");
        sb.append("oauth_token_secret");
        sb.append("=");
        sb.append(aToken.getTokenSecret());
        log.info((Object)("returning : " + sb.toString()));
        httpResponse.getWriter().write(sb.toString());
    }

    protected LoginContext processSignedRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        OAuthServerKeyManager okm;
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        String consumerKey = message.getConsumerKey();
        String signatureMethod = message.getSignatureMethod();
        log.info((Object)("Received OAuth signed request on " + httpRequest.getRequestURI() + " with consumerKey=" + consumerKey + " and signature method " + signatureMethod));
        NuxeoOAuthConsumer consumer = this.getOAuthConsumerRegistry().getConsumer(consumerKey, signatureMethod);
        if (consumer == null && consumerKey != null && consumerKey.equals((okm = (OAuthServerKeyManager)Framework.getLocalService(OAuthServerKeyManager.class)).getInternalKey())) {
            consumer = okm.getInternalConsumer();
        }
        if (consumer == null) {
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("consumer_key_unknown");
            log.error((Object)("Consumer " + consumerKey + " is unknow, can not authenticated"));
            httpResponse.sendError(errCode, "Consumer " + consumerKey + " is not registred");
            return null;
        }
        OAuthAccessor accessor = new OAuthAccessor((OAuthConsumer)consumer);
        OAuthValidator validator = this.getValidator();
        OAuthToken aToken = this.getOAuthTokenStore().getAccessToken(message.getToken());
        String targetLogin = null;
        if (aToken != null) {
            accessor.accessToken = aToken.getToken();
            accessor.tokenSecret = aToken.getTokenSecret();
            targetLogin = aToken.getNuxeoLogin();
        } else {
            if (!consumer.allowSignedFetch()) {
                int errCode = 403;
                httpResponse.sendError(errCode, "Signed fetch is not allowed");
                return null;
            }
            targetLogin = consumer.getSignedFetchUser();
            if ("opensocial:viewer".equals(targetLogin)) {
                targetLogin = message.getParameter("opensocial_viewer_id");
            } else if ("opensocial:owner".equals(targetLogin)) {
                targetLogin = message.getParameter("opensocial_owner_id");
            }
        }
        try {
            validator.validateMessage(message, accessor);
            if (targetLogin != null) {
                LoginContext loginContext = NuxeoAuthenticationFilter.loginAs((String)targetLogin);
                return loginContext;
            }
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("user_refused");
            httpResponse.sendError(errCode, "No configured login information");
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error while validating OAuth signature", (Throwable)e);
            int errCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get("signature_invalid");
            httpResponse.sendError(errCode, "Can not validate signature");
            return null;
        }
    }
}

