/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.virtualnavigation.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class NavTreeService
extends DefaultComponent {
    public static String NAVTREE_EP = "navigationTree";
    protected Map<String, NavTreeDescriptor> registry;

    public List<NavTreeDescriptor> getTreeDescriptors() {
        ArrayList<NavTreeDescriptor> allTrees = new ArrayList<NavTreeDescriptor>();
        allTrees.addAll(this.registry.values());
        List<NavTreeDescriptor> directoryTrees = this.getDirectoryTrees();
        if (directoryTrees != null) {
            allTrees.addAll(directoryTrees);
        }
        Collections.sort(allTrees, NavTreeDescriptorOrderComparator.INSTANCE);
        return allTrees;
    }

    protected synchronized List<NavTreeDescriptor> getDirectoryTrees() {
        DirectoryTreeService directoryTreeService = (DirectoryTreeService)Framework.getRuntime().getComponent(DirectoryTreeService.NAME);
        if (directoryTreeService == null) {
            return null;
        }
        List treeNames = directoryTreeService.getNavigationDirectoryTrees();
        ArrayList<NavTreeDescriptor> trees = new ArrayList<NavTreeDescriptor>();
        for (String dTreeName : treeNames) {
            trees.add(new NavTreeDescriptor(dTreeName, "label." + dTreeName, true));
        }
        return trees;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (NAVTREE_EP.equals(extensionPoint)) {
            NavTreeDescriptor contrib = (NavTreeDescriptor)contribution;
            if (this.registry.containsKey(contrib.getTreeId())) {
                this.registry.remove(contrib.getTreeId());
            }
            if (contrib.isEnabled()) {
                this.registry.put(contrib.getTreeId(), contrib);
            }
        }
    }

    public void activate(ComponentContext context) throws Exception {
        this.registry = new HashMap<String, NavTreeDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.registry = null;
    }

    public static class NavTreeDescriptorOrderComparator
    implements Comparator<NavTreeDescriptor> {
        public static final NavTreeDescriptorOrderComparator INSTANCE = new NavTreeDescriptorOrderComparator();

        @Override
        public int compare(NavTreeDescriptor descriptor1, NavTreeDescriptor descriptor2) {
            return descriptor1.getOrder() - descriptor2.getOrder();
        }
    }
}

