/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Point;
import java.awt.Rectangle;

public class Zoom
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        Point loc = ic.getCursorLoc();
        int x = ic.screenX(loc.x);
        int y = ic.screenY(loc.y);
        if (arg.equals("in")) {
            ic.zoomIn(x, y);
            if (ic.getMagnification() <= 1.0) {
                imp.repaintWindow();
            }
        } else if (arg.equals("out")) {
            ic.zoomOut(x, y);
            if (ic.getMagnification() < 1.0) {
                imp.repaintWindow();
            }
        } else if (arg.equals("orig")) {
            ic.unzoom();
        } else if (arg.equals("100%")) {
            ic.zoom100Percent();
        } else if (arg.equals("to")) {
            this.zoomToSelection(imp, ic);
        } else if (arg.equals("max")) {
            ImageWindow win = imp.getWindow();
            win.setBounds(win.getMaximumBounds());
            win.maximize();
        }
    }

    void zoomToSelection(ImagePlus imp, ImageCanvas ic) {
        Roi roi = imp.getRoi();
        ic.unzoom();
        if (roi == null) {
            return;
        }
        Rectangle w = imp.getWindow().getBounds();
        Rectangle r = roi.getBounds();
        double mag = ic.getMagnification();
        int marginw = (int)((double)w.width - mag * (double)imp.getWidth());
        int marginh = (int)((double)w.height - mag * (double)imp.getHeight());
        int x = r.x + r.width / 2;
        int y = r.y + r.height / 2;
        mag = ImageCanvas.getHigherZoomLevel(mag);
        while ((double)r.width * mag < (double)(w.width - marginw) && (double)r.height * mag < (double)(w.height - marginh)) {
            ic.zoomIn(ic.screenX(x), ic.screenY(y));
            double cmag = ic.getMagnification();
            if (cmag == 32.0) break;
            mag = ImageCanvas.getHigherZoomLevel(cmag);
            w = imp.getWindow().getBounds();
        }
    }
}

