/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.security.Principal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;

public abstract class UnrestrictedSessionRunner {
    protected String originatingUsername;
    protected CoreSession session;
    protected final boolean sessionIsAlreadyUnrestricted;
    protected final String repositoryName;
    public boolean isUnrestricted;

    public UnrestrictedSessionRunner(CoreSession session) {
        this.session = session;
        this.sessionIsAlreadyUnrestricted = this.isUnrestricted(session);
        this.repositoryName = this.sessionIsAlreadyUnrestricted ? null : session.getRepositoryName();
        Principal pal = session.getPrincipal();
        if (pal != null) {
            this.originatingUsername = pal.getName();
        }
    }

    public UnrestrictedSessionRunner(String repositoryName) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
    }

    public UnrestrictedSessionRunner(String repositoryName, String originatingUser) {
        this.session = null;
        this.sessionIsAlreadyUnrestricted = false;
        this.repositoryName = repositoryName;
    }

    public String getOriginatingUsername() {
        return this.originatingUsername;
    }

    public void setOriginatingUsername(String originatingUsername) {
        this.originatingUsername = originatingUsername;
    }

    protected boolean isUnrestricted(CoreSession session) {
        return "system".equals(session.getPrincipal().getName()) || session.getPrincipal() instanceof NuxeoPrincipal && ((NuxeoPrincipal)session.getPrincipal()).isAdministrator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runUnrestricted() throws ClientException {
        this.isUnrestricted = true;
        try {
            LoginContext loginContext;
            if (this.sessionIsAlreadyUnrestricted) {
                this.run();
                return;
            }
            try {
                loginContext = Framework.loginAs((String)this.originatingUsername);
            }
            catch (LoginException e) {
                throw new ClientException(e);
            }
            try {
                CoreSession baseSession = this.session;
                if (baseSession != null && !baseSession.isStateSharedByAllThreadSessions()) {
                    baseSession.save();
                }
                try {
                    NuxeoPrincipal principal;
                    Repository repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(this.repositoryName);
                    if (repository == null) {
                        throw new ClientException("Cannot get repository: " + this.repositoryName);
                    }
                    this.session = repository.open();
                    if (loginContext == null && Framework.isTestModeSet() && (principal = (NuxeoPrincipal)this.session.getPrincipal()).getOriginatingUser() == null) {
                        principal.setOriginatingUser(this.originatingUsername);
                    }
                }
                catch (ClientException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ClientException(e);
                }
                try {
                    this.run();
                    return;
                }
                finally {
                    try {
                        if (!this.session.isStateSharedByAllThreadSessions()) {
                            this.session.save();
                        }
                        Repository.close(this.session);
                    }
                    catch (Exception e) {
                        throw new ClientException(e);
                    }
                    finally {
                        if (baseSession != null && !baseSession.isStateSharedByAllThreadSessions()) {
                            baseSession.save();
                        }
                        this.session = baseSession;
                    }
                }
            }
            finally {
                try {
                    if (loginContext != null) {
                        loginContext.logout();
                    }
                }
                catch (LoginException e) {
                    throw new ClientException(e);
                }
            }
        }
        finally {
            this.isUnrestricted = false;
        }
    }

    public abstract void run() throws ClientException;
}

