/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.util.Locale;
import yarfraw.core.datamodel.AbstractBaseObject;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.ValidationUtils;

public class Link
extends AbstractBaseObject {
    private static final long serialVersionUID = 20070927L;
    private String _href;
    private String _rel;
    private String _type;
    private String _hreflang;
    private String _title;
    private Integer _length;

    public Link() {
    }

    public Link(String href) {
        this._href = href;
    }

    public Link(String href, String rel, String type, String hreflang, String title, Integer length) {
        this._href = href;
        this._rel = rel;
        this._type = type;
        this._hreflang = hreflang;
        this._title = title;
        this._length = length;
    }

    public String getHref() {
        return this._href;
    }

    public Link setHref(String href) {
        this._href = href;
        return this;
    }

    public String getRel() {
        return this._rel;
    }

    public Link setRel(String rel) {
        this._rel = rel;
        return this;
    }

    public String getType() {
        return this._type;
    }

    public Link setType(String type) {
        this._type = type;
        return this;
    }

    public String getHreflang() {
        return this._hreflang;
    }

    public Link setHreflang(String hreflang) {
        this._hreflang = hreflang;
        return this;
    }

    public Link setHreflang(Locale hreflang) {
        this._hreflang = hreflang.getLanguage();
        return this;
    }

    public String getTitle() {
        return this._title;
    }

    public Link setTitle(String title) {
        this._title = title;
        return this;
    }

    public Integer getLength() {
        return this._length;
    }

    public Link setLength(Integer length) {
        this._length = length;
        return this;
    }

    public Link setBase(String base) {
        this._base = base;
        return this;
    }

    public Link setLang(Locale lang) {
        this._lang = lang.getLanguage();
        return this;
    }

    public Link setLang(String lang) {
        this._lang = lang;
        return this;
    }

    public void validate(FeedFormat format) throws ValidationException {
        ValidationUtils.validateNotNull("href is required", this._href);
        ValidationUtils.validateUri("href should be an valid uri", this._href);
    }
}

