/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.osgi.OSGiComponentLoader;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiRuntimeActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(OSGiRuntimeActivator.class);
    private static OSGiRuntimeActivator instance;
    protected OSGiRuntimeService runtime;
    protected OSGiComponentLoader componentLoader;
    protected ServiceReference pkgAdmin;
    protected BundleContext context;

    public static OSGiRuntimeActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        log.info((Object)"Starting Runtime Activator");
        instance = this;
        this.context = context;
        this.pkgAdmin = context.getServiceReference(PackageAdmin.class.getName());
        this.initEnvironment();
        this.runtime = new OSGiRuntimeService(context);
        URL config = context.getBundle().getResource("/OSGI-INF/nuxeo.properties");
        if (config != null) {
            System.setProperty("CONFIG_DIR", config.toExternalForm());
        }
        this.initialize(this.runtime);
        Framework.initialize(this.runtime);
        this.componentLoader = new OSGiComponentLoader(this.runtime);
    }

    public void stop(BundleContext context) throws Exception {
        log.info((Object)"Stopping Runtime Activator");
        instance = null;
        this.pkgAdmin = null;
        this.componentLoader.uninstall();
        this.componentLoader = null;
        Framework.shutdown();
        this.uninitialize(this.runtime);
        this.runtime = null;
        context = null;
    }

    public Bundle getBundle(String name) {
        if (this.pkgAdmin == null) {
            return null;
        }
        PackageAdmin pa = (PackageAdmin)this.context.getService(this.pkgAdmin);
        Bundle[] bundles = pa.getBundles(name, null);
        this.context.ungetService(this.pkgAdmin);
        return bundles[0];
    }

    protected void initEnvironment() throws IOException {
        File configDir;
        File home;
        String homeDir;
        if (Environment.getDefault() == null && (homeDir = System.getProperty("nuxeo.home")) != null) {
            home = new File(homeDir);
            home.mkdirs();
            Environment.setDefault((Environment)new Environment(home));
        }
        if (!(configDir = Environment.getDefault().getConfig()).isDirectory()) {
            home = Environment.getDefault().getHome();
            new File(home, "data").mkdir();
            new File(home, "log").mkdir();
            new File(home, "tmp").mkdir();
            this.tryUnzipConfig(new File(home, "config"));
        }
    }

    protected void tryUnzipConfig(File configDir) throws IOException {
        Bundle bundle = this.context.getBundle();
        if (!configDir.isDirectory()) {
            configDir.mkdir();
            Enumeration urls = bundle.findEntries("config", "*.xml", true);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    this.copyConfigEntry((URL)urls.nextElement(), configDir);
                }
            }
            if ((urls = bundle.findEntries("config", "*.properties", true)) != null) {
                while (urls.hasMoreElements()) {
                    this.copyConfigEntry((URL)urls.nextElement(), configDir);
                }
            }
        }
    }

    private File newConfigFile(File configDir, URL url) {
        String path = url.getPath();
        int i = path.lastIndexOf("/config/");
        if (i == -1) {
            throw new IllegalArgumentException("Excpecting a /config/ path.");
        }
        path = path.substring(i + "/config/".length());
        if (File.separatorChar == '/') {
            return new File(configDir, path);
        }
        String[] ar = StringUtils.split((String)path, (char)'/', (boolean)false);
        if (ar.length == 0) {
            throw new IllegalArgumentException("Invalid config file path: " + path);
        }
        StringBuilder buf = new StringBuilder(ar[0]);
        for (i = 1; i < ar.length; ++i) {
            buf.append(File.separatorChar).append(ar[i]);
        }
        return new File(configDir, buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyConfigEntry(URL url, File configDir) throws IOException {
        InputStream in = url.openStream();
        try {
            File file = this.newConfigFile(configDir, url);
            file.getParentFile().mkdirs();
            FileUtils.copyToFile((InputStream)in, (File)file);
        }
        finally {
            in.close();
        }
    }

    protected void initialize(OSGiRuntimeService runtime) {
    }

    protected void uninitialize(OSGiRuntimeService runtime) {
    }
}

