/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.libraryselector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.ecm.platform.picture.core.MetadataUtils;
import org.nuxeo.ecm.platform.picture.core.MimeUtils;
import org.nuxeo.ecm.platform.picture.core.libraryselector.ImageUtilsDescriptor;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelectorServiceDescriptor;
import org.nuxeo.ecm.platform.picture.core.libraryselector.MetadataUtilsDescriptor;
import org.nuxeo.ecm.platform.picture.core.libraryselector.MimeUtilsDescriptor;
import org.nuxeo.ecm.platform.picture.core.mistral.MistralImageUtils;
import org.nuxeo.ecm.platform.picture.core.mistral.MistralMetadataUtils;
import org.nuxeo.ecm.platform.picture.core.mistral.MistralMimeUtils;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class LibrarySelectorService
extends DefaultComponent
implements LibrarySelector {
    public static final String LIBRARY_SELECTOR = "LibrarySelector";
    private static final Log log = LogFactory.getLog(LibrarySelectorService.class);
    protected static final ImageUtils DEFAULT_IMAGE_UTILS = new MistralImageUtils();
    protected static final MetadataUtils DEFAULT_METADATA_UTILS = new MistralMetadataUtils();
    protected static final MimeUtils DEFAULT_MIME_UTILS = new MistralMimeUtils();
    protected ImageUtils imageUtils;
    protected MetadataUtils metadataUtils;
    protected MimeUtils mimeUtils;

    public void deactivate(ComponentContext context) {
        this.imageUtils = null;
        this.metadataUtils = null;
        this.mimeUtils = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(LIBRARY_SELECTOR)) {
            LibrarySelectorServiceDescriptor libraryDescriptor = (LibrarySelectorServiceDescriptor)contribution;
            this.registerLibrarySelector(libraryDescriptor);
        } else {
            log.error((Object)("Extension point " + extensionPoint + "is unknown"));
        }
    }

    public void registerLibrarySelector(LibrarySelectorServiceDescriptor libraryDescriptor) {
        this.registerImageUtils(libraryDescriptor.getImageUtils());
        this.registerMetadataUtils(libraryDescriptor.getMetadataUtils());
        this.registerMimeUtils(libraryDescriptor.getMimeUtils());
    }

    protected void registerImageUtils(ImageUtilsDescriptor imageUtilsDescriptor) {
        try {
            this.imageUtils = imageUtilsDescriptor.getNewInstance();
        }
        catch (Exception e) {
            this.imageUtils = DEFAULT_IMAGE_UTILS;
        }
        if (!this.imageUtils.isAvailable()) {
            this.imageUtils = DEFAULT_IMAGE_UTILS;
        }
        log.debug((Object)("Using " + this.imageUtils.getClass().getName() + " for ImageUtils."));
    }

    protected void registerMetadataUtils(MetadataUtilsDescriptor metadataUtilsDescriptor) {
        try {
            this.metadataUtils = metadataUtilsDescriptor.getNewInstance();
        }
        catch (Exception e) {
            this.metadataUtils = DEFAULT_METADATA_UTILS;
        }
        log.debug((Object)("Using " + this.metadataUtils.getClass().getName() + " for MetadataUtils."));
    }

    protected void registerMimeUtils(MimeUtilsDescriptor mimeUtilsDescriptor) {
        try {
            this.mimeUtils = mimeUtilsDescriptor.getNewInstance();
        }
        catch (Exception e) {
            this.mimeUtils = DEFAULT_MIME_UTILS;
        }
        log.debug((Object)("Using " + this.mimeUtils.getClass().getName() + " for MimeUtils."));
    }

    @Override
    public ImageUtils getImageUtils() {
        return this.imageUtils;
    }

    @Override
    public MimeUtils getMimeUtils() {
        return this.mimeUtils;
    }

    @Override
    public MetadataUtils getMetadataUtils() {
        return this.metadataUtils;
    }
}

