/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.mistral;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.metadata.EXIFDirectory;
import it.tidalwave.image.op.ReadOp;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.picture.core.MimeUtils;

public class MistralMimeUtils
implements MimeUtils {
    private static final Log log = LogFactory.getLog(MistralMimeUtils.class);
    private static final int BUFFER_LIMIT = 32000000;
    public static final String MIME_IMAGE_JPEG = "image/jpeg";
    public static final String MIME_IMAGE_GIF = "image/gif";
    public static final String MIME_IMAGE_PNG = "image/png";
    public static final String MIME_IMAGE_TIFF = "image/tiff";
    public static final String MIME_IMAGE_BMP = "image/x-ms-bmp";
    public static final String MIME_UNKNOWN = "application/octet-stream";
    private static final Map<String, String> mimeTypes = new HashMap<String, String>();

    @Override
    public String getImageMimeType(InputStream in) {
        return this.getInternalImageMimeType(in);
    }

    @Override
    public String getImageMimeType(File file) {
        return this.getInternalImageMimeType(file);
    }

    public String getInternalImageMimeType(Object source) {
        String type = null;
        try {
            String compression;
            EditableImage image;
            EXIFDirectory exif;
            if (source instanceof InputStream) {
                BufferedInputStream bin;
                if (source instanceof BufferedInputStream) {
                    bin = (BufferedInputStream)source;
                } else {
                    bin = new BufferedInputStream((InputStream)source);
                    source = bin;
                }
                bin.mark(32000000);
            }
            if ((exif = (image = EditableImage.create((ReadOp)new ReadOp(source, ReadOp.Type.METADATA))).getEXIFDirectory()).isCompressionAvailable() && (compression = exif.getCompression().toString().toUpperCase()).contains("JPEG")) {
                type = MIME_IMAGE_JPEG;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Can't instanciate file", (Throwable)e);
            return null;
        }
        if (type == null) {
            type = MIME_UNKNOWN;
        }
        return type;
    }

    static {
        mimeTypes.put("jpg", MIME_IMAGE_JPEG);
        mimeTypes.put("jpeg", MIME_IMAGE_JPEG);
        mimeTypes.put("jpe", MIME_IMAGE_JPEG);
        mimeTypes.put("gif", MIME_IMAGE_GIF);
        mimeTypes.put("png", MIME_IMAGE_PNG);
        mimeTypes.put("tiff", MIME_IMAGE_TIFF);
        mimeTypes.put("tif", MIME_IMAGE_TIFF);
        mimeTypes.put("bmp", MIME_IMAGE_BMP);
    }
}

