/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;

public enum ColumnType {
    VARCHAR,
    CLOB,
    BOOLEAN,
    LONG,
    DOUBLE,
    TIMESTAMP,
    BLOBID,
    NODEID,
    NODEIDFK,
    NODEIDFKNP,
    NODEIDFKMUL,
    NODEIDFKNULL,
    NODEIDPK,
    NODEVAL,
    NODEARRAY,
    SYSNAME,
    SYSNAMEARRAY,
    TINYINT,
    INTEGER,
    FTINDEXED,
    FTSTORED,
    CLUSTERNODE,
    CLUSTERFRAGS;


    public static ColumnType fromFieldType(Type coreType) {
        if (coreType instanceof StringType) {
            return VARCHAR;
        }
        if (coreType instanceof BooleanType) {
            return BOOLEAN;
        }
        if (coreType instanceof LongType) {
            return LONG;
        }
        if (coreType instanceof DoubleType) {
            return DOUBLE;
        }
        if (coreType instanceof DateType) {
            return TIMESTAMP;
        }
        if (coreType instanceof BinaryType) {
            return BLOBID;
        }
        if (coreType instanceof IntegerType) {
            return INTEGER;
        }
        if (coreType instanceof SimpleTypeImpl) {
            return ColumnType.fromFieldType(coreType.getSuperType());
        }
        throw new RuntimeException("Invalid primitive type: " + coreType.getClass().getName());
    }
}

