/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.InvalidationsQueue;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.ACLCollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.ClusterNodeHandler;
import org.nuxeo.ecm.core.storage.sql.jdbc.CollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.ScalarCollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;

public class JDBCRowMapper
extends JDBCConnection
implements RowMapper {
    private ClusterNodeHandler clusterNodeHandler;
    private final InvalidationsQueue queue;

    public JDBCRowMapper(Model model, SQLInfo sqlInfo, XADataSource xadatasource, ClusterNodeHandler clusterNodeHandler) throws StorageException {
        super(model, sqlInfo, xadatasource);
        this.clusterNodeHandler = clusterNodeHandler;
        this.queue = new InvalidationsQueue("cluster");
        if (clusterNodeHandler != null) {
            clusterNodeHandler.propagator.addQueue(this.queue);
        }
    }

    @Override
    public Invalidations.InvalidationsPair receiveInvalidations() throws StorageException {
        Invalidations invalidations = null;
        if (this.clusterNodeHandler != null) {
            this.receiveClusterInvalidations();
            invalidations = this.queue.getInvalidations();
        }
        return invalidations == null ? null : new Invalidations.InvalidationsPair(invalidations, null);
    }

    protected void receiveClusterInvalidations() throws StorageException {
        Invalidations invalidations = this.clusterNodeHandler.receiveClusterInvalidations();
        if (invalidations != null && !invalidations.isEmpty()) {
            this.clusterNodeHandler.propagator.propagateInvalidations(invalidations, null);
        }
    }

    @Override
    public void sendInvalidations(Invalidations invalidations) throws StorageException {
        if (this.clusterNodeHandler != null) {
            this.clusterNodeHandler.sendClusterInvalidations(invalidations);
        }
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.xaresource.rollback(xid);
        }
        catch (XAException e) {
            this.logger.error("XA error on rollback: " + e);
            throw e;
        }
    }

    protected CollectionIO getCollectionIO(String tableName) {
        return tableName.equals("acls") ? ACLCollectionIO.INSTANCE : ScalarCollectionIO.INSTANCE;
    }

    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds) throws StorageException {
        HashMap<String, HashSet<Serializable>> tableIds = new HashMap<String, HashSet<Serializable>>();
        for (RowId rowId : rowIds) {
            HashSet<Serializable> ids = (HashSet<Serializable>)tableIds.get(rowId.tableName);
            if (ids == null) {
                ids = new HashSet<Serializable>();
                tableIds.put(rowId.tableName, ids);
            }
            ids.add(rowId.id);
        }
        ArrayList<RowId> res = new ArrayList<RowId>(rowIds.size());
        for (Map.Entry en : tableIds.entrySet()) {
            String tableName = (String)en.getKey();
            Set ids = (Set)en.getValue();
            List<Row> rows = this.model.isCollectionFragment(tableName) ? this.readCollectionArrays(tableName, ids) : this.readSimpleRows(tableName, ids);
            for (Row row : rows) {
                res.add(row);
                ids.remove(row.id);
            }
            for (Serializable id : ids) {
                res.add(new RowId(tableName, id));
            }
        }
        return res;
    }

    protected List<Row> readSimpleRows(String tableName, Collection<Serializable> ids) throws StorageException {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size());
        Map<String, Serializable> criteriaMap = Collections.singletonMap("id", (Serializable)((Object)ids));
        return this.getSelectRows(tableName, select, criteriaMap, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Row> readCollectionArrays(String tableName, Collection<Serializable> ids) throws StorageException {
        LinkedList<Row> linkedList;
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        String[] stringArray = new String[2];
        stringArray[0] = "id";
        stringArray[1] = "pos";
        String[] orderBys = stringArray;
        String[] stringArray2 = new String[1];
        stringArray2[0] = "pos";
        HashSet<String> skipColumns = new HashSet<String>(Arrays.asList(stringArray2));
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size(), orderBys, skipColumns);
        String sql = select.sql;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, ids);
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            int i = 1;
            for (Serializable id : ids) {
                ps.setObject(i++, id);
            }
            ResultSet rs = ps.executeQuery();
            CollectionIO io = this.getCollectionIO(tableName);
            PropertyType ftype = this.model.getCollectionFragmentType(tableName);
            PropertyType type = ftype.getArrayBaseType();
            Serializable curId = null;
            ArrayList<Serializable> list = null;
            Serializable[] returnId = new Serializable[1];
            int[] returnPos = new int[]{-1};
            LinkedList<Row> res = new LinkedList<Row>();
            HashSet<Serializable> remainingIds = new HashSet<Serializable>(ids);
            while (rs.next()) {
                Serializable value = io.getCurrentFromResultSet(rs, select.whatColumns, this.model, returnId, returnPos);
                Serializable newId = returnId[0];
                if (newId != null && !newId.equals(curId)) {
                    if (list != null) {
                        res.add(new Row(tableName, curId, type.collectionToArray(list)));
                        remainingIds.remove(curId);
                    }
                    curId = newId;
                    list = new ArrayList<Serializable>();
                }
                list.add(value);
            }
            if (curId != null && list != null) {
                res.add(new Row(tableName, curId, type.collectionToArray(list)));
                remainingIds.remove(curId);
            }
            if (!remainingIds.isEmpty()) {
                Serializable[] emptyArray = ftype.getEmptyArray();
                for (Serializable id : remainingIds) {
                    res.add(new Row(tableName, id, emptyArray));
                }
            }
            if (this.logger.isLogEnabled()) {
                for (Row row : res) {
                    this.logger.log("  -> " + row);
                }
            }
            linkedList = res;
        }
        catch (Throwable throwable) {
            try {
                this.closeStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not select: " + sql, e);
            }
        }
        this.closeStatement(ps);
        return linkedList;
    }

    protected List<Row> getSelectRows(String tableName, SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Map<String, Serializable> joinMap, boolean limitToOne) throws StorageException {
        LinkedList<Row> list = new LinkedList<Row>();
        if (select.whatColumns.isEmpty() && select.whereColumns.size() == 1) {
            if (select.whereColumns.get(0).getKey() == "id" && joinMap == null) {
                Row row = new Row(tableName, criteriaMap);
                list.add(row);
                return list;
            }
        }
        if (joinMap == null) {
            joinMap = Collections.emptyMap();
        }
        PreparedStatement ps = null;
        try {
            LinkedList<Row> linkedList;
            ps = this.connection.prepareStatement(select.sql);
            LinkedList<Serializable> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<Serializable>();
            }
            int i = 1;
            for (Column column : select.whereColumns) {
                Serializable v;
                String key = column.getKey();
                if (criteriaMap.containsKey(key)) {
                    v = criteriaMap.get(key);
                } else if (joinMap.containsKey(key)) {
                    v = joinMap.get(key);
                } else {
                    throw new RuntimeException(key);
                }
                if (v == null) {
                    throw new StorageException("Null value for key: " + key);
                }
                if (v instanceof Collection) {
                    for (Object vv : (Collection)((Object)v)) {
                        column.setToPreparedStatement(ps, i++, (Serializable)vv);
                        if (debugValues == null) continue;
                        debugValues.add((Serializable)vv);
                    }
                    continue;
                }
                column.setToPreparedStatement(ps, i++, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            if (debugValues != null) {
                this.logger.logSQL(select.sql, debugValues);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Row row = new Row(tableName, criteriaMap);
                i = 1;
                for (Column column : select.whatColumns) {
                    row.put(column.getKey(), column.getFromResultSet(rs, i++));
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, select.whatColumns);
                }
                list.add(row);
                if (!limitToOne) continue;
                LinkedList<Row> i$ = list;
                return i$;
            }
            if (limitToOne) {
                linkedList = null;
                return linkedList;
            }
            linkedList = list;
            return linkedList;
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + select.sql, e);
        }
        finally {
            if (ps != null) {
                try {
                    this.closeStatement(ps);
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void write(RowMapper.RowBatch batch) throws StorageException {
        if (!batch.creates.isEmpty()) {
            this.writeCreates(batch.creates);
        }
        if (!batch.updates.isEmpty()) {
            this.writeUpdates(batch.updates);
        }
        if (!batch.deletes.isEmpty()) {
            this.writeDeletes(batch.deletes);
        }
    }

    protected void writeCreates(List<Row> creates) throws StorageException {
        LinkedHashMap tableRows = new LinkedHashMap();
        tableRows.put("hierarchy", new LinkedList());
        for (Row row : creates) {
            LinkedList<Row> rows = (LinkedList<Row>)tableRows.get(row.tableName);
            if (rows == null) {
                rows = new LinkedList<Row>();
                tableRows.put(row.tableName, rows);
            }
            rows.add(row);
        }
        for (Map.Entry entry : tableRows.entrySet()) {
            String tableName = (String)entry.getKey();
            List rows = (List)entry.getValue();
            if (this.model.isCollectionFragment(tableName)) {
                for (Row row : rows) {
                    this.insertCollectionRows(row);
                }
                continue;
            }
            for (Row row : rows) {
                this.insertSimpleRow(row);
            }
        }
    }

    protected void writeUpdates(Set<RowMapper.RowUpdate> updates) throws StorageException {
        HashMap<String, LinkedList<RowMapper.RowUpdate>> tableRows = new HashMap<String, LinkedList<RowMapper.RowUpdate>>();
        for (RowMapper.RowUpdate rowUpdate : updates) {
            LinkedList<RowMapper.RowUpdate> rows = (LinkedList<RowMapper.RowUpdate>)tableRows.get(rowUpdate.row.tableName);
            if (rows == null) {
                rows = new LinkedList<RowMapper.RowUpdate>();
                tableRows.put(rowUpdate.row.tableName, rows);
            }
            rows.add(rowUpdate);
        }
        for (Map.Entry entry : tableRows.entrySet()) {
            String tableName = (String)entry.getKey();
            List rows = (List)entry.getValue();
            if (this.model.isCollectionFragment(tableName)) {
                for (RowMapper.RowUpdate rowu : rows) {
                    this.updateCollectionRows(rowu.row);
                }
                continue;
            }
            for (RowMapper.RowUpdate rowu : rows) {
                this.updateSimpleRow(rowu.row, rowu.keys);
            }
        }
    }

    protected void writeDeletes(Collection<RowId> deletes) throws StorageException {
        HashMap<String, HashSet<Serializable>> tableIds = new HashMap<String, HashSet<Serializable>>();
        for (RowId rowId : deletes) {
            HashSet<Serializable> ids = (HashSet<Serializable>)tableIds.get(rowId.tableName);
            if (ids == null) {
                ids = new HashSet<Serializable>();
                tableIds.put(rowId.tableName, ids);
            }
            ids.add(rowId.id);
        }
        for (Map.Entry entry : tableIds.entrySet()) {
            String tableName = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            for (Serializable id : ids) {
                this.deleteRows(tableName, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void insertSimpleRow(Row row) throws StorageException {
        PreparedStatement ps = null;
        try {
            String sql = this.sqlInfo.getInsertSql(row.tableName);
            if (sql == null) {
                throw new StorageException("Unknown table: " + row.tableName);
            }
            List<Column> columns = this.sqlInfo.getInsertColumns(row.tableName);
            try {
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, columns, row);
                }
                ps = this.connection.prepareStatement(sql);
                int i = 1;
                for (Column column : columns) {
                    column.setToPreparedStatement(ps, i++, row.get(column.getKey()));
                }
                ps.execute();
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not insert: " + sql, e);
            }
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            if (ps == null) throw throwable;
            try {
                this.closeStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.logger.error(e.getMessage(), e);
            }
            throw throwable;
        }
        try {
            this.closeStatement(ps);
            return;
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void insertCollectionRows(Row row) throws StorageException {
        PreparedStatement ps = null;
        try {
            String sql = this.sqlInfo.getInsertSql(row.tableName);
            List<Column> columns = this.sqlInfo.getInsertColumns(row.tableName);
            try {
                ArrayList<Serializable> debugValues = null;
                if (this.logger.isLogEnabled()) {
                    debugValues = new ArrayList<Serializable>(3);
                }
                ps = this.connection.prepareStatement(sql);
                this.getCollectionIO(row.tableName).setToPreparedStatement(row.id, row.values, columns, ps, this.model, debugValues, sql, this.logger);
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not insert: " + sql, e);
            }
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            if (ps == null) throw throwable;
            try {
                this.closeStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.logger.error(e.getMessage(), e);
            }
            throw throwable;
        }
        try {
            this.closeStatement(ps);
            return;
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSimpleRow(Row row, Collection<String> keys) throws StorageException {
        if (keys.isEmpty()) {
            return;
        }
        SQLInfo.SQLInfoSelect update = this.sqlInfo.getUpdateById(row.tableName, keys);
        try {
            PreparedStatement ps = this.connection.prepareStatement(update.sql);
            try {
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(update.sql, update.whatColumns, row);
                }
                int i = 1;
                for (Column column : update.whatColumns) {
                    column.setToPreparedStatement(ps, i++, row.get(column.getKey()));
                }
                int count = ps.executeUpdate();
                this.logger.logCount(count);
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not update: " + update.sql, e);
        }
    }

    protected void updateCollectionRows(Row row) throws StorageException {
        this.deleteRows(row.tableName, row.id);
        this.insertCollectionRows(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteRows(String tableName, Serializable id) throws StorageException {
        try {
            String sql = this.sqlInfo.getDeleteSql(tableName);
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(id));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ps.setObject(1, id);
                int count = ps.executeUpdate();
                this.logger.logCount(count);
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not delete: " + id.toString(), e);
        }
    }

    @Override
    public Row readSimpleRow(RowId rowId) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectFragmentById.get(rowId.tableName);
        Map<String, Serializable> criteriaMap = Collections.singletonMap("id", rowId.id);
        List<Row> maps = this.getSelectRows(rowId.tableName, select, criteriaMap, null, true);
        return maps == null ? null : maps.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) throws StorageException {
        Serializable[] serializableArray;
        String tableName = rowId.tableName;
        Serializable id = rowId.id;
        String sql = this.sqlInfo.selectFragmentById.get((Object)tableName).sql;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            List<Column> columns = this.sqlInfo.selectFragmentById.get((Object)tableName).whatColumns;
            ps.setObject(1, id);
            ResultSet rs = ps.executeQuery();
            CollectionIO io = this.getCollectionIO(tableName);
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            Serializable[] returnId = new Serializable[1];
            int[] returnPos = new int[]{-1};
            while (rs.next()) {
                list.add(io.getCurrentFromResultSet(rs, columns, this.model, returnId, returnPos));
            }
            PropertyType type = this.model.getCollectionFragmentType(tableName).getArrayBaseType();
            Serializable[] array = type.collectionToArray(list);
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> " + Arrays.asList(array));
            }
            serializableArray = array;
        }
        catch (Throwable throwable) {
            try {
                this.closeStatement(ps);
                throw throwable;
            }
            catch (SQLException e) {
                this.checkConnectionReset(e);
                throw new StorageException("Could not select: " + sql, e);
            }
        }
        this.closeStatement(ps);
        return serializableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Row readChildHierRow(Serializable parentId, String childName, boolean complexProp) throws StorageException {
        String sql = this.sqlInfo.getSelectByChildNameSql(complexProp);
        try {
            ArrayList<Serializable> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new ArrayList<Serializable>(2);
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                ResultSet rs;
                int i = 0;
                for (Column column222 : this.sqlInfo.getSelectByChildNameWhereColumns(complexProp)) {
                    Object v;
                    ++i;
                    String key = column222.getKey();
                    if (key.equals("parentid")) {
                        v = parentId;
                    } else {
                        if (!key.equals("name")) throw new RuntimeException("Invalid hier column: " + key);
                        v = childName;
                    }
                    if (v == null) {
                        throw new IllegalStateException("Null value for key: " + key);
                    }
                    column222.setToPreparedStatement(ps, i, (Serializable)v);
                    if (debugValues == null) continue;
                    debugValues.add((Serializable)v);
                }
                if (debugValues != null) {
                    this.logger.logSQL(sql, debugValues);
                }
                if (!(rs = ps.executeQuery()).next()) {
                    Column column222;
                    column222 = null;
                    return column222;
                }
                Row row = new Row("hierarchy", (Serializable)null);
                i = 1;
                List<Column> columns = this.sqlInfo.getSelectByChildNameWhatColumns(complexProp);
                for (Column column : columns) {
                    row.put(column.getKey(), column.getFromResultSet(rs, i++));
                }
                row.put("parentid", parentId);
                row.put("name", (Serializable)((Object)childName));
                row.put("isproperty", Boolean.valueOf(complexProp));
                if (this.logger.isLogEnabled()) {
                    this.logger.logResultSet(rs, columns);
                }
                while (rs.next()) {
                    String newName = childName + '.' + System.currentTimeMillis();
                    i = 0;
                    Serializable childId = null;
                    for (Column column : columns) {
                        ++i;
                        if (!column.getKey().equals("id")) continue;
                        childId = column.getFromResultSet(rs, i);
                    }
                    this.logger.error(String.format("Child '%s' appeared twice as child of %s (%s and %s), renaming second to '%s'", childName, parentId, row.id, childId, newName));
                    Row rename = new Row("hierarchy", childId);
                    rename.putNew("name", (Serializable)((Object)newName));
                    this.updateSimpleRowWithValues("hierarchy", rename);
                }
                Row row2 = row;
                return row2;
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not select: " + sql, e);
        }
    }

    @Override
    public List<Row> readChildHierRows(Serializable parentId, boolean complexProp) throws StorageException {
        if (parentId == null) {
            throw new IllegalArgumentException("Illegal null parentId");
        }
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectChildrenByIsProperty;
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("parentid", parentId);
        criteriaMap.put("isproperty", Boolean.valueOf(complexProp));
        return this.getSelectRows("hierarchy", select, criteriaMap, null, false);
    }

    @Override
    public List<Row> getVersionRows(Serializable versionSeriesId) throws StorageException {
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectVersionsBySeries;
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put("versionableid", versionSeriesId);
        criteriaMap.put("isversion", Boolean.TRUE);
        return this.getSelectRows("versions", select, criteriaMap, null, false);
    }

    @Override
    public List<Row> getProxyRows(Serializable searchId, boolean byTarget, Serializable parentId) throws StorageException {
        Map<String, Serializable> joinMap;
        SQLInfo.SQLInfoSelect select;
        Map<String, Serializable> criteriaMap = Collections.singletonMap(byTarget ? "targetid" : "versionableid", searchId);
        if (parentId == null) {
            select = byTarget ? this.sqlInfo.selectProxiesByTarget : this.sqlInfo.selectProxiesBySeries;
            joinMap = null;
        } else {
            select = byTarget ? this.sqlInfo.selectProxiesByTargetAndParent : this.sqlInfo.selectProxiesByVersionSeriesAndParent;
            joinMap = Collections.singletonMap("parentid", parentId);
        }
        return this.getSelectRows("proxies", select, criteriaMap, joinMap, false);
    }

    @Override
    public RowMapper.CopyHierarchyResult copyHierarchy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow) throws StorageException {
        Invalidations invalidations = new Invalidations();
        try {
            Serializable invalParentId;
            Serializable overwriteId;
            LinkedHashMap<Serializable, Serializable> idMap = new LinkedHashMap<Serializable, Serializable>();
            HashMap<Serializable, RowMapper.IdWithTypes> idToTypes = new HashMap<Serializable, RowMapper.IdWithTypes>();
            Serializable serializable = overwriteId = overwriteRow == null ? null : overwriteRow.id;
            if (overwriteId != null) {
                String tableName = "hierarchy";
                this.updateSimpleRowWithValues(tableName, overwriteRow);
                idMap.put(source.id, overwriteId);
                invalidations.addModified(new RowId(tableName, overwriteId));
            }
            Serializable newRootId = this.copyHierRecursive(source, destParentId, destName, overwriteId, idMap, idToTypes);
            Serializable serializable2 = invalParentId = overwriteId == null ? destParentId : overwriteId;
            if (invalParentId != null) {
                invalidations.addModified(new RowId("__PARENT__", invalParentId));
            }
            for (Map.Entry<String, Set<Serializable>> entry : this.model.getPerFragmentIds(idToTypes).entrySet()) {
                Set<Serializable> ids;
                Boolean invalidation;
                String tableName = entry.getKey();
                if (tableName.equals("acls") || (invalidation = this.copyRows(tableName, ids = entry.getValue(), idMap, overwriteId)) == null) continue;
                if (Boolean.TRUE.equals(invalidation)) {
                    invalidations.addModified(Collections.singleton(new RowId(tableName, overwriteId)));
                    continue;
                }
                invalidations.addDeleted(Collections.singleton(new RowId(tableName, overwriteId)));
            }
            return new RowMapper.CopyHierarchyResult(newRootId, invalidations);
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not copy: " + source.id.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSimpleRowWithValues(String tableName, Row row) throws StorageException {
        Update update = this.sqlInfo.getUpdateByIdForKeys(tableName, row.getKeys());
        Table table = update.getTable();
        String sql = update.getStatement();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (this.logger.isLogEnabled()) {
                    LinkedList<Serializable> values = new LinkedList<Serializable>();
                    values.addAll(row.getValues());
                    values.add(row.id);
                    this.logger.logSQL(sql, values);
                }
                int i = 1;
                List<String> keys = row.getKeys();
                List<Serializable> values = row.getValues();
                int size = keys.size();
                for (int r = 0; r < size; ++r) {
                    String key = keys.get(r);
                    Serializable value = values.get(r);
                    table.getColumn(key).setToPreparedStatement(ps, i++, value);
                }
                ps.setObject(i, row.id);
                int count = ps.executeUpdate();
                this.logger.logCount(count);
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            this.checkConnectionReset(e);
            throw new StorageException("Could not update: " + sql, e);
        }
    }

    protected Serializable copyHierRecursive(RowMapper.IdWithTypes source, Serializable parentId, String name, Serializable overwriteId, Map<Serializable, Serializable> idMap, Map<Serializable, RowMapper.IdWithTypes> idToTypes) throws SQLException {
        Serializable newId;
        idToTypes.put(source.id, source);
        if (overwriteId == null) {
            newId = this.copyHier(source.id, parentId, name, idMap);
        } else {
            newId = overwriteId;
            idMap.put(source.id, newId);
        }
        boolean onlyComplex = parentId == null;
        for (RowMapper.IdWithTypes child : this.getChildrenIdsWithTypes(source.id, onlyComplex)) {
            this.copyHierRecursive(child, newId, null, null, idMap, idToTypes);
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Serializable copyHier(Serializable id, Serializable parentId, String name, Map<Serializable, Serializable> idMap) throws SQLException {
        boolean createVersion = parentId == null;
        boolean explicitName = name != null;
        Serializable newId = null;
        String sql = this.sqlInfo.getCopyHierSql(explicitName, createVersion);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            newId = this.model.generateNewId();
            ArrayList<Serializable> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new ArrayList<Serializable>(4);
            }
            List<Column> columns = this.sqlInfo.getCopyHierColumns(explicitName, createVersion);
            Column whereColumn = this.sqlInfo.getCopyHierWhereColumn();
            int i = 1;
            for (Column column : columns) {
                Object v;
                String key = column.getKey();
                if (key.equals("parentid")) {
                    v = parentId;
                } else if (key.equals("name")) {
                    v = name;
                } else if (key.equals("id")) {
                    v = newId;
                } else {
                    if (!createVersion) throw new RuntimeException(column.toString());
                    if (!key.equals("baseversionid")) {
                        if (!key.equals("ischeckedin")) throw new RuntimeException(column.toString());
                    }
                    v = null;
                }
                column.setToPreparedStatement(ps, i++, (Serializable)v);
                if (debugValues == null) continue;
                debugValues.add((Serializable)v);
            }
            whereColumn.setToPreparedStatement(ps, i, id);
            if (debugValues != null) {
                debugValues.add(id);
                this.logger.logSQL(sql, debugValues);
            }
            int count = ps.executeUpdate();
            this.logger.logCount(count);
            idMap.put(id, newId);
            return newId;
        }
        finally {
            this.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RowMapper.IdWithTypes> getChildrenIdsWithTypes(Serializable id, boolean onlyComplex) throws SQLException {
        LinkedList<RowMapper.IdWithTypes> children = new LinkedList<RowMapper.IdWithTypes>();
        String sql = this.sqlInfo.getSelectChildrenIdsAndTypesSql(onlyComplex);
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        List<Column> columns = this.sqlInfo.getSelectChildrenIdsAndTypesWhatColumns();
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            LinkedList<String> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<String>();
            }
            ps.setObject(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Serializable childId = null;
                String childPrimaryType = null;
                String[] childMixinTypes = null;
                int i = 1;
                for (Column column : columns) {
                    String key = column.getKey();
                    Serializable value = column.getFromResultSet(rs, i++);
                    if (key.equals("id")) {
                        childId = value;
                        continue;
                    }
                    if (key.equals("primarytype")) {
                        childPrimaryType = (String)((Object)value);
                        continue;
                    }
                    if (!key.equals("mixintypes")) continue;
                    childMixinTypes = (String[])value;
                }
                children.add(new RowMapper.IdWithTypes(childId, childPrimaryType, childMixinTypes));
                if (debugValues == null) continue;
                debugValues.add(childId + "/" + childPrimaryType + "/" + childMixinTypes);
            }
            if (debugValues != null) {
                this.logger.log("  -> " + debugValues);
            }
            LinkedList<RowMapper.IdWithTypes> linkedList = children;
            return linkedList;
        }
        finally {
            this.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean copyRows(String tableName, Set<Serializable> ids, Map<Serializable, Serializable> idMap, Serializable overwriteId) throws SQLException {
        String copySql = this.sqlInfo.getCopySql(tableName);
        Column copyIdColumn = this.sqlInfo.getCopyIdColumn(tableName);
        PreparedStatement copyPs = this.connection.prepareStatement(copySql);
        String deleteSql = this.sqlInfo.getDeleteSql(tableName);
        PreparedStatement deletePs = this.connection.prepareStatement(deleteSql);
        try {
            boolean before = false;
            boolean after = false;
            for (Serializable id : ids) {
                Serializable newId = idMap.get(id);
                boolean overwrite = newId.equals(overwriteId);
                if (overwrite) {
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(deleteSql, Collections.singletonList(newId));
                    }
                    deletePs.setObject(1, newId);
                    int delCount = deletePs.executeUpdate();
                    this.logger.logCount(delCount);
                    before = delCount > 0;
                }
                copyIdColumn.setToPreparedStatement(copyPs, 1, newId);
                copyIdColumn.setToPreparedStatement(copyPs, 2, id);
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(copySql, Arrays.asList(newId, id));
                }
                int copyCount = copyPs.executeUpdate();
                this.logger.logCount(copyCount);
                if (!overwrite) continue;
                after = copyCount > 0;
            }
            Boolean bl = after ? Boolean.TRUE : (before ? Boolean.FALSE : null);
            return bl;
        }
        finally {
            this.closeStatement(copyPs);
            this.closeStatement(deletePs);
        }
    }
}

