/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;

public class SQLInfo {
    private static final String ORDER_DESC = "DESC";
    private static final String ORDER_ASC = "ASC";
    public final Database database;
    public final Dialect dialect;
    private final Model model;
    private String selectRootIdSql;
    private Column selectRootIdWhatColumn;
    private final Map<String, String> insertSqlMap;
    private final Map<String, List<Column>> insertColumnsMap;
    private final Map<String, String> deleteSqlMap;
    private String selectByChildNameAllSql;
    private String selectByChildNameRegularSql;
    private String selectByChildNamePropertiesSql;
    private List<Column> selectByChildNameAllWhatColumns;
    private List<Column> selectByChildNameRegularWhatColumns;
    private List<Column> selectByChildNamePropertiesWhatColumns;
    private List<Column> selectByChildNameAllWhereColumns;
    private List<Column> selectByChildNameRegularWhereColumns;
    private List<Column> selectByChildNamePropertiesWhereColumns;
    private String selectChildrenIdsAndTypesSql;
    private String selectComplexChildrenIdsAndTypesSql;
    private List<Column> selectChildrenIdsAndTypesWhatColumns;
    private String copyHierSqlExplicitName;
    private String copyHierSqlCreateVersion;
    private String copyHierSql;
    private List<Column> copyHierColumnsExplicitName;
    private List<Column> copyHierColumnsCreateVersion;
    private List<Column> copyHierColumns;
    private Column copyHierWhereColumn;
    private final Map<String, String> copySqlMap;
    private final Map<String, Column> copyIdColumnMap;
    private final String selectVersionIdByLabelSql;
    private final List<Column> selectVersionIdByLabelWhereColumns;
    private final Column selectVersionIdByLabelWhatColumn;
    protected final Map<String, SQLInfoSelect> selectFragmentById;
    protected SQLInfoSelect selectVersionsBySeries;
    protected SQLInfoSelect selectVersionsBySeriesDesc;
    protected SQLInfoSelect selectVersionBySeriesAndLabel;
    protected SQLInfoSelect selectProxiesBySeries;
    protected SQLInfoSelect selectProxiesByTarget;
    protected SQLInfoSelect selectChildrenByIsProperty;
    protected SQLInfoSelect selectProxiesByVersionSeriesAndParent;
    protected SQLInfoSelect selectProxiesByTargetAndParent;
    protected List<Column> clusterInvalidationsColumns;
    protected Map<String, List<SQLStatement>> sqlStatements;
    protected Map<String, Serializable> sqlStatementsProperties;

    public SQLInfo(RepositoryImpl repository, Model model, Dialect dialect) throws StorageException {
        this.model = model;
        this.dialect = dialect;
        this.database = new Database(repository, dialect);
        this.selectRootIdSql = null;
        this.selectRootIdWhatColumn = null;
        this.selectFragmentById = new HashMap<String, SQLInfoSelect>();
        this.selectByChildNameAllSql = null;
        this.selectByChildNameAllWhatColumns = null;
        this.selectByChildNameAllWhereColumns = null;
        this.selectByChildNameRegularSql = null;
        this.selectByChildNameRegularWhatColumns = null;
        this.selectByChildNameRegularWhereColumns = null;
        this.selectByChildNamePropertiesSql = null;
        this.selectByChildNamePropertiesWhatColumns = null;
        this.selectByChildNamePropertiesWhereColumns = null;
        this.selectChildrenIdsAndTypesSql = null;
        this.selectChildrenIdsAndTypesWhatColumns = null;
        this.selectComplexChildrenIdsAndTypesSql = null;
        this.insertSqlMap = new HashMap<String, String>();
        this.insertColumnsMap = new HashMap<String, List<Column>>();
        this.deleteSqlMap = new HashMap<String, String>();
        this.copyHierSqlExplicitName = null;
        this.copyHierSqlCreateVersion = null;
        this.copyHierSql = null;
        this.copyHierColumnsExplicitName = null;
        this.copyHierColumnsCreateVersion = null;
        this.copyHierColumns = null;
        this.copyHierWhereColumn = null;
        this.copySqlMap = new HashMap<String, String>();
        this.copyIdColumnMap = new HashMap<String, Column>();
        this.selectVersionIdByLabelSql = null;
        this.selectVersionIdByLabelWhereColumns = new ArrayList<Column>(2);
        this.selectVersionIdByLabelWhatColumn = null;
        this.initSQL();
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getSelectRootIdSql() {
        return this.selectRootIdSql;
    }

    public Column getSelectRootIdWhatColumn() {
        return this.selectRootIdWhatColumn;
    }

    public String getInsertRootIdSql() {
        return this.insertSqlMap.get("repositories");
    }

    public List<Column> getInsertRootIdColumns() {
        return this.insertColumnsMap.get("repositories");
    }

    public String getSelectByChildNameSql(Boolean complexProp) {
        if (complexProp == null) {
            return this.selectByChildNameAllSql;
        }
        if (complexProp.booleanValue()) {
            return this.selectByChildNamePropertiesSql;
        }
        return this.selectByChildNameRegularSql;
    }

    public List<Column> getSelectByChildNameWhatColumns(Boolean complexProp) {
        if (complexProp == null) {
            return this.selectByChildNameAllWhatColumns;
        }
        if (complexProp.booleanValue()) {
            return this.selectByChildNamePropertiesWhatColumns;
        }
        return this.selectByChildNameRegularWhatColumns;
    }

    public List<Column> getSelectByChildNameWhereColumns(Boolean complexProp) {
        if (complexProp == null) {
            return this.selectByChildNameAllWhereColumns;
        }
        if (complexProp.booleanValue()) {
            return this.selectByChildNamePropertiesWhereColumns;
        }
        return this.selectByChildNameRegularWhereColumns;
    }

    public String getSelectChildrenIdsAndTypesSql(boolean onlyComplex) {
        return onlyComplex ? this.selectComplexChildrenIdsAndTypesSql : this.selectChildrenIdsAndTypesSql;
    }

    public List<Column> getSelectChildrenIdsAndTypesWhatColumns() {
        return this.selectChildrenIdsAndTypesWhatColumns;
    }

    public List<Column> getClusterInvalidationsColumns() {
        return this.clusterInvalidationsColumns;
    }

    public String getInsertSql(String tableName) {
        return this.insertSqlMap.get(tableName);
    }

    public List<Column> getInsertColumns(String tableName) {
        return this.insertColumnsMap.get(tableName);
    }

    public SQLInfoSelect getUpdateById(String tableName, Collection<String> keys) {
        Table table = this.database.getTable(tableName);
        LinkedList<String> values = new LinkedList<String>();
        LinkedList<Column> columns = new LinkedList<Column>();
        Column mainColumn = table.getColumn("id");
        for (String key : keys) {
            Column column = table.getColumn(key);
            values.add(column.getQuotedName() + " = " + column.getFreeVariableSetter());
            columns.add(column);
        }
        columns.add(mainColumn);
        Update update = new Update(table);
        update.setNewValues(StringUtils.join(values, (String)", "));
        update.setWhere(mainColumn.getQuotedName() + " = ?");
        return new SQLInfoSelect(update.getStatement(), columns, null, null);
    }

    public Update getUpdateByIdForKeys(String tableName, List<String> keys) {
        Table table = this.database.getTable(tableName);
        ArrayList<String> values = new ArrayList<String>(keys.size());
        for (String key : keys) {
            Column column = table.getColumn(key);
            values.add(column.getQuotedName() + " = " + column.getFreeVariableSetter());
        }
        Update update = new Update(table);
        update.setNewValues(StringUtils.join(values, (String)", "));
        update.setWhere(table.getColumn("id").getQuotedName() + " = ?");
        return update;
    }

    public SQLInfoSelect getSelectFragmentsByIds(String tableName, int nids) {
        return this.getSelectFragmentsByIds(tableName, nids, null, null);
    }

    public SQLInfoSelect getSelectFragmentsByIds(String tableName, int nids, String[] orderBys, Set<String> skipColumns) {
        Table table = this.database.getTable(tableName);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        for (Column column : table.getColumns()) {
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            if (skipColumns != null && skipColumns.contains(column.getKey())) continue;
            whatColumns.add(column);
            whats.add(column.getQuotedName());
        }
        Column whereColumn = table.getColumn("id");
        StringBuilder wherebuf = new StringBuilder(whereColumn.getQuotedName());
        wherebuf.append(" IN (");
        for (int i = 0; i < nids; ++i) {
            if (i != 0) {
                wherebuf.append(", ");
            }
            wherebuf.append('?');
        }
        wherebuf.append(')');
        Select select = new Select(table);
        select.setWhat(StringUtils.join(whats, (String)", "));
        select.setFrom(table.getQuotedName());
        select.setWhere(wherebuf.toString());
        if (orderBys != null) {
            LinkedList<String> orders = new LinkedList<String>();
            for (String orderBy : orderBys) {
                orders.add(table.getColumn(orderBy).getQuotedName());
            }
            select.setOrderBy(StringUtils.join(orders, (String)", "));
        }
        return new SQLInfoSelect(select.getStatement(), whatColumns, Collections.singletonList(whereColumn), opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public String getDeleteSql(String tableName) {
        return this.deleteSqlMap.get(tableName);
    }

    public String getCopyHierSql(boolean explicitName, boolean createVersion) {
        assert (!explicitName || !createVersion);
        return explicitName ? this.copyHierSqlExplicitName : (createVersion ? this.copyHierSqlCreateVersion : this.copyHierSql);
    }

    public List<Column> getCopyHierColumns(boolean explicitName, boolean createVersion) {
        assert (!explicitName || !createVersion);
        return explicitName ? this.copyHierColumnsExplicitName : (createVersion ? this.copyHierColumnsCreateVersion : this.copyHierColumns);
    }

    public Column getCopyHierWhereColumn() {
        return this.copyHierWhereColumn;
    }

    public String getCopySql(String tableName) {
        return this.copySqlMap.get(tableName);
    }

    public Column getCopyIdColumn(String tableName) {
        return this.copyIdColumnMap.get(tableName);
    }

    public String getVersionIdByLabelSql() {
        return this.selectVersionIdByLabelSql;
    }

    public List<Column> getVersionIdByLabelWhereColumns() {
        return this.selectVersionIdByLabelWhereColumns;
    }

    public Column getVersionIdByLabelWhatColumn() {
        return this.selectVersionIdByLabelWhatColumn;
    }

    protected void initSQL() throws StorageException {
        if (this.model.getRepositoryDescriptor().clusteringEnabled) {
            if (!this.dialect.isClusteringSupported()) {
                throw new StorageException("Clustering not supported for " + this.dialect.getClass().getSimpleName());
            }
            this.initClusterSQL();
        }
        this.initHierarchySQL();
        this.initRepositorySQL();
        if (this.dialect.supportsAncestorsTable()) {
            this.initAncestorsSQL();
        }
        for (String tableName : this.model.getFragmentNames()) {
            if (tableName.equals("hierarchy")) continue;
            this.initFragmentSQL(tableName);
        }
        Table hierTable = this.database.getTable("hierarchy");
        Table versionTable = this.database.getTable("versions");
        String[] stringArray = new String[1];
        stringArray[0] = "isversion";
        hierTable.addIndex(stringArray);
        String[] stringArray2 = new String[1];
        stringArray2[0] = "versionableid";
        versionTable.addIndex(stringArray2);
        String[] stringArray3 = new String[1];
        stringArray3[0] = "versionableid";
        String[] stringArray4 = new String[1];
        stringArray4[0] = "isversion";
        String[] stringArray5 = new String[2];
        stringArray5[0] = "created";
        stringArray5[1] = ORDER_ASC;
        this.selectVersionsBySeries = this.makeJoinSelect(versionTable, stringArray3, hierTable, stringArray4, stringArray5);
        String[] stringArray6 = new String[1];
        stringArray6[0] = "versionableid";
        String[] stringArray7 = new String[1];
        stringArray7[0] = "isversion";
        String[] stringArray8 = new String[2];
        stringArray8[0] = "created";
        stringArray8[1] = ORDER_DESC;
        this.selectVersionsBySeriesDesc = this.makeJoinSelect(versionTable, stringArray6, hierTable, stringArray7, stringArray8);
        String[] stringArray9 = new String[2];
        stringArray9[0] = "versionableid";
        stringArray9[1] = "label";
        String[] stringArray10 = new String[1];
        stringArray10[0] = "isversion";
        this.selectVersionBySeriesAndLabel = this.makeJoinSelect(versionTable, stringArray9, hierTable, stringArray10);
        Table proxyTable = this.database.getTable("proxies");
        String[] stringArray11 = new String[1];
        stringArray11[0] = "versionableid";
        this.selectProxiesBySeries = this.makeSelect(proxyTable, stringArray11);
        String[] stringArray12 = new String[1];
        stringArray12[0] = "versionableid";
        proxyTable.addIndex(stringArray12);
        String[] stringArray13 = new String[1];
        stringArray13[0] = "targetid";
        this.selectProxiesByTarget = this.makeSelect(proxyTable, stringArray13);
        String[] stringArray14 = new String[1];
        stringArray14[0] = "targetid";
        proxyTable.addIndex(stringArray14);
        String[] stringArray15 = new String[1];
        stringArray15[0] = "versionableid";
        String[] stringArray16 = new String[1];
        stringArray16[0] = "parentid";
        this.selectProxiesByVersionSeriesAndParent = this.makeJoinSelect(proxyTable, stringArray15, hierTable, stringArray16);
        String[] stringArray17 = new String[1];
        stringArray17[0] = "targetid";
        String[] stringArray18 = new String[1];
        stringArray18[0] = "parentid";
        this.selectProxiesByTargetAndParent = this.makeJoinSelect(proxyTable, stringArray17, hierTable, stringArray18);
        if (!this.model.getRepositoryDescriptor().fulltextDisabled) {
            Table table = this.database.getTable("fulltext");
            ModelFulltext fulltextInfo = this.model.getFulltextInfo();
            if (fulltextInfo.indexNames.size() > 1 && !this.dialect.supportsMultipleFulltextIndexes()) {
                String msg = String.format("SQL database supports only one fulltext index, but %d are configured: %s", fulltextInfo.indexNames.size(), fulltextInfo.indexNames);
                throw new StorageException(msg);
            }
            for (String indexName : fulltextInfo.indexNames) {
                String suffix = this.model.getFulltextIndexSuffix(indexName);
                int ftic = this.dialect.getFulltextIndexedColumns();
                if (ftic == 1) {
                    String[] stringArray19 = new String[1];
                    stringArray19[0] = "fulltext" + suffix;
                    table.addFulltextIndex(indexName, stringArray19);
                    continue;
                }
                if (ftic != 2) continue;
                String[] stringArray20 = new String[2];
                stringArray20[0] = "simpletext" + suffix;
                stringArray20[1] = "binarytext" + suffix;
                table.addFulltextIndex(indexName, stringArray20);
            }
        }
    }

    protected void initClusterSQL() {
        TableMaker maker = new TableMaker("cluster_nodes");
        maker.newColumn("nodeid", ColumnType.CLUSTERNODE);
        maker.newColumn("created", ColumnType.TIMESTAMP);
        maker = new TableMaker("cluster_invals");
        maker.newColumn("nodeid", ColumnType.CLUSTERNODE);
        maker.newColumn("id", ColumnType.NODEVAL);
        maker.newColumn("fragments", ColumnType.CLUSTERFRAGS);
        maker.newColumn("kind", ColumnType.TINYINT);
        String[] stringArray = new String[1];
        stringArray[0] = "nodeid";
        maker.table.addIndex(stringArray);
        maker.postProcessClusterInvalidations();
    }

    protected void initRepositorySQL() {
        TableMaker maker = new TableMaker("repositories");
        maker.newColumn("id", ColumnType.NODEIDFK);
        maker.newColumn("name", ColumnType.SYSNAME);
        maker.postProcessRepository();
    }

    protected void initHierarchySQL() {
        TableMaker maker = new TableMaker("hierarchy");
        maker.newColumn("id", ColumnType.NODEID);
        Column column = maker.newColumn("parentid", ColumnType.NODEIDFKNULL);
        maker.newColumn("pos", ColumnType.INTEGER);
        maker.newColumn("name", ColumnType.VARCHAR);
        maker.newColumn("isproperty", ColumnType.BOOLEAN);
        maker.newFragmentFields();
        maker.postProcess();
        maker.postProcessHierarchy();
        String[] stringArray = new String[1];
        stringArray[0] = "parentid";
        maker.table.addIndex(stringArray);
        String[] stringArray2 = new String[2];
        stringArray2[0] = "parentid";
        stringArray2[1] = "name";
        maker.table.addIndex(stringArray2);
        String[] stringArray3 = new String[1];
        stringArray3[0] = "primarytype";
        maker.table.addIndex(stringArray3);
    }

    protected void initAncestorsSQL() {
        TableMaker maker = new TableMaker("ancestors");
        maker.newColumn("id", ColumnType.NODEIDFKMUL);
        maker.newColumn("ancestors", ColumnType.NODEARRAY);
    }

    protected void initFragmentSQL(String tableName) {
        TableMaker maker = new TableMaker(tableName);
        ColumnType type = tableName.equals("hierarchy") ? ColumnType.NODEID : (tableName.equals("locks") ? ColumnType.NODEIDPK : (this.model.isCollectionFragment(tableName) ? ColumnType.NODEIDFKMUL : ColumnType.NODEIDFK));
        maker.newColumn("id", type);
        maker.newFragmentFields();
        maker.postProcess();
    }

    public SQLInfoSelect makeSelect(Table table, String ... freeColumns) {
        String[] orderBys = new String[]{};
        return this.makeSelect(table, orderBys, freeColumns);
    }

    public SQLInfoSelect makeSelect(Table table, String[] orderBys, String ... freeColumns) {
        List<String> freeColumnsList = Arrays.asList(freeColumns);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<Column> whereColumns = new LinkedList<Column>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<String> wheres = new LinkedList<String>();
        for (Column column : table.getColumns()) {
            String qname = column.getQuotedName();
            if (freeColumnsList.contains(column.getKey())) {
                whereColumns.add(column);
                wheres.add(qname + " = ?");
                continue;
            }
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            whatColumns.add(column);
            whats.add(qname);
        }
        if (whats.isEmpty()) {
            whats.add(table.getColumn("id").getQuotedName());
        }
        Select select = new Select(table);
        select.setWhat(StringUtils.join(whats, (String)", "));
        select.setFrom(table.getQuotedName());
        select.setWhere(StringUtils.join(wheres, (String)" AND "));
        LinkedList<String> orders = new LinkedList<String>();
        for (int i = 0; i < orderBys.length; ++i) {
            String name = orderBys[i++];
            String ascdesc = orderBys[i].equals(ORDER_DESC) ? " DESC" : "";
            orders.add(table.getColumn(name).getQuotedName() + ascdesc);
        }
        select.setOrderBy(StringUtils.join(orders, (String)", "));
        return new SQLInfoSelect(select.getStatement(), whatColumns, whereColumns, opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public SQLInfoSelect makeJoinSelect(Table table, String[] freeColumns, Table joinTable, String[] joinCriteria) {
        return this.makeJoinSelect(table, freeColumns, joinTable, joinCriteria, new String[0]);
    }

    public SQLInfoSelect makeJoinSelect(Table table, String[] freeColumns, Table joinTable, String[] joinCriteria, String[] orderBys) {
        List<String> freeColumnsList = Arrays.asList(freeColumns);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<Column> whereColumns = new LinkedList<Column>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<String> wheres = new LinkedList<String>();
        String join = table.getColumn("id").getFullQuotedName() + " = " + joinTable.getColumn("id").getFullQuotedName();
        wheres.add(join);
        for (Column column : table.getColumns()) {
            String qname = column.getFullQuotedName();
            if (freeColumnsList.contains(column.getKey())) {
                whereColumns.add(column);
                wheres.add(qname + " = ?");
                continue;
            }
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            whatColumns.add(column);
            whats.add(qname);
        }
        if (whats.isEmpty()) {
            whats.add(table.getColumn("id").getQuotedName());
        }
        for (String name : joinCriteria) {
            Column column = joinTable.getColumn(name);
            whereColumns.add(column);
            wheres.add(column.getFullQuotedName() + " = ?");
        }
        Select select = new Select(table);
        select.setWhat(StringUtils.join(whats, (String)", "));
        select.setFrom(table.getQuotedName() + ", " + joinTable.getQuotedName());
        select.setWhere(StringUtils.join(wheres, (String)" AND "));
        LinkedList<String> orders = new LinkedList<String>();
        for (int i = 0; i < orderBys.length; ++i) {
            String name;
            name = orderBys[i++];
            String ascdesc = orderBys[i].equals(ORDER_DESC) ? " DESC" : "";
            Column c = table.getColumn(name);
            if (c == null) {
                c = joinTable.getColumn(name);
            }
            orders.add(c.getQuotedName() + ascdesc);
        }
        select.setOrderBy(StringUtils.join(orders, (String)", "));
        return new SQLInfoSelect(select.getStatement(), whatColumns, whereColumns, opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public void initSQLStatements(Map<String, Serializable> testProps) throws IOException {
        this.sqlStatements = new HashMap<String, List<SQLStatement>>();
        SQLStatement.read(this.dialect.getSQLStatementsFilename(), this.sqlStatements);
        if (!testProps.isEmpty()) {
            SQLStatement.read(this.dialect.getTestSQLStatementsFilename(), this.sqlStatements);
        }
        this.sqlStatementsProperties = this.dialect.getSQLStatementsProperties(this.model, this.database);
        if (!testProps.isEmpty()) {
            this.sqlStatementsProperties.putAll(testProps);
        }
    }

    public void executeSQLStatements(String category, JDBCConnection jdbc) throws SQLException {
        List<SQLStatement> statements = this.sqlStatements.get(category);
        if (statements != null) {
            SQLStatement.execute(statements, this.sqlStatementsProperties, jdbc);
        }
    }

    public static class ColumnMapMaker
    implements MapMaker {
        public final List<Column> columns;
        public final List<String> keys;

        public ColumnMapMaker(List<Column> columns) {
            this.columns = columns;
            this.keys = new ArrayList<String>(columns.size());
            for (Column column : columns) {
                this.keys.add(column.getKey());
            }
        }

        public ColumnMapMaker(List<Column> columns, List<String> keys) {
            this.columns = columns;
            this.keys = keys;
        }

        @Override
        public Map<String, Serializable> makeMap(ResultSet rs) throws SQLException {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            int i = 1;
            for (Column column : this.columns) {
                String key = this.keys.get(i - 1);
                Serializable value = column.getFromResultSet(rs, i++);
                map.put(key, value);
            }
            return map;
        }
    }

    public static interface MapMaker {
        public Map<String, Serializable> makeMap(ResultSet var1) throws SQLException;
    }

    public static class SQLInfoSelect {
        public final String sql;
        public final List<Column> whatColumns;
        public final MapMaker mapMaker;
        public final List<Column> whereColumns;
        public final List<Column> opaqueColumns;

        public SQLInfoSelect(String sql, List<Column> whatColumns, List<Column> whereColumns, List<Column> opaqueColumns) {
            this(sql, whatColumns, null, whereColumns, opaqueColumns);
        }

        public SQLInfoSelect(String sql, MapMaker mapMaker) {
            this(sql, null, mapMaker, null, null);
        }

        protected SQLInfoSelect(String sql, List<Column> whatColumns, MapMaker mapMaker, List<Column> whereColumns, List<Column> opaqueColumns) {
            this.sql = sql;
            this.whatColumns = whatColumns;
            this.mapMaker = mapMaker;
            this.whereColumns = whereColumns == null ? null : new ArrayList<Column>(whereColumns);
            this.opaqueColumns = opaqueColumns == null ? null : new ArrayList<Column>(opaqueColumns);
        }
    }

    protected class TableMaker {
        private final String tableName;
        private final Table table;
        private final String orderBy;

        protected TableMaker(String tableName) {
            this.tableName = tableName;
            this.table = SQLInfo.this.database.addTable(tableName);
            this.orderBy = SQLInfo.this.model.getCollectionOrderBy(tableName);
        }

        protected void newFragmentFields() {
            Map<String, ColumnType> keysType = SQLInfo.this.model.getFragmentKeysType(this.tableName);
            for (Map.Entry<String, ColumnType> entry : keysType.entrySet()) {
                this.newColumn(entry.getKey(), entry.getValue());
            }
        }

        protected Column newColumn(String key, ColumnType type) {
            String columnName = key;
            Column column = this.table.addColumn(columnName, type, key, SQLInfo.this.model);
            if (type == ColumnType.NODEID) {
                column.setNullable(false);
                column.setPrimary(true);
            }
            if (type == ColumnType.NODEIDFK || type == ColumnType.NODEIDPK) {
                column.setNullable(false);
                column.setPrimary(true);
            }
            if (type == ColumnType.NODEIDFKMUL) {
                column.setNullable(false);
                this.table.addIndex(key);
            }
            if (type == ColumnType.NODEIDFK || type == ColumnType.NODEIDFKNP || type == ColumnType.NODEIDFKNULL || type == ColumnType.NODEIDFKMUL) {
                Database database = SQLInfo.this.database;
                SQLInfo.this.model;
                Table table = database.getTable("hierarchy");
                SQLInfo.this.model;
                column.setReferences(table, "id");
            }
            return column;
        }

        protected void postProcessClusterInvalidations() {
            Column[] columnArray = new Column[3];
            SQLInfo.this.model;
            columnArray[0] = this.table.getColumn("id");
            SQLInfo.this.model;
            columnArray[1] = this.table.getColumn("fragments");
            SQLInfo.this.model;
            columnArray[2] = this.table.getColumn("kind");
            SQLInfo.this.clusterInvalidationsColumns = Arrays.asList(columnArray);
        }

        protected void postProcessRepository() {
            this.postProcessRootIdSelect();
            this.postProcessInsert();
        }

        protected void postProcessRootIdSelect() {
            String what = null;
            String where = null;
            for (Column column : this.table.getColumns()) {
                String key = column.getKey();
                String qname = column.getQuotedName();
                SQLInfo.this.model;
                if (key.equals("id")) {
                    what = qname;
                    SQLInfo.this.selectRootIdWhatColumn = column;
                    continue;
                }
                SQLInfo.this.model;
                if (key.equals("name")) {
                    where = qname + " = ?";
                    continue;
                }
                throw new RuntimeException(column.toString());
            }
            Select select = new Select(this.table);
            select.setWhat(what);
            select.setFrom(this.table.getQuotedName());
            select.setWhere(where);
            SQLInfo.this.selectRootIdSql = select.getStatement();
        }

        protected void postProcess() {
            this.postProcessSelectById();
            this.postProcessInsert();
            this.postProcessDelete();
            this.postProcessCopy();
        }

        protected void postProcessHierarchy() {
            this.postProcessSelectByChildNameAll();
            this.postProcessSelectByChildNamePropertiesFlag();
            this.postProcessSelectChildrenIdsAndTypes();
            this.postProcessCopyHier();
            String[] stringArray = new String[2];
            SQLInfo.this.model;
            stringArray[0] = "parentid";
            SQLInfo.this.model;
            stringArray[1] = "isproperty";
            SQLInfo.this.selectChildrenByIsProperty = SQLInfo.this.makeSelect(this.table, stringArray);
        }

        protected void postProcessSelectById() {
            String[] stringArray;
            if (this.orderBy == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.orderBy;
                stringArray = stringArray2;
                stringArray2[1] = SQLInfo.ORDER_ASC;
            }
            String[] orderBys = stringArray;
            String[] stringArray3 = new String[1];
            SQLInfo.this.model;
            stringArray3[0] = "id";
            SQLInfoSelect select = SQLInfo.this.makeSelect(this.table, orderBys, stringArray3);
            SQLInfo.this.selectFragmentById.put(this.tableName, select);
        }

        protected void postProcessSelectByChildNameAll() {
            ArrayList<Column> whatColumns = new ArrayList<Column>(3);
            ArrayList<String> whats = new ArrayList<String>(3);
            ArrayList<Column> whereColumns = new ArrayList<Column>(2);
            ArrayList<String> wheres = new ArrayList<String>(2);
            for (Column column : this.table.getColumns()) {
                String qname;
                block4: {
                    block3: {
                        String key = column.getKey();
                        qname = column.getQuotedName();
                        SQLInfo.this.model;
                        if (key.equals("parentid")) break block3;
                        SQLInfo.this.model;
                        if (!key.equals("name")) break block4;
                    }
                    wheres.add(qname + " = ?");
                    whereColumns.add(column);
                    continue;
                }
                whats.add(qname);
                whatColumns.add(column);
            }
            Select select = new Select(this.table);
            select.setWhat(StringUtils.join(whats, (String)", "));
            select.setFrom(this.table.getQuotedName());
            select.setWhere(StringUtils.join(wheres, (String)" AND "));
            SQLInfo.this.selectByChildNameAllSql = select.getStatement();
            SQLInfo.this.selectByChildNameAllWhatColumns = whatColumns;
            SQLInfo.this.selectByChildNameAllWhereColumns = whereColumns;
        }

        protected void postProcessSelectByChildNamePropertiesFlag() {
            ArrayList<Column> whatColumns = new ArrayList<Column>(3);
            ArrayList<String> whats = new ArrayList<String>(3);
            ArrayList<Column> whereColumns = new ArrayList<Column>(2);
            ArrayList<String> wheresProperties = new ArrayList<String>(2);
            ArrayList<String> wheresRegular = new ArrayList<String>(2);
            for (Column column : this.table.getColumns()) {
                String qname;
                String key;
                block6: {
                    block5: {
                        key = column.getKey();
                        qname = column.getQuotedName();
                        SQLInfo.this.model;
                        if (key.equals("parentid")) break block5;
                        SQLInfo.this.model;
                        if (!key.equals("name")) break block6;
                    }
                    wheresRegular.add(qname + " = ?");
                    wheresProperties.add(qname + " = ?");
                    whereColumns.add(column);
                    continue;
                }
                SQLInfo.this.model;
                if (key.equals("isproperty")) {
                    wheresRegular.add(qname + " = " + SQLInfo.this.dialect.toBooleanValueString(false));
                    wheresProperties.add(qname + " = " + SQLInfo.this.dialect.toBooleanValueString(true));
                    continue;
                }
                whats.add(qname);
                whatColumns.add(column);
            }
            Select select = new Select(this.table);
            select.setWhat(StringUtils.join(whats, (String)", "));
            select.setFrom(this.table.getQuotedName());
            select.setWhere(StringUtils.join(wheresRegular, (String)" AND "));
            SQLInfo.this.selectByChildNameRegularSql = select.getStatement();
            SQLInfo.this.selectByChildNameRegularWhatColumns = whatColumns;
            SQLInfo.this.selectByChildNameRegularWhereColumns = whereColumns;
            select.setWhere(StringUtils.join(wheresProperties, (String)" AND "));
            SQLInfo.this.selectByChildNamePropertiesSql = select.getStatement();
            SQLInfo.this.selectByChildNamePropertiesWhatColumns = whatColumns;
            SQLInfo.this.selectByChildNamePropertiesWhereColumns = whereColumns;
        }

        protected void postProcessSelectChildrenIdsAndTypes() {
            ArrayList<Column> whatColumns = new ArrayList<Column>(2);
            ArrayList<String> whats = new ArrayList<String>(2);
            SQLInfo.this.model;
            Column column = this.table.getColumn("id");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            SQLInfo.this.model;
            column = this.table.getColumn("primarytype");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            Select select = new Select(this.table);
            select.setWhat(StringUtils.join(whats, (String)", "));
            select.setFrom(this.table.getQuotedName());
            StringBuilder stringBuilder = new StringBuilder();
            SQLInfo.this.model;
            String where = stringBuilder.append(this.table.getColumn("parentid").getQuotedName()).append(" = ?").toString();
            select.setWhere(where);
            SQLInfo.this.selectChildrenIdsAndTypesSql = select.getStatement();
            SQLInfo.this.selectChildrenIdsAndTypesWhatColumns = whatColumns;
            StringBuilder stringBuilder2 = new StringBuilder().append(where).append(" AND ");
            SQLInfo.this.model;
            where = stringBuilder2.append(this.table.getColumn("isproperty").getQuotedName()).append(" = ").append(SQLInfo.this.dialect.toBooleanValueString(true)).toString();
            select.setWhere(where);
            SQLInfo.this.selectComplexChildrenIdsAndTypesSql = select.getStatement();
        }

        protected void postProcessInsert() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<Column> insertColumns = new ArrayList<Column>(columns.size());
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                if (column.isIdentity()) continue;
                insertColumns.add(column);
                insert.addColumn(column);
            }
            SQLInfo.this.insertSqlMap.put(this.tableName, insert.getStatement());
            SQLInfo.this.insertColumnsMap.put(this.tableName, insertColumns);
        }

        protected void postProcessDelete() {
            Delete delete = new Delete(this.table);
            LinkedList<String> wheres = new LinkedList<String>();
            for (Column column : this.table.getColumns()) {
                String string = column.getKey();
                SQLInfo.this.model;
                if (!string.equals("id")) continue;
                wheres.add(column.getQuotedName() + " = ?");
            }
            delete.setWhere(StringUtils.join(wheres, (String)" AND "));
            SQLInfo.this.deleteSqlMap.put(this.tableName, delete.getStatement());
        }

        protected void postProcessCopyHier() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<String> selectWhats = new ArrayList<String>(columns.size());
            ArrayList<String> selectWhatsExplicitName = new ArrayList<String>(columns.size());
            ArrayList<String> selectWhatsCreateVersion = new ArrayList<String>(columns.size());
            SQLInfo.this.copyHierColumns = new ArrayList(2);
            SQLInfo.this.copyHierColumnsExplicitName = new ArrayList(3);
            SQLInfo.this.copyHierColumnsCreateVersion = new ArrayList(3);
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                String quotedName;
                block11: {
                    block10: {
                        String key;
                        block9: {
                            block8: {
                                if (column.isIdentity()) continue;
                                insert.addColumn(column);
                                quotedName = column.getQuotedName();
                                key = column.getKey();
                                SQLInfo.this.model;
                                if (key.equals("id")) break block8;
                                SQLInfo.this.model;
                                if (!key.equals("parentid")) break block9;
                            }
                            selectWhats.add("?");
                            SQLInfo.this.copyHierColumns.add(column);
                            selectWhatsExplicitName.add("?");
                            SQLInfo.this.copyHierColumnsExplicitName.add(column);
                            selectWhatsCreateVersion.add("?");
                            SQLInfo.this.copyHierColumnsCreateVersion.add(column);
                            continue;
                        }
                        SQLInfo.this.model;
                        if (key.equals("name")) {
                            selectWhats.add(quotedName);
                            selectWhatsExplicitName.add("?");
                            SQLInfo.this.copyHierColumnsExplicitName.add(column);
                            selectWhatsCreateVersion.add(quotedName);
                            continue;
                        }
                        SQLInfo.this.model;
                        if (key.equals("baseversionid")) break block10;
                        SQLInfo.this.model;
                        if (!key.equals("ischeckedin")) break block11;
                    }
                    selectWhats.add(quotedName);
                    selectWhatsExplicitName.add(quotedName);
                    selectWhatsCreateVersion.add("?");
                    SQLInfo.this.copyHierColumnsCreateVersion.add(column);
                    continue;
                }
                selectWhats.add(quotedName);
                selectWhatsExplicitName.add(quotedName);
                selectWhatsCreateVersion.add(quotedName);
            }
            SQLInfo.this.model;
            SQLInfo.this.copyHierWhereColumn = this.table.getColumn("id");
            Select select = new Select(this.table);
            select.setFrom(this.table.getQuotedName());
            select.setWhere(SQLInfo.this.copyHierWhereColumn.getQuotedName() + " = ?");
            select.setWhat(StringUtils.join(selectWhats, (String)", "));
            insert.setValues(select.getStatement());
            SQLInfo.this.copyHierSql = insert.getStatement();
            select.setWhat(StringUtils.join(selectWhatsExplicitName, (String)", "));
            insert.setValues(select.getStatement());
            SQLInfo.this.copyHierSqlExplicitName = insert.getStatement();
            select.setWhat(StringUtils.join(selectWhatsCreateVersion, (String)", "));
            insert.setValues(select.getStatement());
            SQLInfo.this.copyHierSqlCreateVersion = insert.getStatement();
        }

        protected void postProcessCopy() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<String> selectWhats = new ArrayList<String>(columns.size());
            SQLInfo.this.model;
            Column copyIdColumn = this.table.getColumn("id");
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                if (column.isIdentity()) continue;
                insert.addColumn(column);
                if (column == copyIdColumn) {
                    selectWhats.add("?");
                    continue;
                }
                selectWhats.add(column.getQuotedName());
            }
            Select select = new Select(this.table);
            select.setWhat(StringUtils.join(selectWhats, (String)", "));
            select.setFrom(this.table.getQuotedName());
            select.setWhere(copyIdColumn.getQuotedName() + " = ?");
            insert.setValues(select.getStatement());
            SQLInfo.this.copySqlMap.put(this.tableName, insert.getStatement());
            SQLInfo.this.copyIdColumnMap.put(this.tableName, copyIdColumn);
        }
    }
}

