/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;

public class Update
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Table table;
    protected String newValues;
    protected String[] from;
    protected String where;

    public Update(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setNewValues(String newValues) {
        this.newValues = newValues;
    }

    public void setFrom(String ... from) {
        this.from = from;
    }

    public void setWhere(String where) {
        if (where == null || where.length() == 0) {
            throw new IllegalArgumentException("unexpected empty WHERE");
        }
        this.where = where;
    }

    public String getStatement() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("UPDATE ");
        buf.append(this.table.getQuotedName());
        buf.append(" SET ");
        buf.append(this.newValues);
        if (this.from != null) {
            buf.append(" FROM ");
            if (this.table.getDialect().doesUpdateFromRepeatSelf()) {
                buf.append(this.table.getQuotedName());
                buf.append(", ");
            }
            buf.append(StringUtils.join((Object[])this.from, (String)", "));
        }
        if (this.where == null) {
            throw new IllegalArgumentException("unexpected empty WHERE");
        }
        buf.append(" WHERE ");
        buf.append(this.where);
        return buf.toString();
    }
}

