/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelFulltext;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectOracle
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectOracle.class);
    protected final String fulltextParameters;
    private static boolean initialized;
    private static Constructor<?> arrayDescriptorConstructor;
    private static Constructor<?> arrayConstructor;

    public DialectOracle(DatabaseMetaData metadata, BinaryManager binaryManager, RepositoryDescriptor repositoryDescriptor) throws StorageException {
        super(metadata, binaryManager, repositoryDescriptor);
        this.fulltextParameters = repositoryDescriptor.fulltextAnalyzer == null ? "" : repositoryDescriptor.fulltextAnalyzer;
    }

    @Override
    public String getConnectionSchema(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
        log.trace((Object)("SQL: " + sql));
        ResultSet rs = st.executeQuery(sql);
        rs.next();
        String user = rs.getString(1);
        log.trace((Object)("SQL:   -> " + user));
        st.close();
        return user;
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return " CASCADE CONSTRAINTS";
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type) {
            case VARCHAR: {
                return this.jdbcInfo("NVARCHAR2(2000)", 12);
            }
            case CLOB: {
                return this.jdbcInfo("NCLOB", 2005);
            }
            case BOOLEAN: {
                return this.jdbcInfo("NUMBER(1,0)", -7);
            }
            case LONG: {
                return this.jdbcInfo("NUMBER(19,0)", -5);
            }
            case DOUBLE: {
                return this.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return this.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return this.jdbcInfo("VARCHAR2(40)", 12);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return this.jdbcInfo("VARCHAR2(36)", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return this.jdbcInfo("VARCHAR2(250)", 12);
            }
            case TINYINT: {
                return this.jdbcInfo("NUMBER(3,0)", -6);
            }
            case INTEGER: {
                return this.jdbcInfo("NUMBER(10,0)", 4);
            }
            case FTINDEXED: {
                return this.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return this.jdbcInfo("NCLOB", 2005);
            }
            case CLUSTERNODE: {
                return this.jdbcInfo("NUMBER(10,0)", 4);
            }
            case CLUSTERFRAGS: {
                return this.jdbcInfo("VARCHAR2(4000)", 12);
            }
        }
        throw new AssertionError((Object)type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 8 && actual == 6) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NVARCHAR2")) {
            return true;
        }
        if (expected == 2005 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        if (expected == -7 && actual == 3 && actualName.equals("NUMBER") && actualSize == 1) {
            return true;
        }
        if (expected == -6 && actual == 3 && actualName.equals("NUMBER") && actualSize == 3) {
            return true;
        }
        if (expected == 4 && actual == 3 && actualName.equals("NUMBER") && actualSize == 10) {
            return true;
        }
        if (expected == -5 && actual == 3 && actualName.equals("NUMBER") && actualSize == 19) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        return expected == 2005 && actual == 1111 && actualName.equals("NVARCHAR2");
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, (Long)value);
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: {
                return this.getFromResultSetString(rs, index, column);
            }
            case 2005: {
                Reader r = rs.getCharacterStream(index);
                if (r == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                try {
                    int n;
                    char[] buffer = new char[4096];
                    while ((n = r.read(buffer)) != -1) {
                        sb.append(new String(buffer, 0, n));
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read CLOB", (Throwable)e);
                }
                return sb.toString();
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 30;
    }

    @Override
    protected int getMaxIndexNameSize() {
        return 25;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        return String.format("CREATE INDEX %s ON %s(%s) INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('%s SYNC (ON COMMIT) TRANSACTIONAL')", quotedIndexName, table.getQuotedName(), columns.get(0).getQuotedName(), this.fulltextParameters);
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        Dialect.FulltextQuery ft = DialectOracle.analyzeFulltextQuery(query = query.replace("*", "%"));
        if (ft == null) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        return DialectOracle.translateFulltext(ft, "OR", "AND", "NOT", "");
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String indexSuffix = model.getFulltextIndexSuffix(indexName);
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column ftColumn = ft.getColumn("fulltext" + indexSuffix);
        String score = String.format("SCORE(%d)", nthMatch);
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        if (nthMatch == 1) {
            info.joins = Collections.singletonList(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.whereExpr = String.format("CONTAINS(%s, ?, %d) > 0", ftColumn.getFullQuotedName(), nthMatch);
        info.whereExprParam = fulltextQuery;
        info.scoreExpr = String.format("%s / 100", score);
        info.scoreAlias = score;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public boolean supportsUpdateFrom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsOriginalColumnInGroupBy() {
        return true;
    }

    @Override
    public boolean needsOracleJoins() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS NVARCHAR2(%d))";
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getReadAclsCheckSql(String idColumnName) {
        return String.format("%s IN (SELECT COLUMN_VALUE FROM TABLE(nx_get_read_acls_for(?)))", idColumnName);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "{CALL nx_update_read_acls}";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "{CALL nx_rebuild_read_acls}";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName) {
        return String.format("NX_IN_TREE(%s, ?) = 1", idColumnName);
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public boolean isClusteringDeleteNeeded() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "{CALL NX_CLUSTER_INVAL(?, ?, ?)}";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT id, fragments, kind FROM cluster_invals WHERE nodeid = SYS_CONTEXT('USERENV','SID')";
    }

    @Override
    public String getClusterDeleteInvalidations() {
        return "DELETE FROM cluster_invals WHERE nodeid = SYS_CONTEXT('USERENV','SID')";
    }

    @Override
    public boolean supportsWith() {
        return false;
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    private static void init() throws SQLException {
        if (!initialized) {
            try {
                Class<?> arrayDescriptorClass = Class.forName("oracle.sql.ArrayDescriptor");
                arrayDescriptorConstructor = arrayDescriptorClass.getConstructor(String.class, Connection.class);
                Class<?> arrayClass = Class.forName("oracle.sql.ARRAY");
                arrayConstructor = arrayClass.getConstructor(arrayDescriptorClass, Connection.class, Object.class);
            }
            catch (Exception e) {
                throw new SQLException(e.toString());
            }
            initialized = true;
        }
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        if (elements == null || elements.length == 0) {
            return null;
        }
        DialectOracle.init();
        try {
            Object arrayDescriptor = arrayDescriptorConstructor.newInstance("NX_STRING_TABLE", connection);
            return (Array)arrayConstructor.newInstance(arrayDescriptor, connection, elements);
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/oracle.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/oracle.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"VARCHAR2(36)"));
        properties.put("argIdType", (Serializable)((Object)"VARCHAR2"));
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        if (!this.fulltextDisabled) {
            Table ft = database.getTable("fulltext");
            properties.put("fulltextTable", (Serializable)((Object)ft.getQuotedName()));
            ModelFulltext fti = model.getFulltextInfo();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String line = String.format("  :NEW.%s := :NEW.%s || :NEW.%s; ", ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            properties.put("fulltextTriggerStatements", (Serializable)((Object)StringUtils.join(lines, (String)"\n")));
        }
        String[] permissions = NXCore.getSecurityService().getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add(String.format("  INTO READ_ACL_PERMISSIONS VALUES ('%s')", perm));
        }
        properties.put("readPermissions", (Serializable)((Object)StringUtils.join(permsList, (String)"\n")));
        return properties;
    }

    @Override
    public boolean connectionClosedByException(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof SocketException) {
            return true;
        }
        Integer err = 0;
        try {
            Method m = t.getClass().getMethod("getOracleError", new Class[0]);
            err = (Integer)m.invoke((Object)t, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (err) {
            case 17002: {
                return true;
            }
        }
        return false;
    }
}

