/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.seam;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.jboss.seam.excel.ExcelWorkbook;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.UIWorksheet;
import org.jboss.seam.excel.ui.command.Command;

public class UIColumn
extends org.jboss.seam.excel.ui.UIColumn {
    public static final String COMPONENT_TYPE = UIColumn.class.getName();
    public static final String FOOTER_FACET_NAME = "footer";

    public void encodeBegin(FacesContext facesContext) throws IOException {
        ExcelWorkbook excelWorkbook = this.getWorkbook(this.getParent());
        if (excelWorkbook == null) {
            throw new ExcelWorkbookException("Could not find excel workbook");
        }
        excelWorkbook.applyColumnSettings((org.jboss.seam.excel.ui.UIColumn)this);
        UIWorksheet sheet = (UIWorksheet)this.getParentByClass(this.getParent(), UIWorksheet.class);
        if (sheet == null) {
            throw new ExcelWorkbookException("Could not find worksheet");
        }
        WorksheetItem headerItem = (WorksheetItem)this.getFacet("header");
        if (headerItem != null) {
            excelWorkbook.addItem(headerItem);
        }
        List<Command> commands = UIColumn.getCommands(this.getChildren());
        for (Command command : commands) {
            excelWorkbook.executeCommand(command);
        }
        for (UIComponent child : this.getChildren()) {
            this.encodeChild(facesContext, sheet, excelWorkbook, child);
        }
        WorksheetItem footerItem = (WorksheetItem)this.getFacet(FOOTER_FACET_NAME);
        if (footerItem != null) {
            excelWorkbook.addItem(footerItem);
        }
        excelWorkbook.nextColumn();
    }

    protected void encodeChild(FacesContext facesContext, UIWorksheet sheet, ExcelWorkbook excelWorkbook, UIComponent child) throws IOException {
        Object oldValue = null;
        Iterator iterator = null;
        if (sheet.getVar() != null) {
            oldValue = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(sheet.getVar());
            iterator = sheet.getDataIterator();
        } else {
            iterator = new ArrayList().iterator();
        }
        while (iterator.hasNext()) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(sheet.getVar(), iterator.next());
            if (child instanceof WorksheetItem) {
                excelWorkbook.addItem((WorksheetItem)child);
                continue;
            }
            if (!child.isRendered()) continue;
            child.encodeBegin(facesContext);
            List subChildren = child.getChildren();
            int size = child.getChildCount();
            for (int j = 0; j < size; ++j) {
                UIComponent subChild = (UIComponent)subChildren.get(j);
                this.encodeChild(facesContext, sheet, excelWorkbook, subChild);
            }
            child.encodeEnd(facesContext);
        }
        if (sheet.getVar() == null) {
            return;
        }
        if (oldValue == null) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(sheet.getVar());
        } else {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(sheet.getVar(), oldValue);
        }
    }

    public static <T> List<T> getAllChildrenOfType(List<UIComponent> children, Class<T> childType) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (UIComponent child : children) {
            if (childType.isAssignableFrom(child.getClass())) {
                matches.add(child);
                continue;
            }
            List<T> subChildren = UIColumn.getAllChildrenOfType(child.getChildren(), childType);
            if (subChildren == null || subChildren.isEmpty()) continue;
            matches.addAll(subChildren);
        }
        return matches;
    }

    protected static List<Command> getCommands(List<UIComponent> children) {
        return UIColumn.getAllChildrenOfType(children, Command.class);
    }
}

