/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.component.UISelectItems;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.SelectItemComparator;

public class UIDirectorySelectItems
extends UISelectItems {
    private static final Log log = LogFactory.getLog(UIDirectorySelectItems.class);
    public static final String COMPONENT_TYPE = UIDirectorySelectItems.class.getName();
    protected String directoryName;
    protected SelectItem[] allValues;
    protected Boolean displayAll;
    protected Boolean displayObsoleteEntries;

    public String getDirectoryName() {
        if (this.directoryName != null) {
            return this.directoryName;
        }
        ValueExpression ve = this.getValueExpression("directoryName");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public Boolean getDisplayAll() {
        if (this.displayAll != null) {
            return this.displayAll;
        }
        ValueExpression ve = this.getValueExpression("displayAll");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return true;
    }

    public void setDisplayAll(Boolean displayAll) {
        this.displayAll = displayAll;
    }

    public Boolean getDisplayObsoleteEntries() {
        if (this.displayObsoleteEntries != null) {
            return this.displayObsoleteEntries;
        }
        ValueExpression ve = this.getValueExpression("displayObsoleteEntries");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setDisplayObsoleteEntries(Boolean displayObsoleteEntries) {
        this.displayObsoleteEntries = displayObsoleteEntries;
    }

    protected Session getDirectorySession() {
        String dirName = this.getDirectoryName();
        Session directorySession = null;
        if (dirName != null) {
            try {
                DirectoryService service = DirectoryHelper.getDirectoryService();
                directorySession = service.open(dirName);
            }
            catch (Exception e) {
                log.error((Object)String.format("Error when retrieving directory %s", dirName), (Throwable)e);
            }
        }
        return directorySession;
    }

    protected void closeDirectorySession(Session directorySession) {
        if (directorySession != null) {
            try {
                directorySession.close();
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getValue() {
        Boolean showAll = this.getDisplayAll();
        if (showAll.booleanValue()) {
            if (this.allValues == null) {
                this.allValues = this.createAllSelectItems();
            }
            return this.allValues;
        }
        Object value = super.getValue();
        return this.createSelectItems(value);
    }

    @Override
    protected SelectItem[] createSelectItems(Object value) {
        if (value instanceof SelectItem[]) {
            return (SelectItem[])value;
        }
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        Session directorySession = this.getDirectorySession();
        if (directorySession != null) {
            DocumentModel entry;
            if (value instanceof ListDataModel) {
                ListDataModel ldm = (ListDataModel)value;
                List entryIds = (List)ldm.getWrappedData();
                DocumentModel entry2 = null;
                for (String entryId : entryIds) {
                    try {
                        entry2 = directorySession.getEntry(entryId);
                        if (entry2 == null) continue;
                        this.putIteratorToRequestParam(entry2);
                        SelectItem selectItem = this.createSelectItem();
                        this.removeIteratorFromRequestParam();
                        items.add(selectItem);
                    }
                    catch (DirectoryException e) {}
                }
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object currentItem : collection) {
                    if (currentItem instanceof SelectItemGroup) {
                        SelectItemGroup itemGroup = (SelectItemGroup)currentItem;
                        SelectItem[] itemsFromGroup = itemGroup.getSelectItems();
                        items.addAll(Arrays.asList(itemsFromGroup));
                        continue;
                    }
                    if (!(currentItem instanceof String)) continue;
                    try {
                        entry = directorySession.getEntry((String)currentItem);
                        if (entry == null) continue;
                        this.putIteratorToRequestParam(entry);
                        SelectItem selectItem = this.createSelectItem();
                        this.removeIteratorFromRequestParam();
                        items.add(selectItem);
                    }
                    catch (DirectoryException e) {}
                }
            } else if (value instanceof String[]) {
                String[] entryIds = (String[])value;
                entry = null;
                for (String entryId : entryIds) {
                    try {
                        entry = directorySession.getEntry(entryId);
                        if (entry == null) continue;
                        this.putIteratorToRequestParam(entry);
                        SelectItem selectItem = this.createSelectItem();
                        this.removeIteratorFromRequestParam();
                        items.add(selectItem);
                    }
                    catch (DirectoryException e) {
                        // empty catch block
                    }
                }
            }
        } else {
            log.error((Object)"No session provided for directory, returning empty selection");
        }
        this.closeDirectorySession(directorySession);
        String ordering = this.getOrdering();
        Boolean caseSensitive = this.getCaseSensitive();
        if (ordering != null && !"".equals(ordering)) {
            Collections.sort(items, new SelectItemComparator(ordering, caseSensitive));
        }
        return items.toArray(new SelectItem[0]);
    }

    protected SelectItem[] createAllSelectItems() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        Session directorySession = this.getDirectorySession();
        if (directorySession != null) {
            try {
                HashMap<String, Integer> filter = new HashMap<String, Integer>();
                if (!this.getDisplayObsoleteEntries().booleanValue()) {
                    filter.put("obsolete", 0);
                }
                DocumentModelList entries = directorySession.query(filter);
                for (DocumentModel entry : entries) {
                    if (entry == null) continue;
                    this.putIteratorToRequestParam(entry);
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    items.add(selectItem);
                }
            }
            catch (ClientException e) {}
        } else {
            log.error((Object)"No session provided for directory, returning empty selection");
        }
        this.closeDirectorySession(directorySession);
        String ordering = this.getOrdering();
        Boolean caseSensitive = this.getCaseSensitive();
        if (ordering != null && !"".equals(ordering)) {
            Collections.sort(items, new SelectItemComparator(ordering, caseSensitive));
        }
        return items.toArray(new SelectItem[0]);
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.directoryName, this.displayAll, this.allValues, this.displayObsoleteEntries};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.directoryName = (String)values[1];
        this.displayAll = (Boolean)values[2];
        this.allValues = (SelectItem[])values[3];
        this.displayObsoleteEntries = (Boolean)values[4];
    }
}

