/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ListenerDescriptor;

@XObject(value="listeners")
public class ListenerSetDescriptor {
    @XNodeList(value="listener", type=ArrayList.class, componentType=ListenerDescriptor.class, trim=true, nullByDefault=false)
    protected ArrayList<ListenerDescriptor> listenerDescriptors;
    private ServletContextListener[] listeners;
    private int cnt = 0;

    public synchronized boolean isInitialized() {
        return this.cnt > 0;
    }

    public synchronized void init(ServletConfig config) throws Exception {
        ++this.cnt;
        if (this.cnt == 1) {
            ServletContextEvent event = new ServletContextEvent(config.getServletContext());
            this.listeners = new ServletContextListener[this.listenerDescriptors.size()];
            for (int i = 0; i < this.listeners.length; ++i) {
                ListenerDescriptor ld = this.listenerDescriptors.get(i);
                this.listeners[i] = ld.getListener();
                this.listeners[i].contextInitialized(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean destroy(ServletConfig config) {
        if (this.cnt <= 0) {
            return false;
        }
        --this.cnt;
        if (this.cnt == 0 && this.listeners != null) {
            try {
                ServletContextEvent event = new ServletContextEvent(config.getServletContext());
                for (ServletContextListener listener : this.listeners) {
                    listener.contextDestroyed(event);
                }
            }
            finally {
                this.listeners = null;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.listenerDescriptors.toString();
    }
}

