/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.webengine.jaxrs.Utils;
import org.nuxeo.ecm.webengine.jaxrs.servlet.ServletHolder;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterSetDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class ServletRegistry {
    public static final String SERVLET_NAME = ServletRegistry.class.getName() + ".name";
    private static volatile ServletRegistry instance;
    protected List<ServletDescriptor> servlets = new ArrayList<ServletDescriptor>();
    protected List<FilterSetDescriptor> filters = new ArrayList<FilterSetDescriptor>();
    protected HttpService service;
    protected Bundle bundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServletRegistry getInstance() {
        ServletRegistry reg = instance;
        if (reg != null) return reg;
        Class<ServletRegistry> clazz = ServletRegistry.class;
        synchronized (ServletRegistry.class) {
            instance = reg = new ServletRegistry();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return reg;
        }
    }

    public static synchronized void dispose() {
        instance = null;
    }

    private ServletRegistry() {
    }

    public synchronized ServletDescriptor[] getServletDescriptors() {
        return this.servlets.toArray(new ServletDescriptor[this.servlets.size()]);
    }

    public synchronized FilterSetDescriptor[] getFilterSetDescriptors() {
        return this.filters.toArray(new FilterSetDescriptor[this.filters.size()]);
    }

    public ServletDescriptor getServletDescriptor(String name) {
        for (ServletDescriptor servlet : this.getServletDescriptors()) {
            if (!name.equals(servlet.name)) continue;
            return servlet;
        }
        return null;
    }

    public List<FilterSetDescriptor> getFiltersFor(String name) {
        ArrayList<FilterSetDescriptor> list = new ArrayList<FilterSetDescriptor>();
        for (FilterSetDescriptor filter : this.getFilterSetDescriptors()) {
            if (!name.equals(filter.targetServlet)) continue;
            list.add(filter);
        }
        return list;
    }

    public synchronized void initHttpService(HttpService service) throws Exception {
        if (this.service == null) {
            this.service = service;
            this.installServlets();
        }
    }

    public HttpService getHttpService() {
        return this.service;
    }

    protected HttpContext getHttpContext(Bundle bundle) {
        return new BundleHttpContext(bundle);
    }

    public synchronized void addServlet(ServletDescriptor descriptor) throws Exception {
        this.servlets.add(descriptor);
        this.installServlet(descriptor);
    }

    public synchronized void removeServlet(ServletDescriptor descriptor) {
        this.servlets.remove(descriptor);
        if (this.service != null) {
            this.service.unregister(descriptor.path);
        }
    }

    public synchronized void addFilterSet(FilterSetDescriptor filter) {
        this.filters.add(filter);
    }

    public synchronized void removeFilterSet(FilterSetDescriptor filter) {
        this.filters.remove(filter);
    }

    private synchronized void installServlets() throws Exception {
        if (this.service != null) {
            for (ServletDescriptor sd : this.servlets) {
                this.installServlet(sd);
            }
        }
    }

    private void installServlet(ServletDescriptor sd) throws Exception {
        if (this.service != null) {
            Utils.ClassRef ref = sd.getClassRef();
            HttpContext ctx = this.getHttpContext(ref.bundle());
            Hashtable<String, String> params = new Hashtable<String, String>();
            if (sd.name != null) {
                params.put(SERVLET_NAME, sd.name);
            }
            this.service.registerServlet(sd.path, (Servlet)new ServletHolder(), params, ctx);
        }
    }

    static class BundleHttpContext
    implements HttpContext {
        Bundle bundle;

        public BundleHttpContext(Bundle bundle) {
            this.bundle = bundle;
        }

        public String getMimeType(String name) {
            return null;
        }

        public URL getResource(String name) {
            return null;
        }

        public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
            return true;
        }
    }
}

