/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.views;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.webengine.jaxrs.views.ViewNotFoundException;

public abstract class View {
    protected Object owner;
    protected final URL url;
    protected final Map<String, Object> vars = new HashMap<String, Object>();

    public static URL resolveFile(File file) throws ViewNotFoundException {
        if (!file.isFile()) {
            throw new ViewNotFoundException(null, null, file.getAbsolutePath());
        }
        try {
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw new ViewNotFoundException(e, null, file.getAbsolutePath());
        }
    }

    public static URL resolveResource(Object owner, String name) throws ViewNotFoundException {
        URL url = owner.getClass().getResource(name);
        if (url == null) {
            throw new ViewNotFoundException(null, owner, name);
        }
        return url;
    }

    protected View(Object owner, String name) {
        this(owner, View.resolveResource(owner, name));
    }

    protected View(File file) {
        this(null, file);
    }

    protected View(Object owner, File file) {
        this(owner, View.resolveFile(file));
    }

    protected View(URL url) {
        this(null, url);
    }

    protected View(Object owner, URL url) {
        this.url = url;
        if (owner != null) {
            this.forObject(owner);
        }
    }

    public View forObject(Object owner) {
        this.owner = owner;
        this.vars.put("This", owner);
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public Object getOwner() {
        return this.owner;
    }

    public View arg(String key, Object value) {
        this.vars.put(key, value);
        return this;
    }

    public abstract void render(Writer var1) throws Exception;

    public abstract void render(OutputStream var1) throws Exception;
}

