/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.impl.task.CommandsTask;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;

public class InstallTask
extends CommandsTask {
    @Override
    public boolean isInstallTask() {
        return true;
    }

    @Override
    protected File getCommandsFile() throws PackageException {
        return this.pkg.getInstallFile();
    }

    @Override
    protected void doRun(Map<String, String> params) throws PackageException {
        super.doRun(params);
        File file = this.pkg.getData().getEntry("uninstall.xml");
        this.writeLog(file);
        InstallTask.reloadComponents(this.getPackage());
    }

    @Override
    protected void rollbackDone() throws PackageException {
        PackageUpdateService service = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        service.setPackageState(this.pkg, 2);
    }

    @Override
    protected void taskDone() throws PackageException {
        PackageUpdateService service = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        if (this.isRestartRequired()) {
            service.setPackageState(this.pkg, 4);
        } else {
            service.setPackageState(this.pkg, 5);
        }
    }

    public static void reloadComponents(LocalPackage pkg) throws PackageException {
        File file = pkg.getData().getEntry("reload");
        if (file.isFile()) {
            try {
                List lines = FileUtils.readLines((File)file);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                    InstallTask.reloadComponent(line);
                }
            }
            catch (IOException e) {
                throw new PackageException("Failed to read the 'reload' file", (Throwable)e);
            }
        }
    }

    public static void reloadComponent(String name) throws PackageException {
        try {
            RegistrationInfoImpl ri = (RegistrationInfoImpl)Framework.getRuntime().getComponentManager().getRegistrationInfo(new ComponentName(name));
            if (ri != null) {
                ri.reload();
            }
        }
        catch (Exception e) {
            throw new PackageException("Failed to reload component: " + name, (Throwable)e);
        }
    }
}

