/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.javasimon.Callback;
import org.javasimon.SimonManager;
import org.javasimon.jdbc.SimonConnection;
import org.javasimon.jdbc.logging.LoggingCallback;

public final class Driver
implements java.sql.Driver {
    public static final String REAL_DRIVER = "simon_real_drv";
    public static final String DEFAULT_PREFIX = "org.javasimon.jdbc";
    public static final String PREFIX = "simon_prefix";
    private static final String LOGFILE = "simon_logfile";
    private static final String LOGGER = "simon_logger";
    private static final String CONSOLE = "simon_console";
    private static final String FORMAT = "simon_format";
    private final Properties drivers = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver() {
        try {
            InputStream stream = null;
            try {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/javasimon/jdbc/drivers.properties");
                this.drivers.load(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Connection connect(String simonUrl, Properties info) throws SQLException {
        if (!this.acceptsURL(simonUrl)) {
            return null;
        }
        Url url = new Url(simonUrl);
        java.sql.Driver driver = this.getRealDriver(url, info);
        if (url.getLogfile() != null || url.getLogger() != null || url.getConsole()) {
            LoggingCallback loggingCallback = null;
            for (Callback c : SimonManager.callback().callbacks()) {
                if (!(c instanceof LoggingCallback)) continue;
                loggingCallback = (LoggingCallback)c;
                break;
            }
            if (loggingCallback == null) {
                this.registerLoggingCallback(url);
            }
        }
        return new SimonConnection(driver.connect(url.getRealUrl(), info), url.getPrefix());
    }

    private void registerLoggingCallback(Url url) {
        LoggingCallback loggingCallback = new LoggingCallback();
        loggingCallback.setPrefix(url.getPrefix());
        if (url.getLogfile() != null) {
            loggingCallback.setLogFilename(url.getLogfile());
        }
        if (url.getLogger() != null) {
            loggingCallback.setLoggerName(url.getLogger());
        }
        if (url.getConsole()) {
            loggingCallback.setLogToConsole();
        }
        if (url.getFormat() != null) {
            loggingCallback.setLogFormat(url.getFormat());
        }
        SimonManager.callback().addCallback((Callback)loggingCallback);
    }

    private java.sql.Driver getRealDriver(Url url, Properties info) throws SQLException {
        java.sql.Driver drv = null;
        try {
            drv = DriverManager.getDriver(url.getRealUrl());
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (drv == null && info != null && info.keySet().contains(REAL_DRIVER)) {
            drv = this.registerDriver(info.getProperty(REAL_DRIVER));
        }
        if (drv == null && url.getDriverId() != null) {
            drv = this.registerDriver(this.drivers.getProperty(url.getDriverId()));
        }
        if (drv == null && url.getRealDriver() != null) {
            drv = this.registerDriver(url.getRealDriver());
        }
        if (drv == null) {
            throw new SQLException("Real driver is not registered and can't determine real driver class name for registration.");
        }
        return drv;
    }

    private java.sql.Driver registerDriver(String name) throws SQLException {
        try {
            java.sql.Driver d = (java.sql.Driver)Class.forName(name).newInstance();
            DriverManager.registerDriver(d);
            return d;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.toLowerCase().startsWith("jdbc:simon");
    }

    public DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static class Url {
        private static final String SIMON_JDBC = "jdbc:simon";
        private static final int JDBC_URL_FIXED_PREFIX_LEN = 5;
        private String realUrl;
        private String driverId;
        private String realDriver;
        private String prefix;
        private String logfile;
        private String logger;
        private String console;
        private String format;

        Url(String url) {
            int i = url.indexOf(58, 5);
            if (i > -1) {
                this.driverId = url.substring(5, i - 1);
            }
            StringTokenizer st = new StringTokenizer(url, ";");
            while (st.hasMoreTokens()) {
                String tokenValue;
                String tokenPairStr = st.nextToken().trim();
                String[] tokenPair = tokenPairStr.split("=", 2);
                String token = tokenPair[0];
                String string = tokenValue = tokenPair.length == 2 ? tokenPair[1].trim() : null;
                if (tokenPairStr.startsWith("jdbc")) {
                    this.realUrl = tokenPairStr.replaceFirst(SIMON_JDBC, "jdbc");
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.REAL_DRIVER)) {
                    this.realDriver = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.PREFIX)) {
                    this.prefix = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.LOGFILE)) {
                    this.logfile = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.LOGGER)) {
                    this.logger = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.CONSOLE)) {
                    this.console = tokenValue;
                    continue;
                }
                if (token.equalsIgnoreCase(Driver.FORMAT)) {
                    this.format = tokenValue;
                    continue;
                }
                this.realUrl = this.realUrl + ";" + tokenPairStr;
            }
        }

        public String getRealUrl() {
            return this.realUrl;
        }

        public String getDriverId() {
            return this.driverId;
        }

        public String getRealDriver() {
            return this.realDriver;
        }

        public String getPrefix() {
            return this.prefix == null ? Driver.DEFAULT_PREFIX : this.prefix;
        }

        public String getLogfile() {
            return this.logfile;
        }

        public String getLogger() {
            return this.logger;
        }

        public boolean getConsole() {
            return this.console != null && (this.console.equalsIgnoreCase("yes") || this.console.equalsIgnoreCase("y") || this.console.equalsIgnoreCase("true") || this.console.equalsIgnoreCase("t") || this.console.equalsIgnoreCase("1"));
        }

        public String getFormat() {
            return this.format;
        }
    }
}

