/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;

public class PrincipalWrapper
extends HashMap<String, Serializable> {
    protected NuxeoPrincipal principal;

    public PrincipalWrapper(NuxeoPrincipal principal) {
        this.principal = principal;
    }

    public String getName() {
        return this.principal.getName();
    }

    public String getCompany() {
        return this.principal.getCompany();
    }

    public String getFirstName() {
        return this.principal.getFirstName();
    }

    public String getLastName() {
        return this.principal.getLastName();
    }

    public String getOriginatingUser() {
        return this.principal.getOriginatingUser();
    }

    public List<String> getAllGroups() {
        return this.principal.getAllGroups();
    }

    public List<String> getGroups() {
        return this.principal.getGroups();
    }

    public String getEmail() throws Exception {
        return this.principal.getEmail();
    }

    public NuxeoPrincipal getPrincipal() {
        return this.principal;
    }

    public Serializable getProperty(String xpath) {
        try {
            return this.principal.getModel().getPropertyValue(xpath);
        }
        catch (ClientException e) {
            throw new RuntimeException("Principal property not found: " + xpath, e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.getProperty(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.getProperty(value.toString()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Serializable get(Object key) {
        try {
            return this.getProperty(key.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Collection<Serializable> values() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Set<Map.Entry<String, Serializable>> entrySet() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public Serializable put(String key, Serializable value) {
        try {
            Property p = this.principal.getModel().getProperty(key);
            Serializable v = p.getValue();
            p.setValue((Object)value);
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Serializable> m) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public Serializable remove(Object key) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read Only Map.");
    }
}

