/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common;

import java.io.File;
import java.util.Map;
import java.util.Properties;

public class Environment {
    public static final String JBOSS_HOST = "JBoss";
    public static final String NXSERVER_HOST = "NXServer";
    public static final String TOMCAT_HOST = "Tomcat";
    public static final String NUXEO_HOME_DIR = "nuxeo.home.dir";
    public static final String NUXEO_DATA_DIR = "nuxeo.data.dir";
    public static final String NUXEO_LOG_DIR = "nuxeo.log.dir";
    public static final String NUXEO_TMP_DIR = "nuxeo.tmp.dir";
    public static final String NUXEO_CONFIG_DIR = "nuxeo.config.dir";
    public static final String NUXEO_WEB_DIR = "nuxeo.web.dir";
    @Deprecated
    public static final String HOME_DIR = "org.nuxeo.app.home";
    @Deprecated
    public static final String WEB_DIR = "org.nuxeo.app.web";
    @Deprecated
    public static final String CONFIG_DIR = "org.nuxeo.app.config";
    @Deprecated
    public static final String DATA_DIR = "org.nuxeo.app.data";
    @Deprecated
    public static final String LOG_DIR = "org.nuxeo.app.log";
    public static final String BUNDLES_DIR = "nuxeo.osgi.app.bundles";
    public static final String BUNDLES = "nuxeo.osgi.bundles";
    private static volatile Environment DEFAULT;
    protected final File home;
    protected File data;
    protected File log;
    protected File config;
    protected File web;
    protected File temp;
    protected final Properties properties;
    protected String[] args;
    protected boolean isAppServer;
    protected String hostAppName;
    protected String hostAppVersion;

    public Environment(File home) {
        this(home, null);
    }

    public Environment(File home, Properties properties) {
        this.home = home;
        this.properties = new Properties();
        if (properties != null) {
            this.loadProperties(properties);
        }
        this.properties.put(HOME_DIR, this.home.getAbsolutePath());
    }

    public static synchronized void setDefault(Environment env) {
        DEFAULT = env;
    }

    public static Environment getDefault() {
        if (DEFAULT == null) {
            Environment.tryInitEnvironment();
        }
        return DEFAULT;
    }

    private static synchronized void tryInitEnvironment() {
        File home;
        String homeDir = System.getProperty("nuxeo.home");
        if (homeDir != null && (home = new File(homeDir)).isDirectory()) {
            DEFAULT = new Environment(home);
        }
    }

    public File getHome() {
        return this.home;
    }

    public boolean isApplicationServer() {
        return this.isAppServer;
    }

    public void setIsApplicationServer(boolean isAppServer) {
        this.isAppServer = isAppServer;
    }

    public String getHostApplicationName() {
        return this.hostAppName;
    }

    public String getHostApplicationVersion() {
        return this.hostAppVersion;
    }

    public void setHostApplicationName(String name) {
        this.hostAppName = name;
    }

    public void setHostApplicationVersion(String version) {
        this.hostAppVersion = version;
    }

    public File getTemp() {
        if (this.temp == null) {
            this.temp = new File(this.home, "tmp");
        }
        return this.temp;
    }

    public void setTemp(File temp) {
        this.temp = temp;
        this.properties.put(NUXEO_TMP_DIR, temp.getAbsolutePath());
    }

    public File getConfig() {
        if (this.config == null) {
            this.config = new File(this.home, "config");
        }
        return this.config;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public File getLog() {
        if (this.log == null) {
            this.log = new File(this.home, "log");
        }
        return this.log;
    }

    public void setLog(File log) {
        this.log = log;
        this.properties.put(NUXEO_LOG_DIR, log.getAbsolutePath());
    }

    public File getData() {
        if (this.data == null) {
            this.data = new File(this.home, "data");
        }
        return this.data;
    }

    public void setData(File data) {
        this.data = data;
        this.properties.put(NUXEO_DATA_DIR, data.getAbsolutePath());
    }

    public File getWeb() {
        if (this.web == null) {
            this.web = new File(this.home, "web");
        }
        return this.web;
    }

    public void setWeb(File web) {
        this.web = web;
    }

    public String[] getCommandLineArguments() {
        return this.args;
    }

    public void setCommandLineArguments(String[] args) {
        this.args = args;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.properties.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void loadProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public boolean isJBoss() {
        return JBOSS_HOST.equals(this.hostAppName);
    }

    public boolean isJetty() {
        return NXSERVER_HOST.equals(this.hostAppName);
    }

    public boolean isTomcat() {
        return TOMCAT_HOST.equals(this.hostAppName);
    }
}

