/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.clipboard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.webapp.clipboard.SummaryEntry;
import org.nuxeo.ecm.webapp.clipboard.SummaryImpl;
import org.nuxeo.runtime.api.Framework;

public class DocumentListZipExporter {
    public static final String ZIP_ENTRY_ENCODING_PROPERTY = "zip.entry.encoding";
    private static final int BUFFER = 2048;
    private static final String SUMMARY_FILENAME = "INDEX.txt";
    private static final String SUMMARY_HEADER = ".";

    public File exportWorklistAsZip(List<DocumentModel> documents, CoreSession documentManager, boolean exportAllBlobs) throws ClientException, IOException {
        SummaryImpl summary = new SummaryImpl();
        SummaryEntry summaryRoot = new SummaryEntry("", SUMMARY_HEADER, new Date(), "", "", null);
        summaryRoot.setDocumentRef((DocumentRef)new IdRef("0"));
        summary.put(new IdRef("0").toString(), summaryRoot);
        File tmpFile = File.createTempFile("NX-BigZipFile-", ".zip");
        tmpFile.deleteOnExit();
        Framework.trackFile((File)tmpFile, (Object)this);
        FileOutputStream fout = new FileOutputStream(tmpFile);
        ZipOutputStream out = new ZipOutputStream(fout);
        out.setMethod(8);
        out.setLevel(9);
        byte[] data = new byte[2048];
        for (DocumentModel doc : documents) {
            if (doc.getSessionId() == null) {
                doc = documentManager.getDocument(doc.getRef());
            }
            if ("deleted".equals(doc.getCurrentLifeCycleState())) continue;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (doc.isFolder() && !this.isEmptyFolder(doc, documentManager)) {
                SummaryEntry summaryLeaf = new SummaryEntry(doc);
                summaryLeaf.setParent(summaryRoot);
                if (doc.getType().equals("Workspace") || doc.getType().equals("WorkspaceRoot")) {
                    summaryLeaf.setFilename("");
                }
                summary.put(summaryLeaf.getPath(), summaryLeaf);
                this.addFolderToZip("", out, doc, data, documentManager, (SummaryEntry)summary.get(summaryLeaf.getPath()), summary, exportAllBlobs);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip("", out, doc, data, summary.getSummaryRoot(), summary, bh, exportAllBlobs);
        }
        if (summary.size() > 1) {
            this.addSummaryToZip(out, data, summary);
        }
        try {
            out.close();
            fout.close();
        }
        catch (ZipException e) {
            return null;
        }
        return tmpFile;
    }

    private void addFolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data, CoreSession documentManager, SummaryEntry parent, SummaryImpl summary, boolean exportAllBlobs) throws ClientException, IOException {
        String title = (String)doc.getProperty("dublincore", "title");
        DocumentModelList docList = documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if ("deleted".equals(docChild.getCurrentLifeCycleState())) continue;
            BlobHolder bh = (BlobHolder)docChild.getAdapter(BlobHolder.class);
            if (docChild.isFolder() && !this.isEmptyFolder(docChild, documentManager)) {
                SummaryEntry summaryLeaf = new SummaryEntry(docChild);
                if (doc.getType().equals("Workspace") || doc.getType().equals("WorkspaceRoot")) {
                    summaryLeaf.setFilename("");
                }
                summaryLeaf.setParent(parent);
                summary.put(summaryLeaf.getPath(), summaryLeaf);
                this.addFolderToZip(path + title + "/", out, docChild, data, documentManager, (SummaryEntry)summary.get(summaryLeaf.getPath()), summary, exportAllBlobs);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip(path + title + "/", out, docChild, data, (SummaryEntry)summary.get(parent.getPath()), summary, bh, exportAllBlobs);
        }
    }

    private boolean isEmptyFolder(DocumentModel doc, CoreSession documentManager) throws ClientException {
        DocumentModelList docList = documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if (docChild.getAdapter(BlobHolder.class) == null && !docChild.isFolder()) continue;
            return false;
        }
        return true;
    }

    private void addSummaryToZip(ZipOutputStream out, byte[] data, SummaryImpl summary) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(summary.toString());
        StringBlob content = new StringBlob(sb.toString());
        BufferedInputStream buffi = new BufferedInputStream(content.getStream(), 2048);
        ZipEntry entry = new ZipEntry(SUMMARY_FILENAME);
        out.putNextEntry(entry);
        int count = buffi.read(data, 0, 2048);
        while (count != -1) {
            out.write(data, 0, count);
            count = buffi.read(data, 0, 2048);
        }
        out.closeEntry();
        buffi.close();
    }

    private void addBlobHolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data, SummaryEntry parent, SummaryImpl summary, BlobHolder bh, boolean exportAllBlobs) throws IOException, ClientException {
        List<Blob> blobs = new ArrayList();
        if (exportAllBlobs) {
            if (bh.getBlobs() != null) {
                blobs = bh.getBlobs();
            }
        } else {
            Blob mainBlob = bh.getBlob();
            if (mainBlob != null) {
                blobs.add(mainBlob);
            }
        }
        for (Blob content : blobs) {
            String fileName = content.getFilename();
            SummaryEntry summaryLeaf = new SummaryEntry(doc);
            summaryLeaf.setParent(parent);
            summary.put(summaryLeaf.getPath(), summaryLeaf);
            BufferedInputStream buffi = new BufferedInputStream(content.getStream(), 2048);
            int tryCount = 0;
            while (true) {
                try {
                    ZipEntry entry;
                    String entryPath;
                    if (tryCount == 0) {
                        entryPath = path + fileName;
                        entryPath = this.escapeEntryPath(entryPath);
                        entry = new ZipEntry(entryPath);
                    } else {
                        entryPath = path + this.formatFileName(fileName, "(" + tryCount + ")");
                        entryPath = this.escapeEntryPath(entryPath);
                        entry = new ZipEntry(entryPath);
                    }
                    out.putNextEntry(entry);
                }
                catch (ZipException e) {
                    ++tryCount;
                    continue;
                }
                break;
            }
            int count = buffi.read(data, 0, 2048);
            while (count != -1) {
                out.write(data, 0, count);
                count = buffi.read(data, 0, 2048);
            }
            out.closeEntry();
            buffi.close();
        }
    }

    private String formatFileName(String filename, String count) {
        StringBuilder sb = new StringBuilder();
        CharSequence name = filename.subSequence(0, filename.lastIndexOf(SUMMARY_HEADER));
        CharSequence extension = filename.subSequence(filename.lastIndexOf(SUMMARY_HEADER), filename.length());
        sb.append(name).append(count).append(extension);
        return sb.toString();
    }

    protected String escapeEntryPath(String path) {
        String zipEntryEncoding = Framework.getProperty((String)ZIP_ENTRY_ENCODING_PROPERTY);
        if (zipEntryEncoding != null && zipEntryEncoding.equals(ZIP_ENTRY_ENCODING_OPTIONS.ascii.toString())) {
            return StringUtils.toAscii((String)path);
        }
        return path;
    }

    public static enum ZIP_ENTRY_ENCODING_OPTIONS {
        ascii;

    }
}

