/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewHeader;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="documentContentViewActions")
@Scope(value=ScopeType.CONVERSATION)
public class DocumentContentViewActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient ContentViewActions contentViewActions;
    protected Map<String, Map<String, List<ContentViewHeader>>> typeToContentView = new HashMap<String, Map<String, List<ContentViewHeader>>>();
    protected Map<String, List<ContentViewHeader>> currentAvailableContentViews;
    protected Map<String, Map<String, List<ContentViewHeader>>> typeToExportContentView = new HashMap<String, Map<String, List<ContentViewHeader>>>();
    protected Map<String, List<ContentViewHeader>> currentExportContentViews;

    protected Map<String, List<ContentViewHeader>> getContentViewHeaders(TypeInfo typeInfo, boolean export) throws ClientException {
        LinkedHashMap<String, List<ContentViewHeader>> res = new LinkedHashMap<String, List<ContentViewHeader>>();
        Map cvNamesByCat = export ? typeInfo.getContentViewsForExport() : typeInfo.getContentViews();
        if (cvNamesByCat != null) {
            for (Map.Entry cvNameByCat : cvNamesByCat.entrySet()) {
                ArrayList<ContentViewHeader> headers = new ArrayList<ContentViewHeader>();
                String[] cvNames = (String[])cvNameByCat.getValue();
                if (cvNames != null) {
                    for (String cvName : cvNames) {
                        ContentView cv = this.contentViewActions.getContentView(cvName);
                        if (cv == null) continue;
                        headers.add(new ContentViewHeader(cvName, cv.getTitle(), cv.getTranslateTitle(), cv.getIconPath()));
                    }
                }
                res.put((String)cvNameByCat.getKey(), (List<ContentViewHeader>)headers);
            }
        }
        return res;
    }

    protected void retrieveContentViewHeaders(DocumentModel doc) throws ClientException {
        String docType = doc.getType();
        if (!this.typeToContentView.containsKey(docType)) {
            TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
            Map<String, List<ContentViewHeader>> byCategories = this.getContentViewHeaders(typeInfo, false);
            this.typeToContentView.put(docType, byCategories);
        }
    }

    protected void retrieveExportContentViewHeaders(DocumentModel doc) throws ClientException {
        String docType = doc.getType();
        if (!this.typeToExportContentView.containsKey(docType)) {
            TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
            Map<String, List<ContentViewHeader>> byCategories = this.getContentViewHeaders(typeInfo, true);
            this.typeToExportContentView.put(docType, byCategories);
        }
    }

    public boolean hasContentViewSupport(DocumentModel doc, String category) throws ClientException {
        if (doc == null) {
            return false;
        }
        this.retrieveContentViewHeaders(doc);
        String docType = doc.getType();
        if (!this.typeToContentView.get(docType).containsKey(category)) {
            return false;
        }
        return !this.typeToContentView.get(docType).get(category).isEmpty();
    }

    public Map<String, List<ContentViewHeader>> getAvailableContentViewsForDocument(DocumentModel doc) throws ClientException {
        if (doc == null) {
            return Collections.emptyMap();
        }
        this.retrieveContentViewHeaders(doc);
        String docType = doc.getType();
        return this.typeToContentView.get(docType);
    }

    public List<ContentViewHeader> getAvailableContentViewsForDocument(DocumentModel doc, String category) throws ClientException {
        if (doc == null) {
            return Collections.emptyList();
        }
        this.retrieveContentViewHeaders(doc);
        String docType = doc.getType();
        if (!this.typeToContentView.get(docType).containsKey(category)) {
            return Collections.emptyList();
        }
        return this.typeToContentView.get(doc.getType()).get(category);
    }

    public Map<String, List<ContentViewHeader>> getAvailableContentViewsForCurrentDocument() throws ClientException {
        if (this.currentAvailableContentViews == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentAvailableContentViews = this.getAvailableContentViewsForDocument(currentDocument);
        }
        return this.currentAvailableContentViews;
    }

    public List<ContentViewHeader> getAvailableContentViewsForCurrentDocument(String category) throws ClientException {
        this.getAvailableContentViewsForCurrentDocument();
        return this.currentAvailableContentViews.get(category);
    }

    public Map<String, List<ContentViewHeader>> getExportContentViewsForDocument(DocumentModel doc) throws ClientException {
        if (doc == null) {
            return Collections.emptyMap();
        }
        this.retrieveExportContentViewHeaders(doc);
        String docType = doc.getType();
        return this.typeToExportContentView.get(docType);
    }

    public Map<String, List<ContentViewHeader>> getExportContentViewsForCurrentDocument() throws ClientException {
        if (this.currentExportContentViews == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentExportContentViews = this.getExportContentViewsForDocument(currentDocument);
        }
        return this.currentExportContentViews;
    }

    public List<ContentViewHeader> getExportContentViewsForCurrentDocument(String category) throws ClientException {
        this.getExportContentViewsForCurrentDocument();
        return this.currentExportContentViews.get(category);
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void documentChanged() {
        this.currentAvailableContentViews = null;
        this.currentExportContentViews = null;
    }
}

