/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.documentsLists;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Remove;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.webapp.documentsLists.BaseDocumentsListsManager;
import org.nuxeo.ecm.webapp.documentsLists.ConversationDocumentsListsManager;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Name(value="documentsListsManager")
@Scope(value=ScopeType.SESSION)
public class DocumentsListsManagerBean
extends BaseDocumentsListsManager
implements DocumentsListsManager {
    private static final long serialVersionUID = 2895324573454635971L;
    private Boolean initialized = false;
    @In(create=true)
    private ConversationDocumentsListsManager conversationDocumentsListsManager;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(create=true)
    private transient Principal currentUser;
    private DocumentRef lastDocumentRef;

    @Override
    protected void notifyListUpdated(String listName) {
        Events.instance().raiseEvent(listName + "Updated", new Object[0]);
    }

    @Override
    @Remove
    @Destroy
    public void destroy() {
    }

    @Override
    @Create
    public void initListManager() {
        if (!this.initialized.booleanValue()) {
            super.setUserName(this.currentUser.getName());
            List<String> listContribNames = this.getService().getDocumentsListDescriptorsName();
            for (String listName : listContribNames) {
                DocumentsListDescriptor desc = this.getService().getDocumentsListDescriptor(listName);
                if (desc.getIsSession()) {
                    super.createWorkingList(listName, desc, this.documentManager, this.currentUser.getName());
                    continue;
                }
                this.documentsLists_descriptors.put(listName, desc);
            }
            this.initialized = true;
        }
    }

    @Override
    public void createWorkingList(String listName, DocumentsListDescriptor descriptor) {
        if (descriptor.getIsSession()) {
            super.createWorkingList(listName, descriptor);
        } else {
            this.conversationDocumentsListsManager.createWorkingList(listName, descriptor);
            this.documentsLists_descriptors.put(listName, descriptor);
        }
    }

    @Override
    public List<DocumentModel> getWorkingList(String listName) {
        if (this.isSessionOrIsNull(listName)) {
            return super.getWorkingList(listName);
        }
        return this.conversationDocumentsListsManager.getWorkingList(listName);
    }

    @Override
    public List<String> getWorkingListTypes(String listName) {
        if (this.isSessionOrIsNull(listName)) {
            return super.getWorkingListTypes(listName);
        }
        return this.conversationDocumentsListsManager.getWorkingListTypes(listName);
    }

    @Override
    public void setWorkingList(String listName, List<DocumentModel> docList) {
        if (this.isSessionOrIsNull(listName)) {
            super.setWorkingList(listName, docList);
        } else {
            this.conversationDocumentsListsManager.setWorkingList(listName, docList);
        }
    }

    @Override
    public List<DocumentModel> addToWorkingList(String listName, DocumentModel doc) {
        if (this.isSessionOrIsNull(listName)) {
            return super.addToWorkingList(listName, doc);
        }
        return this.conversationDocumentsListsManager.addToWorkingList(listName, doc);
    }

    @Override
    public List<DocumentModel> addToWorkingList(String listName, List<DocumentModel> docList) {
        if (this.isSessionOrIsNull(listName)) {
            return super.addToWorkingList(listName, docList);
        }
        return this.conversationDocumentsListsManager.addToWorkingList(listName, docList);
    }

    @Override
    public List<DocumentModel> addToWorkingList(String listName, List<DocumentModel> docList, Boolean forceAppend) {
        if (this.isSessionOrIsNull(listName)) {
            return super.addToWorkingList(listName, docList, forceAppend);
        }
        return this.conversationDocumentsListsManager.addToWorkingList(listName, docList, forceAppend);
    }

    @Override
    public List<DocumentModel> removeFromWorkingList(String listName, DocumentModel doc) {
        if (this.isSessionOrIsNull(listName)) {
            return super.removeFromWorkingList(listName, doc);
        }
        return this.conversationDocumentsListsManager.removeFromWorkingList(listName, doc);
    }

    @Override
    public List<DocumentModel> removeFromWorkingList(String listName, List<DocumentModel> lst) {
        if (this.isSessionOrIsNull(listName)) {
            return super.removeFromWorkingList(listName, lst);
        }
        return this.conversationDocumentsListsManager.removeFromWorkingList(listName, lst);
    }

    @Override
    public List<DocumentModel> resetWorkingList(String listName) {
        if (this.isSessionOrIsNull(listName)) {
            return super.resetWorkingList(listName);
        }
        return this.conversationDocumentsListsManager.resetWorkingList(listName);
    }

    @Override
    public List<DocumentModel> resetWorkingList(String listName, List<DocumentModel> newDocList) {
        if (this.isSessionOrIsNull(listName)) {
            return super.resetWorkingList(listName, newDocList);
        }
        return this.conversationDocumentsListsManager.resetWorkingList(listName, newDocList);
    }

    @Override
    public boolean isWorkingListEmpty(String listName) {
        if (this.isSessionOrIsNull(listName)) {
            return super.isWorkingListEmpty(listName);
        }
        return this.conversationDocumentsListsManager.isWorkingListEmpty(listName);
    }

    @Override
    public void removeFromAllLists(List<DocumentModel> documentsToRemove) {
        super.removeFromAllLists(documentsToRemove);
        this.conversationDocumentsListsManager.removeFromAllLists(documentsToRemove);
    }

    @Override
    public List<String> getWorkingListNamesForCategory(String categoryName) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(super.getWorkingListNamesForCategory(categoryName));
        result.addAll(this.conversationDocumentsListsManager.getWorkingListNamesForCategory(categoryName));
        return result;
    }

    @Override
    public DocumentsListDescriptor getWorkingListDescriptor(String listName) {
        return super.getWorkingListDescriptor(listName);
    }

    @Override
    public List<DocumentModel> getWorkingList() {
        return this.getWorkingList("DEFAULT");
    }

    @Override
    public DocumentsListDescriptor getWorkingListDescriptor() {
        return this.getWorkingListDescriptor("DEFAULT");
    }

    @Override
    public List<String> getWorkingListTypes() {
        return this.getWorkingListTypes("DEFAULT");
    }

    @Override
    public void setWorkingList(List<DocumentModel> docList) {
        this.setWorkingList("DEFAULT", docList);
    }

    @Override
    public List<DocumentModel> addToWorkingList(DocumentModel doc) {
        return this.addToWorkingList("DEFAULT", doc);
    }

    @Override
    public List<DocumentModel> addToWorkingList(List<DocumentModel> docList) {
        return this.addToWorkingList("DEFAULT", docList, false);
    }

    @Override
    public List<DocumentModel> removeFromWorkingList(DocumentModel doc) {
        return this.removeFromWorkingList("DEFAULT", doc);
    }

    @Override
    public List<DocumentModel> resetWorkingList() {
        return this.resetWorkingList("DEFAULT");
    }

    @Override
    public List<DocumentModel> resetWorkingList(List<DocumentModel> newDocList) {
        this.resetWorkingList();
        return this.addToWorkingList(newDocList);
    }

    @Override
    public boolean isWorkingListEmpty() {
        return this.isWorkingListEmpty("DEFAULT");
    }

    @Override
    @Observer(value={"folderishDocumentSelectionChanged"}, create=false)
    public void refreshLists(DocumentModel currentDocument) {
        if (this.lastDocumentRef != null && this.lastDocumentRef.equals(currentDocument.getRef())) {
            return;
        }
        if (!this.documentsLists_events.containsKey("folderishDocumentSelectionChanged")) {
            return;
        }
        for (String listName : (List)this.documentsLists_events.get("folderishDocumentSelectionChanged")) {
            if (this.getWorkingList(listName) == null) continue;
            ((List)this.documentsLists.get(listName)).clear();
            this.notifyListUpdated(listName);
        }
        this.lastDocumentRef = currentDocument.getRef();
    }

    @Observer(value={"searchPerformed"}, create=false)
    public void refreshListsOnSearch() {
        if (!this.documentsLists_events.containsKey("searchPerformed")) {
            return;
        }
        for (String listName : (List)this.documentsLists_events.get("searchPerformed")) {
            List docList = (List)this.documentsLists.get(listName);
            if (docList.isEmpty()) continue;
            docList.clear();
            this.notifyListUpdated(listName);
        }
    }

    private boolean isSessionOrIsNull(String listName) {
        DocumentsListDescriptor desc = (DocumentsListDescriptor)this.documentsLists_descriptors.get(listName);
        return desc == null || desc.getIsSession();
    }

    private boolean isPersistent(String listName) {
        DocumentsListDescriptor desc = (DocumentsListDescriptor)this.documentsLists_descriptors.get(listName);
        if (desc == null) {
            return false;
        }
        return desc.getPersistent();
    }
}

