/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.ejb;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.EJBContext;
import javax.ejb.Local;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.interceptor.Interceptors;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.security.SecurityDomain;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.CallerPrincipalProvider;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.RollbackClientException;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.ejb.DocumentManagerLocal;
import org.nuxeo.ecm.core.api.ejb.ReentrantCallsShieldInterceptor;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.SecuritySummaryEntry;
import org.nuxeo.ecm.core.model.NoSuchRepositoryException;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;

@Stateful
@Local(value={DocumentManagerLocal.class})
@Remote(value={CoreSession.class})
@SecurityDomain(value="nuxeo-ecm")
@Interceptors(value={ReentrantCallsShieldInterceptor.class})
public class DocumentManagerBean
extends AbstractSession
implements DocumentManagerLocal,
SessionSynchronization {
    private static final long serialVersionUID = 6781675353273516393L;
    private static final Log log = LogFactory.getLog(DocumentManagerBean.class);
    private static final String CONTEXT_PRINCIPAL_KEY = "principal";
    private Boolean supportsTags = null;
    @Transient
    protected transient Session session;
    @Resource
    protected EJBContext context;
    protected Principal callerPrincipal = null;

    @Remove
    @PermitAll
    public void destroy() {
        log.debug((Object)"@Remove");
    }

    @PreDestroy
    public void preDestroy() {
        log.debug((Object)"@PreDestroy");
        super.destroy();
    }

    @PostActivate
    public void readState() {
        log.debug((Object)"@PostActivate");
        CoreInstance.getInstance().registerSession(this.getSessionId(), (CoreSession)this);
    }

    @PrePassivate
    public void prePassivate() {
        log.debug((Object)"@Prepassivate");
        try {
            if (this.session != null && this.session.isLive()) {
                this.session.close();
            }
            this.session = null;
        }
        catch (Exception e) {
            log.error((Object)"Failed to close session", (Throwable)e);
        }
    }

    protected Principal getCallerPrincipal() {
        NuxeoPrincipal np;
        if (this.callerPrincipal == null) {
            this.callerPrincipal = this.context.getCallerPrincipal();
        }
        if (!(this.callerPrincipal instanceof NuxeoPrincipal) && (np = CallerPrincipalProvider.getInstance().getCallerPrincipal()) != null) {
            this.callerPrincipal = np;
        }
        return this.callerPrincipal;
    }

    public Principal getPrincipal() {
        Principal principal;
        try {
            if (this.sessionContext == null) {
                this.sessionContext = this.getSession().getSessionContext();
            }
            if ((principal = (Principal)this.sessionContext.get(CONTEXT_PRINCIPAL_KEY)) == null) {
                principal = this.getCallerPrincipal();
                this.sessionContext.put(CONTEXT_PRINCIPAL_KEY, (Serializable)((Object)principal));
            }
        }
        catch (Throwable t) {
            return null;
        }
        assert (principal != null);
        return principal;
    }

    public String connect(String repositoryName, Map<String, Serializable> sessionContext) throws ClientException {
        try {
            log.debug((Object)("URI: " + repositoryName));
            if (sessionContext == null) {
                sessionContext = new HashMap<String, Serializable>();
            }
            if (!sessionContext.containsKey(CONTEXT_PRINCIPAL_KEY)) {
                log.debug((Object)"Add caller principal to the session context....");
                sessionContext.put(CONTEXT_PRINCIPAL_KEY, (Serializable)((Object)this.getCallerPrincipal()));
            } else {
                log.debug((Object)"Principal already within the session context...");
            }
            return super.connect(repositoryName, sessionContext);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public synchronized Session getSession() throws ClientException {
        assert (this.repositoryName != null);
        if (this.session == null || !this.session.isLive()) {
            log.debug((Object)("Initializing session for repository: " + this.repositoryName));
            try {
                this.session = this.createSession(this.repositoryName, "default", this.sessionContext);
            }
            catch (Exception e) {
                throw ClientException.wrap((Throwable)e);
            }
        }
        return this.session;
    }

    public boolean supportsTags(String repositoryName) throws ClientException {
        try {
            Repository repo = NXCore.getRepository((String)repositoryName);
            return repo.supportsTags();
        }
        catch (Exception e) {
            throw new ClientException("Failed to load repository " + repositoryName, (Throwable)e);
        }
    }

    public boolean supportsTags() throws ClientException {
        if (this.supportsTags != null) {
            return this.supportsTags;
        }
        throw new ClientException("Can not query on a closed repository");
    }

    protected Session createSession(String repoName, String ws, Map<String, Serializable> context) throws DocumentException, NoSuchRepositoryException {
        Repository repo = NXCore.getRepository((String)repoName);
        this.supportsTags = repo.supportsTags();
        return repo.getSession(context);
    }

    public boolean isStateSharedByAllThreadSessions() {
        return true;
    }

    public boolean isSessionAlive() {
        return this.session != null && this.session.isLive();
    }

    public List<SecuritySummaryEntry> getSecuritySummary(DocumentModel docModel, Boolean includeParents) throws ClientException {
        try {
            return super.getSecuritySummary(docModel, includeParents);
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public DocumentModel createDocument(DocumentModel docModel) throws ClientException {
        try {
            return super.createDocument(docModel);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel[] createDocument(DocumentModel[] docModels) throws ClientException {
        try {
            return super.createDocument(docModels);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void save() throws ClientException {
        try {
            super.save();
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel saveDocument(DocumentModel docModel) throws ClientException {
        try {
            return super.saveDocument(docModel);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void saveDocuments(DocumentModel[] docModels) throws ClientException {
        try {
            super.saveDocuments(docModels);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void removeDocuments(DocumentRef[] docRefs) throws ClientException {
        try {
            super.removeDocuments(docRefs);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void removeChildren(DocumentRef docRef) throws ClientException {
        try {
            super.removeChildren(docRef);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel copy(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            return super.copy(src, dst, name);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public List<DocumentModel> copy(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        try {
            return super.copy(src, dst);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel copyProxyAsDocument(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            return super.copyProxyAsDocument(src, dst, name);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        try {
            return super.copyProxyAsDocument(src, dst);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel move(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            return super.move(src, dst, name);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void move(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        try {
            super.move(src, dst);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void setACP(DocumentRef docRef, ACP newAcp, boolean overwrite) throws ClientException {
        try {
            super.setACP(docRef, newAcp, overwrite);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, VersionModel version) throws ClientException {
        try {
            return super.restoreToVersion(docRef, version);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void checkOut(DocumentRef docRef) throws ClientException {
        try {
            super.checkOut(docRef);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentRef checkIn(DocumentRef docRef, VersioningOption option, String checkinComment) throws ClientException {
        try {
            return super.checkIn(docRef, option, checkinComment);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    @Deprecated
    public DocumentModel checkIn(DocumentRef docRef, VersionModel version) throws ClientException {
        try {
            return super.checkIn(docRef, version);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel createProxy(DocumentRef docRef, DocumentRef folderRef) throws ClientException {
        try {
            return super.createProxy(docRef, folderRef);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel createProxy(DocumentRef parentRef, DocumentRef docRef, VersionModel version, boolean overwriteExistingProxy) throws ClientException {
        try {
            return super.createProxy(parentRef, docRef, version, overwriteExistingProxy);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public boolean followTransition(DocumentRef docRef, String transition) throws ClientException {
        try {
            return super.followTransition(docRef, transition);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void setLock(DocumentRef docRef, String key) throws ClientException {
        try {
            super.setLock(docRef, key);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public String unlock(DocumentRef docRef) throws ClientException {
        try {
            return super.unlock(docRef);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel publishDocument(DocumentModel docToPublish, DocumentModel section) throws ClientException {
        try {
            return super.publishDocument(docToPublish, section);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public DocumentModel publishDocument(DocumentModel docToPublish, DocumentModel section, boolean overwriteExistingProxy) throws ClientException {
        try {
            return super.publishDocument(docToPublish, section, overwriteExistingProxy);
        }
        catch (Throwable e) {
            throw new RollbackClientException(e);
        }
    }

    public void importDocuments(List<DocumentModel> docModels) throws ClientException {
        try {
            super.importDocuments(docModels);
        }
        catch (Throwable t) {
            throw new RollbackClientException("Error during document import", t);
        }
    }

    public DocumentModel getSourceDocument(DocumentRef docRef) throws ClientException {
        try {
            return super.getSourceDocument(docRef);
        }
        catch (Throwable t) {
            throw new RollbackClientException(t);
        }
    }

    public List<VersionModel> getVersionsForDocument(DocumentRef docRef) throws ClientException {
        try {
            return super.getVersionsForDocument(docRef);
        }
        catch (Throwable t) {
            throw new RollbackClientException(t);
        }
    }

    public DocumentModel getLastDocumentVersion(DocumentRef docRef) throws ClientException {
        try {
            return super.getLastDocumentVersion(docRef);
        }
        catch (Throwable t) {
            throw new RollbackClientException(t);
        }
    }

    public DocumentRef getLastDocumentVersionRef(DocumentRef docRef) throws ClientException {
        try {
            return super.getLastDocumentVersionRef(docRef);
        }
        catch (Throwable t) {
            throw new RollbackClientException(t);
        }
    }

    public List<DocumentModel> getVersions(DocumentRef docRef) throws ClientException {
        try {
            return super.getVersions(docRef);
        }
        catch (Throwable t) {
            throw new RollbackClientException(t);
        }
    }
}

