/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.wss.backend.NuxeoWSSBackend;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.WSSSecurityException;
import org.nuxeo.wss.spi.AbstractWSSBackend;

public abstract class AbstractNuxeoCoreBackend
extends AbstractWSSBackend
implements NuxeoWSSBackend {
    protected static final Log log = LogFactory.getLog(AbstractNuxeoCoreBackend.class);
    protected CoreSession session;

    public void begin() throws WSSException {
        if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.startTransaction();
        }
    }

    protected CoreSession getCoreSession() throws Exception {
        if (this.session == null) {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            this.session = rm.getDefaultRepository().open();
        }
        return this.session;
    }

    protected void close() {
        if (this.session != null) {
            CoreInstance.getInstance().close(this.session);
            this.session = null;
        }
    }

    public void discardChanges() throws WSSException {
        this.discardChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardChanges(boolean release) throws WSSException {
        block6: {
            TransactionHelper.setTransactionRollbackOnly();
            try {
                if (this.session == null) break block6;
                try {
                    this.session.cancel();
                    if (release) {
                        this.close();
                    }
                }
                catch (Exception e) {
                    throw new WSSException("Error during discard", (Throwable)e);
                }
            }
            finally {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    public void saveChanges() throws WSSException {
        this.saveChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChanges(boolean release) throws WSSException {
        block6: {
            try {
                if (this.session == null) break block6;
                try {
                    this.session.save();
                    if (release) {
                        this.close();
                    }
                }
                catch (ClientException e) {
                    throw new WSSException("Error during save", (Throwable)e);
                }
            }
            finally {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAccess(DocumentRef targetRef, String perm) throws WSSSecurityException {
        block5: {
            boolean granted = false;
            try {
                granted = this.getCoreSession().hasPermission(targetRef, perm);
            }
            catch (Exception e) {
                log.error((Object)("Errir while checking permissions on " + targetRef.toString()), (Throwable)e);
                granted = false;
            }
            finally {
                if (granted) break block5;
                throw new WSSSecurityException("Perm " + perm + " not granted on document (" + targetRef.toString() + ")");
            }
        }
    }
}

