/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.wss.backend;

import org.nuxeo.wss.servlet.WSSRequest;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSBackendFactory;

public abstract class AbstractWSSBackendFactory
implements WSSBackendFactory {
    public static final String BACKEND_KEY = "org.nuxeo.ecm.platform.wss.backend";

    protected String computeVirtualRoot(WSSRequest request) {
        String virtualRoot = null;
        virtualRoot = request == null ? System.getProperty("org.nuxeo.ecm.contextPath", "/nuxeo") : request.getSitePath();
        if (virtualRoot == null || virtualRoot.equals("")) {
            virtualRoot = request.getHttpRequest().getContextPath();
        }
        if (virtualRoot.startsWith("/")) {
            virtualRoot = virtualRoot.substring(1);
        }
        return virtualRoot;
    }

    public WSSBackend getBackend(WSSRequest request) {
        if (request == null) {
            return this.createBackend(null);
        }
        request.getHttpRequest().getSession(true);
        Object object = request.getHttpRequest().getAttribute(BACKEND_KEY);
        if (object != null) {
            return (WSSBackend)object;
        }
        WSSBackend backend = this.createBackend(request);
        request.getHttpRequest().setAttribute(BACKEND_KEY, (Object)backend);
        return backend;
    }

    protected abstract WSSBackend createBackend(WSSRequest var1);
}

