/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.runtime.api.Framework;

public class ReconnectedEventBundleImpl
implements ReconnectedEventBundle {
    private static final long serialVersionUID = 1L;
    protected EventBundle sourceEventBundle;
    protected List<Event> reconnectedEvents;
    protected LoginContext loginCtx;
    protected CoreSession reconnectedCoreSession;
    private static final Log log = LogFactory.getLog(ReconnectedEventBundleImpl.class);

    public ReconnectedEventBundleImpl() {
    }

    public ReconnectedEventBundleImpl(EventBundle sourceEventBundle) {
        this.sourceEventBundle = sourceEventBundle;
    }

    protected CoreSession getReconnectedCoreSession(String repoName) {
        if (this.reconnectedCoreSession == null) {
            try {
                this.loginCtx = Framework.login();
            }
            catch (LoginException e) {
                log.error((Object)"Can not connect", (Throwable)e);
                return null;
            }
            try {
                Repository repo;
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                if (repoName != null) {
                    repo = mgr.getRepository(repoName);
                } else {
                    repo = mgr.getDefaultRepository();
                    repoName = repo.getName();
                }
                this.reconnectedCoreSession = repo.open();
            }
            catch (Exception e) {
                log.error((Object)("Error while openning core session on repo " + repoName), (Throwable)e);
                return null;
            }
        }
        if (!this.reconnectedCoreSession.getRepositoryName().equals(repoName) && repoName != null) {
            throw new IllegalStateException("Can no reconnected a Bundle tied to several Core instances !");
        }
        return this.reconnectedCoreSession;
    }

    protected List<Event> getReconnectedEvents() {
        if (this.reconnectedEvents == null) {
            this.reconnectedEvents = new ArrayList<Event>();
            for (Event event : this.sourceEventBundle) {
                DocumentModel oldDoc;
                EventContext ctx = event.getContext();
                CoreSession session = ctx.getRepositoryName() == null ? null : this.getReconnectedCoreSession(ctx.getRepositoryName());
                ArrayList<Object> newArgs = new ArrayList<Object>();
                Object[] arr$ = ctx.getArguments();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    DocumentRef ref;
                    Object arg;
                    Object newArg = arg = arr$[i$];
                    if (arg instanceof DocumentModel && session != null && session.getPrincipal() != null && (ref = (oldDoc = (DocumentModel)arg).getRef()) != null) {
                        try {
                            newArg = session.exists(oldDoc.getRef()) ? session.getDocument(oldDoc.getRef()) : new DeletedDocumentModel(oldDoc);
                        }
                        catch (ClientException e) {
                            log.error((Object)("Can not refetch Doc with ref " + ref.toString()), (Throwable)e);
                        }
                    }
                    newArgs.add(newArg);
                }
                EventContextImpl newCtx = null;
                if (ctx instanceof DocumentEventContext) {
                    newCtx = new DocumentEventContext(session, ctx.getPrincipal(), (DocumentModel)newArgs.get(0), (DocumentRef)newArgs.get(1));
                } else {
                    newCtx = new EventContextImpl(session, ctx.getPrincipal());
                    newCtx.setArgs(newArgs.toArray());
                }
                HashMap<String, Serializable> newProps = new HashMap<String, Serializable>();
                for (Map.Entry<String, Serializable> prop : ctx.getProperties().entrySet()) {
                    Serializable propValue = prop.getValue();
                    if (propValue instanceof DocumentModel && session != null) {
                        oldDoc = (DocumentModel)propValue;
                        try {
                            propValue = session.getDocument(oldDoc.getRef());
                        }
                        catch (ClientException e) {
                            log.error((Object)("Can not refetch Doc with ref " + oldDoc.getRef().toString()), (Throwable)e);
                        }
                    }
                    newProps.put(prop.getKey(), propValue);
                }
                newCtx.setProperties(newProps);
                EventImpl newEvt = new EventImpl(event.getName(), newCtx, event.getFlags(), event.getTime());
                this.reconnectedEvents.add(newEvt);
            }
        }
        return this.reconnectedEvents;
    }

    @Override
    public String getName() {
        return this.sourceEventBundle.getName();
    }

    @Override
    public VMID getSourceVMID() {
        return this.sourceEventBundle.getSourceVMID();
    }

    @Override
    public boolean hasRemoteSource() {
        return this.sourceEventBundle.hasRemoteSource();
    }

    @Override
    public boolean isEmpty() {
        return this.sourceEventBundle.isEmpty();
    }

    @Override
    public Event peek() {
        return this.getReconnectedEvents().get(0);
    }

    @Override
    public void push(Event event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.sourceEventBundle.size();
    }

    @Override
    public Iterator<Event> iterator() {
        return this.getReconnectedEvents().iterator();
    }

    @Override
    public void disconnect() {
        if (this.reconnectedCoreSession != null) {
            CoreInstance.getInstance().close(this.reconnectedCoreSession);
        }
        if (this.loginCtx != null) {
            try {
                this.loginCtx.logout();
            }
            catch (LoginException e) {
                log.error((Object)"Error while logging out", (Throwable)e);
            }
        }
    }

    @Override
    public boolean comesFromJMS() {
        return false;
    }

    @Override
    public boolean containsEventName(String eventName) {
        return this.sourceEventBundle.containsEventName(eventName);
    }
}

