/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.List;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.server.jaxrs.io.MultipartBlobs;
import org.nuxeo.ecm.core.api.Blob;

public class ResponseHelper {
    public static Response notFound() {
        return Response.status((int)404).build();
    }

    public static Response emptyContent() {
        return Response.status((int)204).build();
    }

    public static Response notAllowed() {
        return Response.status((int)401).build();
    }

    public static Response blob(Blob blob) {
        String type = blob.getMimeType();
        if (type == null) {
            type = "application/octet-stream";
        }
        return Response.ok((Object)blob).type(type).header("Content-Disposition", (Object)("attachment; filename=" + blob.getFilename())).build();
    }

    public static Response blobs(List<Blob> blobs) throws Exception {
        return new MultipartBlobs(blobs).getResponse();
    }
}

